/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.DTAExtractor;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAZVExtractor;
import de.businesslogics.format.dta.DTAZVItem;
import de.businesslogics.format.dta.DTAZVLogicalFile;
import de.businesslogics.format.dta.DTAZV_TBlock;
import de.businesslogics.format.dta.InvalidAccountNumberException;
import de.businesslogics.format.dta.InvalidBankcodeException;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.util.Currency;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Ticket
implements DisplayMessage {
    private static final long serialVersionUID = 1L;
    private boolean isBBKFile = false;
    private boolean containsSalaryPayments = false;
    private final List list;
    private String currencyCode;

    public Ticket(List tickets) {
        this(false, tickets);
    }

    public Ticket(boolean isBBKFile, List tickets) {
        this.isBBKFile = isBBKFile;
        this.list = tickets;
    }

    public Ticket(boolean isBBKFile, List tickets, boolean containsSalaryPayments) {
        this.isBBKFile = isBBKFile;
        this.list = tickets;
        this.containsSalaryPayments = containsSalaryPayments;
    }

    @Override
    public void appendText(Locale l, StringBuilder buffer) {
        ResourceBundle b = ResourceBundle.getBundle(Ticket.class.getName(), l);
        SimpleDateFormat df = new SimpleDateFormat(b.getString("DATE_FORMAT"));
        DecimalFormat nf = new DecimalFormat(b.getString("EUR_FORMAT"));
        NumberFormat decFormat = DecimalFormat.getIntegerInstance(l);
        boolean first = true;
        boolean warnRegulatoryReporting = false;
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof DTAUSLogicalFile) {
                this.appendText((DTAUSLogicalFile)obj, buffer, b, df, nf, first, !i.hasNext());
            } else if (obj instanceof DTAZVLogicalFile) {
                DTAZVLogicalFile azv = (DTAZVLogicalFile)obj;
                this.appendText(azv, l, buffer, b, df, decFormat);
                warnRegulatoryReporting |= azv.isWarnRegulatoryBlock();
            }
            first = false;
        }
        if (warnRegulatoryReporting) {
            buffer.append(b.getString("DTAZVRegulatoryBlockWarning"));
        }
    }

    public BigDecimal getTotalAmountInAnyCurrency() {
        BigDecimal total = BigDecimal.ZERO;
        for (Object o : this.list) {
            if (!(o instanceof DTAZVLogicalFile)) continue;
            long l = ((DTAZVLogicalFile)o).getTotalAmount();
            total = total.add(new BigDecimal(l / 1000L));
        }
        return total;
    }

    public BigDecimal getTotalAmount() throws Exception {
        long amt = 0L;
        BigDecimal amount = BigDecimal.ZERO;
        int fractionDigits = 2;
        this.currencyCode = null;
        for (Object o : this.list) {
            String currencyCodeFromLF;
            Serializable lf;
            if (o instanceof BundesbankDtaLogicalFile) {
                lf = (BundesbankDtaLogicalFile)o;
                currencyCodeFromLF = ((BundesbankDtaLogicalFile)lf).getUniqueCurrencyCode();
                if (currencyCodeFromLF == null) {
                    return null;
                }
                if (this.currencyCode == null) {
                    this.currencyCode = currencyCodeFromLF;
                } else if (!this.currencyCode.equals(currencyCodeFromLF)) {
                    this.currencyCode = null;
                    return null;
                }
                long amtLF = ((BundesbankDtaLogicalFile)lf).getSumAmount();
                if (amtLF == 0L) {
                    amount = amount.add(((BundesbankDtaLogicalFile)lf).getTotalAmount());
                }
                amt += amtLF;
                continue;
            }
            if (o instanceof DTAUSLogicalFile) {
                lf = (DTAUSLogicalFile)o;
                amt += ((DTAUSLogicalFile)lf).getSumAmount();
                continue;
            }
            if (!(o instanceof DTAZVLogicalFile)) continue;
            lf = (DTAZVLogicalFile)o;
            currencyCodeFromLF = ((DTAZVLogicalFile)lf).getUniqueCurrencyCode();
            if (currencyCodeFromLF == null) {
                return null;
            }
            if (this.currencyCode == null) {
                fractionDigits = 3;
                this.currencyCode = currencyCodeFromLF;
            } else if (!this.currencyCode.equals(currencyCodeFromLF)) {
                this.currencyCode = null;
                return null;
            }
            amt += ((DTAZVLogicalFile)lf).getTotalAmount();
        }
        if (amt > 0L) {
            return new BigDecimal(amt).movePointLeft(fractionDigits);
        }
        return amount;
    }

    public Currency getCurrency() {
        if (this.currencyCode != null) {
            return Currency.getInstance(this.currencyCode);
        }
        return null;
    }

    public boolean containsSalaryPayments() {
        return this.containsSalaryPayments;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.appendText(Locale.getDefault(), buffer);
        return buffer.toString();
    }

    private void appendText(DTAUSLogicalFile file, StringBuilder buffer, ResourceBundle b, SimpleDateFormat df, DecimalFormat nf, boolean first, boolean last) {
        if (file instanceof BundesbankDtaLogicalFile) {
            this.isBBKFile = true;
        }
        if (first) {
            buffer.append("    ");
            buffer.append(b.getString("SEP_LINE"));
            buffer.append("\r\n");
        }
        buffer.append("     ");
        String fileType = null;
        if (this.isBBKFile) {
            buffer.append(b.getString("PAYMENT_TYPE"));
            fileType = file.getFileType();
            buffer.append(fileType);
        } else if (file.isDebit()) {
            buffer.append(b.getString("DEBIT"));
        } else {
            buffer.append(b.getString("CREDIT"));
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("BANK_CODE"));
        buffer.append(Integer.toString(file.getOrigBankcode()));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("ACCOUNT_NUMBER"));
        buffer.append(Long.toString(file.getOrigAccount()));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("ORIGINATOR"));
        buffer.append(new String(file.getOriginator()));
        if (this.isBBKFile) {
            buffer.append("\r\n");
            buffer.append("     ");
            buffer.append(b.getString("FILE_NUMBER"));
            buffer.append(String.valueOf(file.getFileNumber()));
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("CREATION_DATE"));
        try {
            buffer.append(df.format(file.getCreation()));
        }
        catch (ParseException parse) {
            buffer.append(new String(file.getCreationDate()));
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("NUMBER_OF_PAYMENTS"));
        try {
            boolean isPackedDta;
            buffer.append(file.getNumberOfPayments());
            buffer.append("\r\n");
            buffer.append("     ");
            if (fileType == null || !"WT".equals(fileType)) {
                if ("GS".equals(fileType)) {
                    buffer.append(b.getString("NUMBER_EUR_AMOUNT"));
                } else {
                    buffer.append(b.getString("NUMBER_OF_AMOUNT"));
                }
            } else {
                buffer.append(b.getString("SUM_AMOUNT"));
            }
            buffer.append(nf.format(0.01 * (double)file.getSumAmount()));
            boolean bl = isPackedDta = !(file instanceof BundesbankDtaLogicalFile) && ("GK".equals(fileType) || "LK".equals(fileType) || "GB".equals(fileType) || "LB".equals(fileType));
            if (!this.isBBKFile || isPackedDta) {
                buffer.append("\r\n");
                buffer.append("     ");
                buffer.append(b.getString("NUMBER_OF_ACCOUNT"));
                buffer.append(file.getSumAccount());
                buffer.append("\r\n");
                buffer.append("     ");
                buffer.append(b.getString("NUMBER_OF_BANKCODE"));
                buffer.append(file.getSumBankcode());
            }
        }
        catch (InvalidFileException isPackedDta) {
            // empty catch block
        }
        if (!this.isBBKFile) {
            buffer.append("\r\n");
            buffer.append("     ");
            buffer.append(b.getString("EXECUTION_DATE"));
            try {
                Date d = file.getExecution();
                if (d != null) {
                    buffer.append(df.format(d));
                }
            }
            catch (ParseException parse) {
                buffer.append(file.getExecutionDate());
            }
        }
        buffer.append("\r\n");
        buffer.append("    ");
        if (last) {
            buffer.append(b.getString("SEP_LINE"));
        } else {
            buffer.append(b.getString("SEP"));
        }
        buffer.append("\r\n");
    }

    private void appendText(DTAZVLogicalFile file, Locale l, StringBuilder buffer, ResourceBundle b, SimpleDateFormat df, NumberFormat decFormat) {
        buffer.append("    ");
        buffer.append(b.getString("SEP_LINE"));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("BANK_CODE"));
        try {
            buffer.append(file.getOrigBankcode());
        }
        catch (InvalidBankcodeException invalidBankcodeException) {
            // empty catch block
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("CUSTOMER_NUMBER"));
        try {
            buffer.append(file.getOrigCustomerId());
        }
        catch (InvalidAccountNumberException invalidAccountNumberException) {
            // empty catch block
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("ORIGINATOR2"));
        buffer.append(file.getOriginatorLine(0));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("BLANKS"));
        buffer.append(file.getOriginatorLine(1));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("BLANKS"));
        buffer.append(file.getOriginatorLine(2));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("BLANKS"));
        buffer.append(file.getOriginatorLine(3));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("CREATION_DATE"));
        try {
            buffer.append(df.format(file.getCreationDate()));
        }
        catch (InvalidFileException invalidFileException) {
            // empty catch block
        }
        for (Map.Entry<DTAZV_TBlock, Long> entry : file.getTBlocks().entrySet()) {
            buffer.append("\r\n");
            buffer.append("    ");
            buffer.append(b.getString("SEP"));
            this.appendText(entry.getKey(), entry.getValue(), l, buffer, b, df);
        }
        buffer.append("\r\n");
        buffer.append("    ");
        buffer.append(b.getString("SEP"));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("NUMBER_T_BLOCKS"));
        try {
            buffer.append(file.getNumberOfPayments());
        }
        catch (InvalidFileException invalidFileException) {
            // empty catch block
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("SUM_AMOUNT"));
        try {
            buffer.append(decFormat.format(file.getSumAmount()));
        }
        catch (InvalidFileException invalidFileException) {
            // empty catch block
        }
        buffer.append("\r\n");
        buffer.append("    ");
        buffer.append(b.getString("SEP_LINE"));
        buffer.append("\r\n");
    }

    private void appendText(DTAZV_TBlock t, Long amount, Locale l, StringBuilder buffer, ResourceBundle b, SimpleDateFormat df) {
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("ORIG_CURRENCY"));
        buffer.append(new String(t.getCurrency()));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("BANK_CODE"));
        buffer.append(new String(t.getBankcode()));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("ACCOUNT_CURRENCY"));
        String cur = new String(t.getAccountCurrency());
        buffer.append(cur);
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("ACCOUNT_NUMBER"));
        buffer.append(new String(t.getAccount()));
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("EXECUTION_DATE"));
        try {
            buffer.append(df.format(t.getExecutionDateAsDate()));
        }
        catch (ParseException parse) {
            buffer.append(new String(t.getExecutionDate()));
        }
        buffer.append("\r\n");
        buffer.append("     ");
        buffer.append(b.getString("AMOUNT"));
        try {
            NumberFormat decimalFormat = DecimalFormat.getInstance(l);
            decimalFormat.setMinimumFractionDigits(3);
            buffer.append(decimalFormat.format(new BigDecimal(amount).movePointLeft(3)));
            if (t.isCounterValuePayment()) {
                buffer.append(" EUR");
            } else {
                buffer.append(" ");
                buffer.append(new String(t.getCurrency()));
            }
        }
        catch (IllegalArgumentException iae) {
            buffer.append(amount);
        }
    }

    public List getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: ");
            System.err.println("java de.businesslogics.format.ticket.Ticket DTAUS|DTAZV filename");
            System.exit(-1);
        }
        ArrayList logicalFiles = new ArrayList();
        AllListener l = new AllListener(logicalFiles);
        DTAExtractor e = args[0].equalsIgnoreCase("DTAUS") ? new DTAUSExtractor(l) : new DTAZVExtractor(l);
        long total = 0L;
        long start = System.currentTimeMillis();
        try (FileInputStream in = new FileInputStream(args[1]);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                e.write(buffer, 0, read);
                total += (long)read;
            }
        }
        finally {
            e.close();
        }
        long end = System.currentTimeMillis();
        System.err.print(end - start + " ms\t");
        System.err.print(total + " bytes\t");
        double kb = (double)total / 1024.0;
        double sec = (double)(end - start) / 1000.0;
        System.err.println(kb / sec + " KB/s");
        System.out.println(new Ticket(logicalFiles));
    }

    static class AllListener
    extends DTAExtractor.NullFormatListener
    implements DTAUSExtractor.DTAUSListener,
    DTAZVExtractor.DTAZVListener {
        List l;
        DTAZVLogicalFile azvLogicalFile;

        AllListener(List l) {
            this.l = l;
        }

        @Override
        public void startLogicalFile(DTAUSLogicalFile lf) {
        }

        @Override
        public void startLogicalFile(DTAZVLogicalFile lf) {
            this.azvLogicalFile = lf;
        }

        @Override
        public void handleItem(DTAUSItem i) {
        }

        @Override
        public void handleItem(DTAZVItem i) {
            this.azvLogicalFile.addTBlock(i.getTicketBlock(this.azvLogicalFile), i.getAmount() / 1000L);
        }

        @Override
        public void endLogicalFile(DTAUSLogicalFile lf) {
            this.l.add(lf);
        }

        @Override
        public void endLogicalFile(DTAZVLogicalFile lf) {
            this.l.add(lf);
        }
    }
}

