/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.BundesbankEMZSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftExtractor;
import de.businesslogics.format.dta.BundesbankSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftListener;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.SLF;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.Ticket;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Step2PaymentDisplayMessageGenerator
implements DisplayMessageGenerator {
    private List<DTAUSLogicalFile> logicalFiles = new ArrayList<DTAUSLogicalFile>();

    @Override
    public Ticket getMessage(InputStream in) throws Exception {
        this.logicalFiles.clear();
        BundesbankSwiftExtractor out = new BundesbankSwiftExtractor(new MyBundesbankSwiftListener(), SLF.SLF_4_UNCOMPRESSED, "GS");
        Streams.copy(in, out);
        return new Ticket(true, this.logicalFiles);
    }

    private class MyBundesbankSwiftListener
    implements BundesbankSwiftListener {
        private String uniqueCurrency;
        private BigDecimal totalAmount;

        private MyBundesbankSwiftListener() {
        }

        @Override
        public void startLogicalFile(DTAUSLogicalFile logicalFile) {
            this.uniqueCurrency = null;
            this.totalAmount = BigDecimal.ZERO;
        }

        @Override
        public void handleItem(DTAUSItem item) {
        }

        @Override
        public void handleSwiftItem(BundesbankSwiftItem item) {
            if (item instanceof BundesbankEMZSwiftItem && !"NONE".equals(this.uniqueCurrency)) {
                Field33B field33B = ((BundesbankEMZSwiftItem)item).getMessage().getOriginalAmount();
                String currency = field33B.getCurrency().getCurrencyCode();
                if (this.uniqueCurrency == null) {
                    this.uniqueCurrency = currency;
                } else if (!this.uniqueCurrency.equals(currency)) {
                    this.uniqueCurrency = "NONE";
                    this.totalAmount = BigDecimal.ZERO;
                    return;
                }
                this.totalAmount = this.totalAmount.add(field33B.getAmount());
            }
        }

        @Override
        public void endLogicalFile(DTAUSLogicalFile logicalFile) {
            if (logicalFile instanceof BundesbankDtaLogicalFile) {
                String currency = "NONE".equals(this.uniqueCurrency) ? null : this.uniqueCurrency;
                BundesbankDtaLogicalFile lf = (BundesbankDtaLogicalFile)logicalFile;
                lf.setUniqueCurrencyCode(currency);
                lf.setTotalAmount(this.totalAmount);
            }
            Step2PaymentDisplayMessageGenerator.this.logicalFiles.add(logicalFile);
        }

        @Override
        public void consumeError(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }

        @Override
        public void handleWarning(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }
    }
}

