/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Ticket;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SEPADebitDisplayMessageGenerator
implements DisplayMessageGenerator {
    private final boolean allowIsoFormats;
    private final boolean allowATFormats;
    private boolean xmlPrefixes;

    public SEPADebitDisplayMessageGenerator() {
        this(false);
    }

    public SEPADebitDisplayMessageGenerator(boolean allowIsoFormats) {
        this(allowIsoFormats, false);
    }

    public SEPADebitDisplayMessageGenerator(boolean allowIsoFormats, boolean allowATFormats) {
        this.allowIsoFormats = allowIsoFormats;
        this.allowATFormats = allowATFormats;
    }

    public static Pain00800201Ticket getDisplayMessage(InputStream in) throws Exception {
        return SEPADebitDisplayMessageGenerator.getDisplayMessage(in, false);
    }

    public static Pain00800201Ticket getDisplayMessage(InputStream in, boolean allowIsoFormats) throws Exception {
        SEPADebitDisplayMessageGenerator gen = new SEPADebitDisplayMessageGenerator(allowIsoFormats);
        return gen.getMessage(in);
    }

    @Override
    public Pain00800201Ticket getMessage(InputStream in) throws Exception {
        Pain00800201Ticket displayMessage = new Pain00800201Ticket();
        EbicsHandler handler = displayMessage.startParsing(false, this.allowIsoFormats, this.allowATFormats);
        handler.setSignatureHandler(new MyPrefixDetector());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        in.close();
        return displayMessage;
    }

    public boolean hasXmlPrefixes() {
        return this.xmlPrefixes;
    }

    private class MyPrefixDetector
    extends DefaultHandler {
        private MyPrefixDetector() {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (prefix != null && prefix.length() > 0) {
                SEPADebitDisplayMessageGenerator.this.xmlPrefixes = SEPADebitDisplayMessageGenerator.this.xmlPrefixes | !"xsi".equals(prefix);
            }
        }
    }
}

