/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.format.sepa.CCTTicketWrapper;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SEPACreditDisplayMessageGenerator
implements DisplayMessageGenerator {
    private boolean allowIsoFormats = false;
    private boolean xmlPrefixes = false;

    public static CCTTicketWrapper getDisplayMessage(InputStream in) throws Exception {
        return SEPACreditDisplayMessageGenerator.getDisplayMessage(in, false);
    }

    public static CCTTicketWrapper getDisplayMessage(InputStream in, boolean allowIsoFormats) throws Exception {
        SEPACreditDisplayMessageGenerator gen = new SEPACreditDisplayMessageGenerator(allowIsoFormats);
        return gen.getMessage(in);
    }

    public SEPACreditDisplayMessageGenerator() {
        this(false);
    }

    public SEPACreditDisplayMessageGenerator(boolean allowIsoFormats) {
        this.allowIsoFormats = allowIsoFormats;
    }

    @Override
    public CCTTicketWrapper getMessage(InputStream in) throws Exception {
        CCTTicketWrapper displayMessage = new CCTTicketWrapper();
        EbicsHandler handler = displayMessage.startParsing(false, this.allowIsoFormats);
        handler.setSignatureHandler(new MyPrefixDetector(handler.getRootNamespaces()));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        in.close();
        return displayMessage;
    }

    public boolean hasXmlPrefixes() {
        return this.xmlPrefixes;
    }

    private class MyPrefixDetector
    extends DefaultHandler {
        final List<String> uris;

        public MyPrefixDetector(List<String> uris) {
            this.uris = uris;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.uris.contains(uri) && prefix != null && prefix.length() > 0) {
                SEPACreditDisplayMessageGenerator.this.xmlPrefixes = true;
            }
        }
    }
}

