/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bankrechner.SystemProperties;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.CCTTicket;
import de.businesslogics.format.ticket.CtrlSumException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.MltplPmtTpInfException;
import de.businesslogics.format.ticket.NbOfTxsException;
import de.businesslogics.format.ticket.Pain00100103PaymentInstruction;
import de.businesslogics.format.ticket.Pain00100103Ticket;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Pain113DisplayMessageGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P113_PURP;
    public static final SmartDefaultHandler.Path P113_INITG_NM;
    public static final SmartDefaultHandler.Path P113_INITG_ID;
    public static final SmartDefaultHandler.Path P113_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P113_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P113_MSG_ID;
    public static final SmartDefaultHandler.Path P113_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P113_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P113_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P113_PMT_INF;
    public static final SmartDefaultHandler.Path P113_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P113_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P113_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P113_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P113_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P113_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P113_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P113_DBTR_NM;
    public static final SmartDefaultHandler.Path P113_DBTR_ACCT_IBAN;
    public static final SmartDefaultHandler.Path P113_DBTR_ACCT_OTHR;
    public static final SmartDefaultHandler.Path P113_DBTR_AGT_BIC;
    public static final SmartDefaultHandler.Path P113_DBTR_AGT_CLR_SYS_MMB_ID;
    public static final SmartDefaultHandler.Path P113_DBTR_AGT_NM;
    public static final SmartDefaultHandler.Path P113_TX_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P113_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P113_INSTD_AMT;
    public static final SmartDefaultHandler.Path P113_EQVT_AMT;
    protected static final HashSet<String> salariesCodes;
    private boolean validateScheme;
    private String namespace;
    private Pain00100103Ticket p113Message;
    private Pain00100103PaymentInstruction p113Payment;
    private boolean bundesbank;
    private Integer pmtNbOfTxs;
    private long hdrNbOfTxs;
    private BigDecimal hdrCtrlSum;
    private BigDecimal pmtCtrlSum;
    protected boolean salary;
    private boolean pmtTpInfSeen = false;
    protected String ccy;
    protected String eqvtCcy;
    private boolean success = false;

    public void setValidateScheme(boolean validateScheme) {
        this.validateScheme = validateScheme;
    }

    public boolean containsSalary() {
        return this.salary;
    }

    public Pain00100103Ticket getMessage() {
        return this.p113Message;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setBundesbank(boolean b) {
        this.bundesbank = b;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        StringBuilder sb = new StringBuilder();
        if (this.validateScheme) {
            this.addNamespace(sb);
        }
        return Pain113DisplayMessageGenerator.finishNamespaceSchemaLocations(sb);
    }

    protected void addNamespace(StringBuilder sb) {
        Pain113DisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "/de/businesslogics/format/iso20022/pain.001.001.03.xsd");
    }

    @Override
    public DisplayMessage getMessage(InputStream in) throws IOException, SAXException {
        this.parse(in);
        return this.p113Message;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.success = false;
        this.salary = false;
        this.hdrNbOfTxs = 0L;
        this.hdrCtrlSum = null;
    }

    @SmartDefaultHandler.Callback(value={"P113_MSG_ID"})
    public void setP113MsgId() {
        this.namespace = this.getPath().getUri();
        this.p113Message = new Pain00100103Ticket();
        this.p113Message.messageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_CRE_DT_TM"})
    public void setP113CreDtTm() throws SAXParseException {
        this.p113Message.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF_ID"})
    public void setP113PmtInfId() {
        this.p113Payment = new Pain00100103PaymentInstruction();
        this.p113Payment.pmtInfId = this.getString();
        this.p113Message.payments.add(this.p113Payment);
    }

    @SmartDefaultHandler.Callback(value={"P113_INITG_NM"})
    public void setP113InitiatorName() {
        this.p113Message.initiatorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_INITG_ID"})
    public void setP113InitiatorId() {
        this.p113Message.initiatorId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_TP_INF"})
    public void handlePmtTpInf() {
        this.pmtTpInfSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_SVC_LVL", "P113_TX_SVC_LVL"})
    public void handleServiceLevel() {
        if (this.p113Message.serviceLevel != null) {
            String s = this.getString();
            if (this.p113Message.serviceLevel.length() == 0) {
                this.p113Message.serviceLevel = s;
            } else if (!s.equals(this.p113Message.serviceLevel)) {
                this.p113Message.serviceLevel = null;
            }
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_CTGY_PURP", "P113_TX_CTGY_PURP", "P113_PURP"})
    public void handleCtgyPurp() {
        String s = this.getString();
        this.salary |= salariesCodes.contains(s);
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_ACCT_CCY"})
    public void setDbtrAcctCcy() {
        this.p113Payment.debitorAccountCcy = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_REQD_EXCTN_DT"})
    public void setP113PmtReqdExtnDt() throws SAXException {
        this.p113Payment.reqdExctnDt = this.getDate();
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_NM"})
    public void setP113PmtDbtrNm() {
        this.p113Payment.dbtrNm = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_ACCT_IBAN"})
    public void setP113PmtDbtrIban() {
        this.p113Payment.dbtrAcct = this.getString();
        this.p113Payment.dbtrFlags |= 1;
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_ACCT_OTHR"})
    public void setP113PmtDbtrAcctOthr() {
        this.p113Payment.dbtrAcct = this.getString();
        this.p113Payment.dbtrFlags |= 2;
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_AGT_BIC"})
    public void setP113PmtDbtrBic() {
        this.p113Payment.dbtrAgt = this.getString();
        this.p113Payment.dbtrFlags |= 0x10;
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_AGT_CLR_SYS_MMB_ID"})
    public void setP113PmtDbtrAgt() {
        if (this.p113Payment.dbtrAgt == null) {
            this.p113Payment.dbtrAgt = this.getString();
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_AGT_NM"})
    public void setP113PmtDbtrAgtNm() {
        this.p113Payment.dbtrAgtNm = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_INSTD_AMT"})
    public void startInstdAmt(Attributes attributes) throws SAXParseException {
        this.ccy = attributes.getValue("Ccy");
    }

    @SmartDefaultHandler.Callback(value={"P113_INSTD_AMT"})
    public void setInstdAmt() throws SAXParseException {
        this.p113Payment.add(this.ccy, this.getDecimal());
    }

    @SmartDefaultHandler.Callback(value={"P113_EQVT_AMT"})
    public void startEqvtAmt(Attributes attributes) {
        this.eqvtCcy = attributes.getValue("Ccy");
    }

    @SmartDefaultHandler.Callback(value={"P113_EQVT_AMT"})
    public void setEqvtAmt() throws SAXParseException {
        if (this.eqvtCcy == null) {
            this.eqvtCcy = "EUR";
        }
        this.p113Payment.add(this.eqvtCcy, this.getDecimal());
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_NB_OF_TXS"})
    public void setPmtNbOfTxs() throws SAXParseException {
        this.pmtNbOfTxs = this.getInt();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_CTRL_SUM"})
    public void setPmtCtrlSum() throws SAXParseException {
        this.pmtCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P113_HDR_NB_OF_TXS"})
    public void setHdrNbOfTxs() throws SAXParseException {
        this.hdrNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P113_HDR_CTRL_SUM"})
    public void setHdrCtrlSum() throws SAXParseException {
        this.hdrCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF"})
    public void end113PmtInf2() throws SAXException {
        if (this.pmtNbOfTxs != null && this.p113Payment.numberOfPayments != this.pmtNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.p113Payment.numberOfPayments + ")", this.locator));
        }
        if (this.pmtCtrlSum != null && this.pmtCtrlSum.compareTo(this.p113Payment.ctrlSum) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.p113Payment.ctrlSum) + ")", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_TX_PMT_TP_INF"})
    public void handleTxPmtTpInf() throws SAXException {
        if (this.pmtTpInfSeen) {
            this.error(new MltplPmtTpInfException("Payment type information already defined at batch level.", this.locator));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.success = true;
        if (this.p113Message.getTotalNumberOfPayments() != this.hdrNbOfTxs && this.hdrNbOfTxs != 0L) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.p113Message.getTotalNumberOfPayments() + ")", this.locator));
        }
        if (this.hdrCtrlSum != null && this.hdrCtrlSum.compareTo(this.p113Message.getTotalAmount()) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.p113Message.getTotalAmount()) + ")", this.locator));
        }
    }

    protected CCTTicket mkTicket() {
        return new CCTTicket();
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        boolean enableMltplPmtTpInf = SystemProperties.isCustomerCreditMultiplePaymentTypeInformation();
        boolean isMltplPmtTpInfException = e instanceof MltplPmtTpInfException;
        if (!isMltplPmtTpInfException || isMltplPmtTpInfException && !enableMltplPmtTpInf) {
            super.error(e);
        }
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "Document");
        SmartDefaultHandler.Path cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P113_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P113_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P113_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P113_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        SmartDefaultHandler.Path initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P113_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(initgPty, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P113_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P113_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P113_PMT_INF_ID = new SmartDefaultHandler.Path(P113_PMT_INF, "PmtInfId");
        P113_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P113_PMT_INF, "NbOfTxs");
        P113_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P113_PMT_INF, "CtrlSum");
        P113_PMT_TP_INF = new SmartDefaultHandler.Path(P113_PMT_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl = new SmartDefaultHandler.Path(P113_PMT_TP_INF, "SvcLvl");
        P113_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        SmartDefaultHandler.Path ctgyPurp = new SmartDefaultHandler.Path(P113_PMT_TP_INF, "CtgyPurp");
        P113_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp, "Cd");
        P113_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(P113_PMT_INF, "ReqdExctnDt");
        SmartDefaultHandler.Path dbtr = new SmartDefaultHandler.Path(P113_PMT_INF, "Dbtr");
        P113_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        SmartDefaultHandler.Path dbtrAcct = new SmartDefaultHandler.Path(P113_PMT_INF, "DbtrAcct");
        SmartDefaultHandler.Path id2 = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        P113_DBTR_ACCT_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        othr = new SmartDefaultHandler.Path(id2, "Othr");
        P113_DBTR_ACCT_OTHR = new SmartDefaultHandler.Path(othr, "Id");
        P113_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct, "Ccy");
        SmartDefaultHandler.Path dbtrAgt = new SmartDefaultHandler.Path(P113_PMT_INF, "DbtrAgt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        P113_DBTR_AGT_BIC = new SmartDefaultHandler.Path(finInstnId, "BIC");
        SmartDefaultHandler.Path clrSysMbId = new SmartDefaultHandler.Path(finInstnId, "ClrSysMmbId");
        P113_DBTR_AGT_CLR_SYS_MMB_ID = new SmartDefaultHandler.Path(clrSysMbId, "MmbId");
        P113_DBTR_AGT_NM = new SmartDefaultHandler.Path(finInstnId, "Nm");
        SmartDefaultHandler.Path cdtTrfTxInf = new SmartDefaultHandler.Path(P113_PMT_INF, "CdtTrfTxInf");
        P113_TX_PMT_TP_INF = new SmartDefaultHandler.Path(cdtTrfTxInf, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl2 = new SmartDefaultHandler.Path(P113_TX_PMT_TP_INF, "SvcLvl");
        P113_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        SmartDefaultHandler.Path ctgyPurp2 = new SmartDefaultHandler.Path(P113_TX_PMT_TP_INF, "CtgyPurp");
        P113_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp2, "Cd");
        SmartDefaultHandler.Path amt = new SmartDefaultHandler.Path(cdtTrfTxInf, "Amt");
        P113_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        SmartDefaultHandler.Path eqvtAmt = new SmartDefaultHandler.Path(amt, "EqvtAmt");
        P113_EQVT_AMT = new SmartDefaultHandler.Path(eqvtAmt, "Amt");
        SmartDefaultHandler.Path purp = new SmartDefaultHandler.Path(cdtTrfTxInf, "Purp");
        P113_PURP = new SmartDefaultHandler.Path(purp, "Cd");
        salariesCodes = new HashSet(3);
        salariesCodes.add("BONU");
        salariesCodes.add("PENS");
        salariesCodes.add("SALA");
    }
}

