/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.Pain00800102PaymentInstruction;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Pain00800102Ticket
extends AbstractDisplayMessage {
    private static final long serialVersionUID = 1L;
    String messageIdentification;
    Date creationDateTime;
    List<Pain00800102PaymentInstruction> payments = new ArrayList<Pain00800102PaymentInstruction>();
    String initiatorName;
    String initiatorId;
    String debitType = "";

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getDebitType() {
        return this.debitType;
    }

    @Override
    public void append() {
        this.mainSeparator();
        this.calculateKeyWidth("FILE_ID", "TIMESTAMP", "INITIATOR_NAME", "INITIATOR_ID");
        this.buffer.append("     ").append(this.bundle.getString("DEBITS"));
        if (!StringUtils.isEmpty(this.debitType)) {
            this.buffer.append("  (");
            this.buffer.append(this.debitType);
            this.buffer.append(")");
        }
        this.buffer.append("\r\n");
        this.writeKeyValue("FILE_ID", this.messageIdentification);
        this.writeDate("TIMESTAMP", "TIMESTAMP_FORMAT", this.creationDateTime);
        this.writeKeyValue("INITIATOR_NAME", this.initiatorName);
        this.writeKeyValue("INITIATOR_ID", this.initiatorId);
        this.keyWidth = 0;
        if (Boolean.getBoolean("de.businesslogics.format.sepa.WithGroupTotal")) {
            this.calculateKeyWidth("TOTAL_AMOUNT", "TOTAL_ANZAHL");
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(this.locale));
            String amount = df.format(this.getTotalAmount());
            this.minorSeparator();
            this.writeKeyValue("TOTAL_ANZAHL", String.valueOf(this.getTotalNumberOfPayments()));
            this.writeKeyValue("TOTAL_AMOUNT", amount);
        }
        this.keyWidth = 27;
        for (Pain00800102PaymentInstruction t : this.payments) {
            t.append(this);
        }
        this.mainSeparator();
    }

    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<Pain00800102PaymentInstruction> getPayments() {
        return this.payments;
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Pain00800102PaymentInstruction t : this.payments) {
            totalAmount = totalAmount.add(t.ctrlSum);
        }
        return totalAmount;
    }

    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (Pain00800102PaymentInstruction t : this.payments) {
            totalNumber += (long)t.numberOfPayments;
        }
        return totalNumber;
    }
}

