/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.CurrencyInfo;
import de.businesslogics.format.ticket.Pain00800102Ticket;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeMap;

public class Pain00800102PaymentInstruction
implements Serializable {
    private static final long serialVersionUID = 1L;
    String pmtInfId;
    YYMMDD reqdColltnDt;
    String cdtrAcct;
    String cdtrNm;
    String cdtrAgt;
    String cdtrAgtNm;
    int cdtrFlags;
    private final TreeMap<String, CurrencyInfo> currencies = new TreeMap();
    String creditorAccountCcy;
    int numberOfPayments = 0;
    BigDecimal ctrlSum = BigDecimal.ZERO;

    public Currency getCreditorAccountCcy() {
        return this.creditorAccountCcy != null ? Currency.getInstance(this.creditorAccountCcy) : null;
    }

    public void append(Pain00800102Ticket ticket) {
        ticket.minorSeparator();
        ticket.writeKeyValue("PMT_INF_ID", this.pmtInfId);
        ticket.writeKeyValue("BANK_CODE", this.cdtrAgt);
        ticket.writeKeyValue("BANK_NAME", this.cdtrAgtNm);
        ticket.writeKeyValue("ACCOUNT_NUMBER", this.cdtrAcct);
        ticket.writeKeyValue("ORIGINATOR2", this.cdtrNm);
        MessageFormat nbOfTxs = new MessageFormat(ticket.bundle.getString("NB_OF_TXS_CUR"));
        MessageFormat ctrlSum = new MessageFormat(ticket.bundle.getString("CTRL_SUM_CUR"));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(ticket.locale));
        for (Map.Entry<String, CurrencyInfo> me : this.currencies.entrySet()) {
            Object[] cur = new Object[]{me.getKey()};
            CurrencyInfo ci = me.getValue();
            ticket.writeRawKeyValue(nbOfTxs.format(cur), Integer.toString(ci.getNbOfTxs()));
            ticket.writeRawKeyValue(ctrlSum.format(cur), df.format(ci.getSum()));
        }
        ticket.writeKeyValue("EXECUTION_DATE", new SimpleDateFormat(ticket.bundle.getString("DATE_FORMAT")).format(this.reqdColltnDt));
    }

    void add(String currency, BigDecimal amount) {
        CurrencyInfo ci = this.currencies.get(currency);
        ++this.numberOfPayments;
        this.ctrlSum = this.ctrlSum.add(amount);
        if (ci == null) {
            this.currencies.put(currency, new CurrencyInfo(amount));
            return;
        }
        ci.add(amount);
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public YYMMDD getReqdExctnDt() {
        return this.reqdColltnDt;
    }

    public String getCdtrAcct() {
        return this.cdtrAcct;
    }

    public String getCdtrNm() {
        return this.cdtrNm;
    }

    public String getCdtrAgt() {
        return this.cdtrAgt;
    }

    public String getCdtrAgtNm() {
        return this.cdtrAgtNm;
    }

    public TreeMap<String, CurrencyInfo> getCurrencies() {
        return this.currencies;
    }

    public boolean isIban() {
        return (this.cdtrFlags & 0xF) == 1;
    }

    public boolean isOthrAcct() {
        return (this.cdtrFlags & 0xF) == 2;
    }

    public boolean isBic() {
        return (this.cdtrFlags & 0xF0) == 16;
    }
}

