/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.Pain001ZZV05PaymentInstruction;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Pain001ZZV05Ticket
extends AbstractDisplayMessage {
    private static final long serialVersionUID = 1L;
    String messageIdentification;
    Date creationDateTime;
    List<Pain001ZZV05PaymentInstruction> payments = new ArrayList<Pain001ZZV05PaymentInstruction>();

    @Override
    public void append() {
        this.mainSeparator();
        this.keyWidth = 11;
        this.writeLine("CREDITS");
        this.writeKeyValue("FILE_ID", this.messageIdentification);
        this.writeKeyValue("TIMESTAMP", new SimpleDateFormat(this.bundle.getString("TIMESTAMP_FORMAT")).format(this.creationDateTime));
        this.keyWidth = 27;
        for (Pain001ZZV05PaymentInstruction t : this.payments) {
            t.append(this);
        }
        this.mainSeparator();
    }

    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<Pain001ZZV05PaymentInstruction> getPayments() {
        return this.payments;
    }

    public String getCurrency() {
        String found = null;
        for (Pain001ZZV05PaymentInstruction p : this.payments) {
            if (p.getCurrencies().size() != 1) {
                return null;
            }
            if (found == null) {
                found = p.getCurrencies().firstKey();
                continue;
            }
            if (found.equals(p.getCurrencies().firstKey())) continue;
            return null;
        }
        return found;
    }

    public BigDecimal getTotalAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (Pain001ZZV05PaymentInstruction p : this.payments) {
            if (p.getCurrencies().size() != 1) {
                return BigDecimal.ZERO;
            }
            total = total.add(p.getCurrencies().values().iterator().next().getSum());
        }
        return total;
    }
}

