/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.CurrencyInfo;
import de.businesslogics.format.ticket.Pain001ZZV05Ticket;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeMap;

public class Pain001ZZV05PaymentInstruction
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int ACCOUNT_TYPE_IBAN = 1;
    public static int ACCOUNT_TYPE_OTHR = 2;
    public static int ACCOUNT_TYPE_MASK = 15;
    public static int BANKCODE_TYPE_BIC = 16;
    public static int BANKCODE_TYPE_MASK = 240;
    String pmtInfId;
    YYMMDD reqdExctnDt;
    String dbtrAcct;
    String dbtrNm;
    String dbtrAgt;
    String dbtrAgtNm;
    int dbtrFlags;
    private final TreeMap<String, CurrencyInfo> currencies = new TreeMap();

    public void append(Pain001ZZV05Ticket ticket) {
        ticket.minorSeparator();
        ticket.writeKeyValue("PMT_INF_ID", this.pmtInfId);
        ticket.writeKeyValue("BANK_CODE", this.dbtrAgt);
        ticket.writeKeyValue("BANK_NAME", this.dbtrAgtNm);
        ticket.writeKeyValue("ACCOUNT_NUMBER", this.dbtrAcct);
        ticket.writeKeyValue("ORIGINATOR2", this.dbtrNm);
        MessageFormat nbOfTxs = new MessageFormat(ticket.bundle.getString("NB_OF_TXS_CUR"));
        MessageFormat ctrlSum = new MessageFormat(ticket.bundle.getString("CTRL_SUM_CUR"));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(ticket.locale));
        for (Map.Entry<String, CurrencyInfo> me : this.currencies.entrySet()) {
            Object[] cur = new Object[]{me.getKey()};
            CurrencyInfo ci = me.getValue();
            ticket.writeRawKeyValue(nbOfTxs.format(cur), Integer.toString(ci.getNbOfTxs()));
            ticket.writeRawKeyValue(ctrlSum.format(cur), df.format(ci.getSum()));
        }
        if (this.getReqdExctnDt() == null) {
            ticket.writeKeyValue("EXECUTION_DATE", "");
        } else {
            ticket.writeKeyValue("EXECUTION_DATE", new SimpleDateFormat(ticket.bundle.getString("DATE_FORMAT")).format(this.getReqdExctnDt()));
        }
    }

    void add(String currency, BigDecimal amount) {
        CurrencyInfo ci = this.currencies.get(currency);
        if (ci == null) {
            this.currencies.put(currency, new CurrencyInfo(amount));
            return;
        }
        ci.add(amount);
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public YYMMDD getReqdExctnDt() {
        return this.reqdExctnDt;
    }

    public String getDbtrAcct() {
        return this.dbtrAcct;
    }

    public String getDbtrNm() {
        return this.dbtrNm;
    }

    public String getDbtrAgt() {
        return this.dbtrAgt;
    }

    public String getDbtrAgtNm() {
        return this.dbtrAgtNm;
    }

    public TreeMap<String, CurrencyInfo> getCurrencies() {
        return this.currencies;
    }

    public int getDbtrFlags() {
        return this.dbtrFlags;
    }

    public boolean isIban() {
        return (this.dbtrFlags & ACCOUNT_TYPE_MASK) == ACCOUNT_TYPE_IBAN;
    }

    public boolean isOtherAcct() {
        return (this.dbtrFlags & ACCOUNT_TYPE_MASK) == ACCOUNT_TYPE_OTHR;
    }

    public boolean isBic() {
        return (this.dbtrFlags & BANKCODE_TYPE_MASK) == BANKCODE_TYPE_BIC;
    }
}

