/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.Pain00100103PaymentInstruction;
import de.businesslogics.format.ticket.VOPResult;
import de.businesslogics.format.ticket.VOPResultHolder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Pain00100103Ticket
extends AbstractDisplayMessage
implements VOPResultHolder {
    private static final long serialVersionUID = 1L;
    public String messageIdentification;
    public String serviceLevel = "";
    public Date creationDateTime;
    public List<Pain00100103PaymentInstruction> payments = new ArrayList<Pain00100103PaymentInstruction>();
    public String initiatorId;
    public String initiatorName;
    private VOPResult vopResult;

    @Override
    public void setVopResult(VOPResult result) {
        this.vopResult = result;
    }

    protected void append(AbstractDisplayMessage message) {
        message.mainSeparator();
        message.calculateKeyWidth("FILE_ID", "TIMESTAMP", "INITIATOR_NAME", "INITIATOR_ID");
        message.writeLine("URGP".equals(this.serviceLevel) ? "EIL_UEBERWEISUNGEN" : "CREDITS");
        message.writeKeyValue("FILE_ID", this.messageIdentification);
        message.writeDate("TIMESTAMP", "TIMESTAMP_FORMAT", this.creationDateTime);
        message.writeKeyValue("INITIATOR_NAME", this.initiatorName);
        message.writeKeyValue("INITIATOR_ID", this.initiatorId);
        if (Boolean.getBoolean("de.businesslogics.format.sepa.WithGroupTotal")) {
            message.calculateKeyWidth("TOTAL_AMOUNT", "TOTAL_ANZAHL");
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(this.locale));
            String amount = df.format(this.getTotalAmount());
            message.minorSeparator();
            message.writeKeyValue("TOTAL_ANZAHL", String.valueOf(this.getTotalNumberOfPayments()));
            message.writeKeyValue("TOTAL_AMOUNT", amount);
        }
        if (this.vopResult != null) {
            this.vopResult.append(message);
        }
        message.calculateKeyWidth("PMT_INF_ID", "BANK_CODE", "BANK_NAME", "ACCOUNT_NUMBER", "ORIGINATOR2", "EXECUTION_DATE");
        boolean needCur = false;
        for (Pain00100103PaymentInstruction t : this.payments) {
            if (t.getCurrencies().size() <= 1) continue;
            needCur = true;
            break;
        }
        if (needCur) {
            message.enlargeRawKeyWidth(MessageFormat.format(message.bundle.getString("NB_OF_TXS_CUR"), "EUR"));
        } else {
            message.enlargeKeyWidth("NB_OF_TXS");
        }
        message.enlargeRawKeyWidth(MessageFormat.format(message.bundle.getString("CTRL_SUM_CUR"), "EUR"));
        for (Pain00100103PaymentInstruction t : this.payments) {
            t.append(message);
        }
    }

    @Override
    public void append() {
        this.append(this);
        this.mainSeparator();
    }

    public String getServiceLevel() {
        return this.serviceLevel;
    }

    @Override
    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<Pain00100103PaymentInstruction> getPayments() {
        return this.payments;
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Pain00100103PaymentInstruction t : this.payments) {
            totalAmount = totalAmount.add(t.getCtrlSum());
        }
        return totalAmount;
    }

    @Override
    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (Pain00100103PaymentInstruction t : this.payments) {
            totalNumber += (long)t.getNumberOfPayments();
        }
        return totalNumber;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }
}

