/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.CurrencyInfo;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class Pain00100103PaymentInstruction
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ACCOUNT_TYPE_IBAN = 1;
    public static final int ACCOUNT_TYPE_OTHR = 2;
    public static final int ACCOUNT_TYPE_MASK = 15;
    public static final int BANKCODE_TYPE_BIC = 16;
    public static final int BANKCODE_TYPE_CLR_SYS_MMB = 32;
    public static final int BANKCODE_TYPE_MASK = 240;
    public String pmtInfId;
    public Date reqdExctnDt;
    public String dbtrAcct;
    public String dbtrNm;
    public String dbtrAgt;
    public String dbtrAgtNm;
    public BigDecimal ctrlSum = BigDecimal.ZERO;
    public int numberOfPayments = 0;
    public int dbtrFlags;
    public final TreeMap<String, CurrencyInfo> currencies = new TreeMap();
    public String debitorAccountCcy;

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public Currency getDebitorAccountCcy() {
        return this.debitorAccountCcy != null ? Currency.getInstance(this.debitorAccountCcy) : null;
    }

    public void append(AbstractDisplayMessage ticket) {
        ticket.minorSeparator();
        ticket.writeKeyValue("PMT_INF_ID", this.pmtInfId);
        ticket.writeKeyValue("BANK_CODE", this.dbtrAgt);
        ticket.writeKeyValue("BANK_NAME", this.dbtrAgtNm);
        ticket.writeKeyValue("ACCOUNT_NUMBER", this.dbtrAcct);
        ticket.writeKeyValue("ORIGINATOR2", this.dbtrNm);
        MessageFormat nbOfTxs = new MessageFormat(ticket.bundle.getString(this.currencies.size() < 2 ? "NB_OF_TXS" : "NB_OF_TXS_CUR"));
        MessageFormat ctrlSumFmt = new MessageFormat(ticket.bundle.getString("CTRL_SUM_CUR"));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(ticket.locale));
        for (Map.Entry<String, CurrencyInfo> me : this.currencies.entrySet()) {
            Object[] cur = new Object[]{me.getKey()};
            CurrencyInfo ci = me.getValue();
            ticket.writeRawKeyValue(nbOfTxs.format(cur), Integer.toString(ci.getNbOfTxs()));
            ticket.writeRawKeyValue(ctrlSumFmt.format(cur), df.format(ci.getSum()));
        }
        ticket.writeDate("EXECUTION_DATE", this.reqdExctnDt instanceof YYMMDD ? "DATE_FORMAT" : "TIMESTAMP_FORMAT", this.reqdExctnDt);
    }

    public void add(String currency, BigDecimal amount) {
        CurrencyInfo ci = this.currencies.get(currency);
        this.ctrlSum = this.ctrlSum.add(amount);
        ++this.numberOfPayments;
        if (ci == null) {
            this.currencies.put(currency, new CurrencyInfo(amount));
            return;
        }
        ci.add(amount);
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public Date getReqdExctnDt() {
        return this.reqdExctnDt;
    }

    public String getDbtrAcct() {
        return this.dbtrAcct;
    }

    public String getDbtrNm() {
        return this.dbtrNm;
    }

    public String getDbtrAgt() {
        return this.dbtrAgt;
    }

    public String getDbtrAgtNm() {
        return this.dbtrAgtNm;
    }

    public TreeMap<String, CurrencyInfo> getCurrencies() {
        return this.currencies;
    }

    public int getDbtrFlags() {
        return this.dbtrFlags;
    }

    public boolean isIban() {
        return (this.dbtrFlags & 0xF) == 1;
    }

    public boolean isOtherAcct() {
        return (this.dbtrFlags & 0xF) == 2;
    }

    public boolean isBic() {
        return (this.dbtrFlags & 0xF0) == 16;
    }

    public boolean isClrSysMmb() {
        return (this.dbtrFlags & 0xF0) == 32;
    }
}

