/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.swift.mt101.MT101SequenceA;
import de.businesslogics.format.ticket.BulkMT101Ticket;
import de.businesslogics.format.ticket.CurrencyInfo;
import de.businesslogics.format.ticket.MT101Subticket;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MT101Ticket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String senderBIC;
    private final String receiverBIC;
    private final Date reqdExecutionDate;
    private final String senderReference;
    final List<MT101Subticket> subtickets = new ArrayList<MT101Subticket>();

    public List<MT101Subticket> getSubtickets() {
        return Collections.unmodifiableList(this.subtickets);
    }

    MT101Ticket(String senderBIC, String receiverBIC, MT101SequenceA a) {
        this.senderBIC = senderBIC;
        this.receiverBIC = receiverBIC;
        this.senderReference = a.getSendersReference().getReference();
        this.reqdExecutionDate = YYMMDD.getInstance(a.getRequestedExecutionDate().getDate());
    }

    void append(BulkMT101Ticket message) {
        message.mainSeparator();
        message.calculateKeyWidth("SENDER_BIC", "RECEIVER_BIC", "SENDER_REFERENCE", "EXECUTION_DATE");
        message.writeKeyValue("SENDER_BIC", this.senderBIC);
        message.writeKeyValue("RECEIVER_BIC", this.receiverBIC);
        message.writeKeyValue("SENDER_REFERENCE", this.senderReference);
        message.writeDate("EXECUTION_DATE", "DATE_FORMAT", this.reqdExecutionDate);
        message.calculateKeyWidth("INITIATOR_NAME", "BANK_CODE", "ACCOUNT_NUMBER", "NB_OF_TXS_CUR", "CTRL_SUM_CUR");
        for (MT101Subticket subticket : this.subtickets) {
            message.minorSeparator();
            message.writeKeyValue("INITIATOR_NAME", subticket.getInitiator());
            message.writeKeyValue("BANK_CODE", subticket.getOrigBic());
            message.writeKeyValue("ACCOUNT_NUMBER", subticket.getOrigAccount());
            MessageFormat nbOfTxs = new MessageFormat(message.bundle.getString("NB_OF_TXS_CUR"));
            MessageFormat ctrlSum = new MessageFormat(message.bundle.getString("CTRL_SUM_CUR"));
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(message.locale));
            for (Map.Entry<String, CurrencyInfo> me : subticket.currencies.entrySet()) {
                Object[] cur = new Object[]{me.getKey()};
                CurrencyInfo ci = me.getValue();
                message.writeRawKeyValue(nbOfTxs.format(cur), Integer.toString(ci.getNbOfTxs()));
                message.writeRawKeyValue(ctrlSum.format(cur), df.format(ci.getSum()));
            }
        }
    }

    public String getSenderBIC() {
        return this.senderBIC;
    }

    public Date getReqdExecutionDate() {
        return this.reqdExecutionDate;
    }

    public String getSenderReference() {
        return this.senderReference;
    }
}

