/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.swift.AccountServicingInstitution;
import de.businesslogics.format.swift.Field32B;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.swift.Field50F;
import de.businesslogics.format.swift.Field50H;
import de.businesslogics.format.swift.Field50L;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.InstructingParty;
import de.businesslogics.format.swift.OrderingCustomer;
import de.businesslogics.format.swift.mt101.MT101Listener;
import de.businesslogics.format.swift.mt101.MT101Parser;
import de.businesslogics.format.swift.mt101.MT101SequenceA;
import de.businesslogics.format.swift.mt101.MT101SequenceB;
import de.businesslogics.format.ticket.BulkMT101Ticket;
import de.businesslogics.format.ticket.CurrencyInfo;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.MT101Subticket;
import de.businesslogics.format.ticket.MT101Ticket;
import de.businesslogics.util.Currency;
import de.businesslogics.util.Objects;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;

public class MT101Generator
implements DisplayMessageGenerator,
MT101Listener {
    private BulkMT101Ticket ticket = new BulkMT101Ticket();
    private MT101SequenceA currentA;
    private MT101Ticket currentMT101;
    private HashMap<Lookup, MT101Subticket> subtickets = new HashMap();
    private BigDecimal totalAmount = null;
    private String currencyCode = null;
    private boolean hasUniqueCurrency = true;

    @Override
    public DisplayMessage getMessage(InputStream in) throws Exception {
        MT101Parser p = new MT101Parser(this);
        p.parse(in);
        return this.ticket;
    }

    public BulkMT101Ticket getMessage() {
        return this.ticket;
    }

    @Override
    public void handle(String senderBIC, String receiverBIC, MT101SequenceA a) {
        this.currentMT101 = new MT101Ticket(senderBIC, receiverBIC, a);
        this.ticket.tickets.add(this.currentMT101);
        this.currentA = a;
        this.subtickets.clear();
    }

    @Override
    public void handle(MT101SequenceB b) {
        CurrencyInfo ci;
        Lookup l;
        MT101Subticket subticket;
        InstructingParty ip;
        OrderingCustomer oc;
        AccountServicingInstitution asi;
        boolean hasNonZeroAmount;
        Field32B f32b = b.getTransactionAmount();
        String cur = f32b.getCurrency().getCurrencyCode();
        BigDecimal amt = f32b.getAmount();
        boolean evaluateField33B = true;
        boolean bl = hasNonZeroAmount = BigDecimal.ZERO.compareTo(amt) != 0;
        if (evaluateField33B) {
            Field33B f33b = b.getOriginalOrderedAmount();
            if (!hasNonZeroAmount && f33b != null) {
                amt = f33b.getAmount();
                cur = f33b.getCurrency().getCurrencyCode();
                boolean bl2 = hasNonZeroAmount = BigDecimal.ZERO.compareTo(amt) != 0;
            }
        }
        if ((asi = b.getAccountServicingInstitution()) == null) {
            asi = this.currentA.getAccountServicingInstitution();
        }
        if ((oc = b.getOrderingCustomer()) == null) {
            oc = this.currentA.getOrderingCustomer();
        }
        if ((ip = b.getInstructingParty()) == null) {
            ip = this.currentA.getInstructingParty();
        }
        if ((subticket = this.subtickets.get(l = new Lookup(asi, oc, ip))) == null) {
            subticket = new MT101Subticket(l.initiator, l.bankCode, l.account);
            this.subtickets.put(l, subticket);
            this.currentMT101.subtickets.add(subticket);
        }
        if ((ci = subticket.currencies.get(cur)) == null) {
            ci = new CurrencyInfo(amt);
            subticket.currencies.put(cur, ci);
        } else {
            ci.add(amt);
        }
        if (this.hasUniqueCurrency) {
            if (this.currencyCode == null) {
                if (hasNonZeroAmount) {
                    this.totalAmount = amt;
                    this.currencyCode = cur;
                } else {
                    this.hasUniqueCurrency = false;
                    this.totalAmount = null;
                    this.currencyCode = null;
                }
            } else if (this.currencyCode.equals(cur)) {
                if (hasNonZeroAmount) {
                    this.totalAmount = this.totalAmount.add(amt);
                }
            } else {
                this.hasUniqueCurrency = false;
                this.totalAmount = null;
                this.currencyCode = null;
            }
        }
    }

    public BigDecimal getTotalAmount() throws Exception {
        return this.totalAmount;
    }

    public Currency getCurrency() {
        if (this.currencyCode != null) {
            return Currency.getInstance(this.currencyCode);
        }
        return null;
    }

    @Override
    public void handleEOF() {
    }

    private static class Lookup {
        String bankCode;
        String account;
        String initiator;

        public Lookup(AccountServicingInstitution asi, OrderingCustomer oc, InstructingParty ip) {
            String[] s;
            if (asi instanceof Field52A) {
                this.bankCode = ((Field52A)asi).getBIC();
            }
            if (ip instanceof Field50L) {
                this.initiator = ((Field50L)ip).getIdentifier();
            } else if (oc instanceof Field50H) {
                this.initiator = ((Field50H)oc).getAddress()[0];
            } else if (oc instanceof Field50F && (s = ((Field50F)oc).getParsedName()) != null && s.length != 0) {
                this.initiator = s[0];
            }
            if (oc != null) {
                this.account = oc.getAccount();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Lookup)) {
                return false;
            }
            Lookup o = (Lookup)obj;
            return Objects.equals(this.bankCode, o.bankCode) && Objects.equals(this.account, o.account) && Objects.equals(this.initiator, o.initiator);
        }

        public int hashCode() {
            int toReturn = 0;
            if (this.bankCode != null) {
                toReturn = this.bankCode.hashCode();
            }
            if (this.account != null) {
                toReturn ^= Integer.rotateLeft(this.account.hashCode(), 10);
            }
            if (this.initiator != null) {
                toReturn ^= Integer.rotateLeft(this.initiator.hashCode(), 20);
            }
            return toReturn;
        }
    }
}

