/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.dta.BundesbankDtaLogicalFile;
import de.businesslogics.format.dta.BundesbankForeignSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftExtractor;
import de.businesslogics.format.dta.BundesbankSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftListener;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.SLF;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.Ticket;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class HBVSwiftDisplayMessageGenerator
implements DisplayMessageGenerator {
    private List<DTAUSLogicalFile> logicalFiles = new ArrayList<DTAUSLogicalFile>();
    private String expectedFileType;

    public HBVSwiftDisplayMessageGenerator(String expectedFileType) {
        this.expectedFileType = expectedFileType;
    }

    public HBVSwiftDisplayMessageGenerator() {
        this.expectedFileType = null;
    }

    @Override
    public Ticket getMessage(InputStream in) throws Exception {
        this.logicalFiles.clear();
        MyBundesbankForeignSwiftListener listener = new MyBundesbankForeignSwiftListener();
        BundesbankSwiftExtractor out = new BundesbankSwiftExtractor(listener, SLF.SLF_6_UNCOMPRESSED, this.expectedFileType);
        Streams.copy(in, out);
        return new Ticket(this.logicalFiles);
    }

    private class MyBundesbankForeignSwiftListener
    implements BundesbankSwiftListener {
        private boolean hasForeignCurrency;
        private String uniqueCurrency;

        private MyBundesbankForeignSwiftListener() {
            this.hasForeignCurrency = "WT".equals(HBVSwiftDisplayMessageGenerator.this.expectedFileType);
        }

        @Override
        public void startLogicalFile(DTAUSLogicalFile logicalFile) {
            if (this.hasForeignCurrency) {
                this.uniqueCurrency = null;
            }
        }

        @Override
        public void handleItem(DTAUSItem item) {
        }

        @Override
        public void handleSwiftItem(BundesbankSwiftItem item) {
            if (this.hasForeignCurrency && item instanceof BundesbankForeignSwiftItem) {
                String currency = ((BundesbankForeignSwiftItem)item).getCurrency().getCurrencyCode();
                if (this.uniqueCurrency == null) {
                    this.uniqueCurrency = currency;
                } else if (!this.uniqueCurrency.equals(currency)) {
                    this.uniqueCurrency = "NONE";
                }
            }
        }

        @Override
        public void endLogicalFile(DTAUSLogicalFile logicalFile) {
            if (this.hasForeignCurrency && logicalFile instanceof BundesbankDtaLogicalFile) {
                String currency = "NONE".equals(this.uniqueCurrency) ? null : this.uniqueCurrency;
                ((BundesbankDtaLogicalFile)logicalFile).setUniqueCurrencyCode(currency);
            }
            HBVSwiftDisplayMessageGenerator.this.logicalFiles.add(logicalFile);
        }

        @Override
        public void consumeError(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }

        @Override
        public void handleWarning(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }
    }

    public static class TG
    extends HBVSwiftDisplayMessageGenerator {
        public TG() {
            super("TG");
        }
    }

    public static class WT
    extends HBVSwiftDisplayMessageGenerator {
        public WT() {
            super("WT");
        }
    }

    public static class DT
    extends HBVSwiftDisplayMessageGenerator {
        public DT() {
            super("DT");
        }
    }

    public static class GT
    extends HBVSwiftDisplayMessageGenerator {
        public GT() {
            super("GT");
        }
    }
}

