/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.BinaryGenerator;
import de.businesslogics.format.ticket.BundesbankDtaU4DisplayMessageGenerator;
import de.businesslogics.format.ticket.C07DisplayMessageGenerator;
import de.businesslogics.format.ticket.CC7DisplayMessageGenerator;
import de.businesslogics.format.ticket.CCCDisplayMessageGenerator;
import de.businesslogics.format.ticket.CDxContainerDisplayMessageGenerator;
import de.businesslogics.format.ticket.CDxDisplayMessageGenerator;
import de.businesslogics.format.ticket.CIPDisplayMessageGenerator;
import de.businesslogics.format.ticket.DTAUSDisplayMessageGenerator;
import de.businesslogics.format.ticket.DTAZVGenerator;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.HBVSwiftDisplayMessageGenerator;
import de.businesslogics.format.ticket.MCVDisplayMessageGenerator;
import de.businesslogics.format.ticket.McvGenerator;
import de.businesslogics.format.ticket.Messages;
import de.businesslogics.format.ticket.PackedStep2PaymentDisplayMessageGenerator;
import de.businesslogics.format.ticket.SEPACreditDisplayMessageGenerator;
import de.businesslogics.format.ticket.Step2PaymentDisplayMessageGenerator;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLParagraph;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class DispatchNote {
    private static final HashMap<String, Class<? extends DisplayMessageGenerator>> GENERATORS = new HashMap();
    private static final List<PatternConfig> PATTERN_CONFIGS = new ArrayList<PatternConfig>();

    public static DisplayMessageGenerator findGenerator(String orderType) {
        Class<? extends DisplayMessageGenerator> c = GENERATORS.get(orderType);
        if (c == null) {
            for (PatternConfig pc : PATTERN_CONFIGS) {
                if (!pc.pattern.matcher(orderType).matches()) continue;
                c = pc.generator;
                break;
            }
        }
        try {
            if (c != null) {
                if (SEPACreditDisplayMessageGenerator.class.equals(c)) {
                    return new SEPACreditDisplayMessageGenerator(true);
                }
                return c.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static DisplayMessage createDisplayMessage(InputStream in, String orderType) throws Exception {
        DisplayMessageGenerator g = DispatchNote.findGenerator(orderType);
        if (g == null) {
            g = new BinaryGenerator();
        }
        return g.getMessage(in);
    }

    public static void createDispatchNote(InputStream in, OutputStream out, String orderType, String orderNumber, String customerId, Locale l) throws PDFException, Exception {
        DisplayMessageGenerator g = DispatchNote.findGenerator(orderType);
        if (g == null) {
            g = new BinaryGenerator();
        }
        DispatchNote.createDispatchNote(g.getMessage(in), out, orderType, orderNumber, customerId, l);
    }

    public static void createDispatchNote(DisplayMessage dMsg, OutputStream out, String orderType, String orderNumber, String customerId, Locale l) throws PDFException {
        if (l == null) {
            l = Locale.getDefault();
        }
        BLDocument document = DispatchNote.createDocument(out, l);
        DispatchNote.addTitle(document, l);
        String msg = null;
        msg = customerId == null ? (orderNumber == null ? MessageFormat.format(Messages.getString("DispatchNote.info3", l), orderType) : MessageFormat.format(Messages.getString("DispatchNote.info2", l), orderType, orderNumber)) : MessageFormat.format(Messages.getString("DispatchNote.info", l), orderType, orderNumber, customerId);
        BLParagraph<?> p = PDFCreator.getInstance().createParagraph(msg, BLFont.FONT_LARGE);
        p.setTextAlignment(Alignment.ALIGN_CENTER);
        document.add(p);
        DispatchNote.addText(document, dMsg, l);
        DispatchNote.addSignature(document, l);
        document.close();
    }

    public static void addText(BLDocument document, DisplayMessage dMsg, Locale l) throws PDFException {
        StringBuilder b = new StringBuilder();
        if (dMsg != null) {
            dMsg.appendText(l, b);
        }
        BLParagraph<?> p = PDFCreator.getInstance().createParagraph(b.toString(), BLFont.COURIER_SMALL);
        p.setSpacingBefore(5.0f);
        document.add(p);
    }

    public static void addSignature(BLDocument document, Locale l) throws PDFException {
        document.addSignatureFields(BLFont.FONT_LARGE, Alignment.ALIGN_CENTER, Messages.getString("DispatchNote.place.and.date", l), Messages.getString("DispatchNote.signature", l));
    }

    public static BLDocument createDocument(OutputStream out, Locale l) throws PDFException {
        BLDocument document = PDFCreator.getInstance().createDocument(BLDocument.PageLayout.A4);
        document.addMetaInformation(Messages.getString("DispatchNote.title", l), Messages.getString("DispatchNote.author", l), Messages.getString("DispatchNote.creator", l), true, true);
        document.open(out);
        return document;
    }

    public static void addTitle(BLDocument document, Locale l) throws PDFException {
        document.addHeadline(Messages.getString("DispatchNote.paper.title", l), Alignment.ALIGN_CENTER);
    }

    public static void main(String[] args) throws Exception {
        DisplayMessage msg;
        try (FileInputStream fin = new FileInputStream(args[0]);){
            msg = DispatchNote.createDisplayMessage(fin, args[1]);
        }
        StringBuilder b = new StringBuilder();
        msg.appendText(Locale.getDefault(), b);
        System.out.println(b.toString());
    }

    public static synchronized void announceGenerator(String orderType, Class<? extends DisplayMessageGenerator> generator) {
        GENERATORS.put(orderType, generator);
    }

    public static synchronized void announceGenerator(Pattern pattern, Class<? extends DisplayMessageGenerator> g) {
        PATTERN_CONFIGS.add(new PatternConfig(pattern, g));
    }

    static {
        GENERATORS.put("DTAUS", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("DTAZV", DTAZVGenerator.class);
        GENERATORS.put("DTAUS_EBCDIC", BundesbankDtaU4DisplayMessageGenerator.class);
        GENERATORS.put("DTAUS_EBCDIC_PACKED", McvGenerator.class);
        GENERATORS.put("STEP2_EBCDIC", Step2PaymentDisplayMessageGenerator.class);
        GENERATORS.put("STEP2_EBCDIC_PACKED", PackedStep2PaymentDisplayMessageGenerator.class);
        GENERATORS.put("HBV_SWIFT", HBVSwiftDisplayMessageGenerator.class);
        GENERATORS.put("AZV", DTAZVGenerator.class);
        GENERATORS.put("C1C", CDxContainerDisplayMessageGenerator.class);
        GENERATORS.put("C2C", CDxContainerDisplayMessageGenerator.class);
        GENERATORS.put("CCC", CCCDisplayMessageGenerator.class);
        GENERATORS.put("CCM", null);
        GENERATORS.put("CCS", CCCDisplayMessageGenerator.class);
        GENERATORS.put("CCT", SEPACreditDisplayMessageGenerator.class);
        GENERATORS.put("CTV", SEPACreditDisplayMessageGenerator.class);
        GENERATORS.put("CCU", SEPACreditDisplayMessageGenerator.class);
        GENERATORS.put("CCX", CCCDisplayMessageGenerator.class);
        GENERATORS.put("CD1", CDxDisplayMessageGenerator.class);
        GENERATORS.put("CDB", CDxDisplayMessageGenerator.class);
        GENERATORS.put("CDC", CDxContainerDisplayMessageGenerator.class);
        GENERATORS.put("CDD", CDxDisplayMessageGenerator.class);
        GENERATORS.put("CIP", CIPDisplayMessageGenerator.class);
        GENERATORS.put("CIV", CIPDisplayMessageGenerator.class);
        GENERATORS.put("DTE", DTAUSDisplayMessageGenerator.IZG.class);
        GENERATORS.put("DTT", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("DTV", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("ECS", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("EDC", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("ESU", DTAZVGenerator.class);
        GENERATORS.put("EUE", DTAZVGenerator.class);
        GENERATORS.put("GKT", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("IZG", DTAUSDisplayMessageGenerator.IZG.class);
        GENERATORS.put("IZL", DTAUSDisplayMessageGenerator.IZL.class);
        GENERATORS.put("IZV", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("MCV", McvGenerator.class);
        GENERATORS.put("MC2", McvGenerator.class);
        GENERATORS.put("MC4", McvGenerator.class);
        GENERATORS.put("POZ", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("RDT", DTAUSDisplayMessageGenerator.IZV.class);
        GENERATORS.put("XG1", BundesbankDtaU4DisplayMessageGenerator.GT.class);
        GENERATORS.put("XGK", BundesbankDtaU4DisplayMessageGenerator.GK.class);
        GENERATORS.put("XLK", BundesbankDtaU4DisplayMessageGenerator.LK.class);
        GENERATORS.put("QG1", BundesbankDtaU4DisplayMessageGenerator.GT.class);
        GENERATORS.put("QE9", BundesbankDtaU4DisplayMessageGenerator.GB.class);
        GENERATORS.put("QEA", BundesbankDtaU4DisplayMessageGenerator.LB.class);
        GENERATORS.put("XCG", MCVDisplayMessageGenerator.Bundesbank.class);
        GENERATORS.put("XCL", MCVDisplayMessageGenerator.Bundesbank.class);
        GENERATORS.put("QE1", MCVDisplayMessageGenerator.Bundesbank.class);
        GENERATORS.put("QE3", MCVDisplayMessageGenerator.Bundesbank.class);
        GENERATORS.put("XGS", Step2PaymentDisplayMessageGenerator.class);
        GENERATORS.put("XCS", PackedStep2PaymentDisplayMessageGenerator.class);
        GENERATORS.put("QE7", PackedStep2PaymentDisplayMessageGenerator.class);
        GENERATORS.put("QE8", Step2PaymentDisplayMessageGenerator.class);
        GENERATORS.put("XG2", HBVSwiftDisplayMessageGenerator.GT.class);
        GENERATORS.put("XDT", HBVSwiftDisplayMessageGenerator.DT.class);
        GENERATORS.put("XWT", HBVSwiftDisplayMessageGenerator.WT.class);
        GENERATORS.put("XTG", HBVSwiftDisplayMessageGenerator.TG.class);
        GENERATORS.put("pain.001.001.02.sct", null);
        GENERATORS.put("pain.008.001.01.sdd", null);
        GENERATORS.put("pain.008.001.01.sbb", null);
        GENERATORS.put("pain.xxx.cfonb160.dct", null);
        GENERATORS.put("pain.xxx.cfonb160.ict", null);
        GENERATORS.put("pain.xxx.cfonb160.ddd", null);
        GENERATORS.put("pain.xxx.cfonb160.dda", null);
        GENERATORS.put("pain.xxx.cfonb160.dco", null);
        GENERATORS.put("C07", C07DisplayMessageGenerator.class);
        GENERATORS.put("CC7", CC7DisplayMessageGenerator.class);
    }

    private static class PatternConfig {
        final Pattern pattern;
        final Class<? extends DisplayMessageGenerator> generator;

        private PatternConfig(Pattern pattern, Class<? extends DisplayMessageGenerator> generator) {
            this.pattern = pattern;
            this.generator = generator;
        }
    }
}

