/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.dta.DTAZVExtractor;
import de.businesslogics.format.dta.DTAZVItem;
import de.businesslogics.format.dta.DTAZVLogicalFile;
import de.businesslogics.format.dta.InvalidAmountException;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.Ticket;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DTAZVGenerator
implements DisplayMessageGenerator {
    private final List<DTAZVLogicalFile> logicalFiles = new ArrayList<DTAZVLogicalFile>();
    private final List<InvalidFileException> exceptions = new ArrayList<InvalidFileException>();
    private final boolean checkZeroAmount;

    public DTAZVGenerator() {
        this.checkZeroAmount = false;
    }

    public DTAZVGenerator(boolean checkZeroAmount) {
        this.checkZeroAmount = checkZeroAmount;
    }

    @Override
    public Ticket getMessage(InputStream in) throws Exception {
        DTAZVExtractor extractor = new DTAZVExtractor(new DTAZVListener());
        Streams.copy(in, extractor);
        if (this.exceptions.isEmpty()) {
            return new Ticket(this.logicalFiles);
        }
        throw this.exceptions.get(0);
    }

    private class DTAZVListener
    implements DTAZVExtractor.DTAZVListener {
        private DTAZVListener() {
        }

        @Override
        public void consumeError(InvalidFileException ife) {
            DTAZVGenerator.this.exceptions.add(ife);
        }

        @Override
        public void handleWarning(InvalidFileException ife) throws InvalidFileException {
            DTAZVGenerator.this.exceptions.add(ife);
        }

        @Override
        public void endLogicalFile(DTAZVLogicalFile logicalFile) {
            DTAZVGenerator.this.logicalFiles.add(logicalFile);
        }

        @Override
        public void handleItem(DTAZVItem item) {
            if (DTAZVGenerator.this.checkZeroAmount && item.getAmount() == 0L) {
                DTAZVGenerator.this.exceptions.add(new InvalidAmountException("0"));
            }
        }

        @Override
        public void startLogicalFile(DTAZVLogicalFile logicalFile) {
        }
    }
}

