/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.Camt055DisplayMessage;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.InputStream;
import java.math.BigDecimal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Camt055DisplayMessageGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P_ASSGNMT_ID;
    public static final SmartDefaultHandler.Path P_ASSGNR_NM;
    public static final SmartDefaultHandler.Path P_ASSGNE_BIC;
    public static final SmartDefaultHandler.Path P_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P_ORGNL_PMT_INF_AND_CXL;
    public static final SmartDefaultHandler.Path P_CASE_ID;
    public static final SmartDefaultHandler.Path P_CASE_ORG_BIC;
    public static final SmartDefaultHandler.Path P_CASE_CRETR_ID;
    public static final SmartDefaultHandler.Path P_ORGNL_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P_ORGNL_MSG_ID;
    public static final SmartDefaultHandler.Path P_ORGNL_MSG_NM_ID;
    public static final SmartDefaultHandler.Path P_ORGNL_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P_ORGNL_CTRL_SUM;
    public static final SmartDefaultHandler.Path P_INF_CXL;
    public static final SmartDefaultHandler.Path P_RSN_CD;
    public static final SmartDefaultHandler.Path P_RSN_PRTRY;
    public static final SmartDefaultHandler.Path P_ADDTL_INF;
    public static final SmartDefaultHandler.Path P_TX_INF;
    public static final SmartDefaultHandler.Path P_RSN_CD_TX;
    public static final SmartDefaultHandler.Path P_RSN_PRTRY_TX;
    public static final SmartDefaultHandler.Path P_ADDTL_INF_TX;
    public static final SmartDefaultHandler.Path P_TX_INSTD_AMT;
    private boolean pmtInfCxl;
    private String namespace;
    private Camt055DisplayMessage ticket;

    public String getNamespace() {
        return this.namespace;
    }

    @SmartDefaultHandler.Callback(value={"P_ASSGNMT_ID"})
    public void setAssignmentId() {
        this.namespace = this.getPath().getUri();
        this.ticket.assignmentId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ASSGNR_NM"})
    public void setAssignerName() {
        this.ticket.assignerName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ASSGNE_BIC"})
    public void setAssigneeBic() {
        this.ticket.assigneeBic = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_CRE_DT_TM"})
    public void setCreationDateTime() throws SAXParseException {
        this.ticket.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P_CASE_ID"})
    public void setCaseId() {
        this.ticket.caseId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_CASE_ORG_BIC"})
    public void setOriginatorBic() {
        this.ticket.caseCreatorBic = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_CASE_CRETR_ID"})
    public void setOriginatorIban() {
        this.ticket.caseCreatorIban = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ORGNL_PMT_INF_ID"})
    public void setOriginalLogicalFileId() {
        this.ticket.originalLogicalFileId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ORGNL_MSG_ID"})
    public void setOriginalMessageId() {
        this.ticket.originalMessageId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ORGNL_MSG_NM_ID"})
    public void setOriginalMessageName() {
        this.ticket.originalMessageName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ORGNL_NB_OF_TXS"})
    public void setOriginalNbOfTxs() throws SAXParseException {
        this.ticket.originalNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P_ORGNL_CTRL_SUM"})
    public void setOriginalCtrlSum() throws SAXParseException {
        this.ticket.originalCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P_INF_CXL"})
    public void setPmtInfCxl() throws SAXParseException {
        this.pmtInfCxl = this.getBoolean();
    }

    @SmartDefaultHandler.Callback(value={"P_RSN_CD", "P_RSN_PRTRY"})
    public void setReasonCode() {
        this.ticket.reasonCode = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_TX_INF"})
    public void startTxInf(Attributes atts) throws SAXParseException {
        if (this.pmtInfCxl) {
            throw new SAXParseException("<TxInf> must not be present, if <PmtInfCxl> is true (C21).", this.locator);
        }
    }

    @SmartDefaultHandler.Callback(value={"P_TX_INSTD_AMT"})
    public BigDecimal setTxInstdAmt() throws SAXParseException {
        BigDecimal amt = this.getDecimal();
        this.ticket.ctrlSum = this.ticket.ctrlSum == null ? amt : this.ticket.ctrlSum.add(amt);
        return amt;
    }

    @SmartDefaultHandler.Callback(value={"P_RSN_CD_TX", "P_RSN_PRTRY_TX"})
    public void setReasonCodeTx() {
        String rc = this.getString();
        if (this.ticket.reasonCode == null) {
            if (this.ticket.revokedNbOfTxs == 0) {
                this.ticket.reasonCode = rc;
            }
        } else if (!rc.equals(this.ticket.reasonCode)) {
            this.ticket.reasonCode = null;
        }
    }

    @SmartDefaultHandler.Callback(value={"P_ADDTL_INF"})
    public void setAddtlInf() {
        this.ticket.additionalCallbackInfo = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P_ADDTL_INF_TX"})
    public void setAddtlInfTx() {
        if (this.ticket.additionalCallbackInfo == null) {
            this.ticket.additionalCallbackInfo = this.getString();
        }
    }

    @SmartDefaultHandler.Callback(value={"P_TX_INF"})
    public void endTxInf() {
        ++this.ticket.revokedNbOfTxs;
    }

    @SmartDefaultHandler.Callback(value={"P_ORGNL_PMT_INF_AND_CXL"})
    public void endOrgnlPmtInfAndCxl() throws SAXParseException {
        if (!this.pmtInfCxl && this.ticket.revokedNbOfTxs == 0) {
            throw new SAXParseException("<TxInf> must be present, if <PmtInfCxl> is false (C20).", this.locator);
        }
    }

    public Camt055DisplayMessage getMessage() {
        return this.ticket;
    }

    @Override
    public Camt055DisplayMessage getMessage(InputStream in) throws Exception {
        this.parse(in);
        return this.ticket;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.ticket = this.mkTicket();
    }

    protected Camt055DisplayMessage mkTicket() {
        return new Camt055DisplayMessage();
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        return "urn:iso:std:iso:20022:tech:xsd:camt.055.001.05 /de/businesslogics/format/dk31/camt.055.001.05_bl.xsd";
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:camt.055.001.05", "Document");
        SmartDefaultHandler.Path cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrPmtCxlReq");
        SmartDefaultHandler.Path assgnmt = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "Assgnmt");
        P_ASSGNMT_ID = new SmartDefaultHandler.Path(assgnmt, "Id");
        SmartDefaultHandler.Path assgnr = new SmartDefaultHandler.Path(assgnmt, "Assgnr");
        SmartDefaultHandler.Path pty = new SmartDefaultHandler.Path(assgnr, "Pty");
        P_ASSGNR_NM = new SmartDefaultHandler.Path(pty, "Nm");
        SmartDefaultHandler.Path assgne = new SmartDefaultHandler.Path(assgnmt, "Assgne");
        SmartDefaultHandler.Path agt = new SmartDefaultHandler.Path(assgne, "Agt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(agt, "FinInstnId");
        P_ASSGNE_BIC = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        P_CRE_DT_TM = new SmartDefaultHandler.Path(assgnmt, "CreDtTm");
        SmartDefaultHandler.Path undrlyg = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "Undrlyg");
        P_ORGNL_PMT_INF_AND_CXL = new SmartDefaultHandler.Path(undrlyg, "OrgnlPmtInfAndCxl");
        SmartDefaultHandler.Path casePath = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "Case");
        P_CASE_ID = new SmartDefaultHandler.Path(casePath, "Id");
        SmartDefaultHandler.Path cretr = new SmartDefaultHandler.Path(casePath, "Cretr");
        SmartDefaultHandler.Path pty2 = new SmartDefaultHandler.Path(cretr, "Pty");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(pty2, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        P_CASE_ORG_BIC = new SmartDefaultHandler.Path(orgId, "AnyBIC");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P_CASE_CRETR_ID = new SmartDefaultHandler.Path(othr, "Id");
        P_ORGNL_PMT_INF_ID = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "OrgnlPmtInfId");
        SmartDefaultHandler.Path orgnlGrpInf = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "OrgnlGrpInf");
        P_ORGNL_MSG_ID = new SmartDefaultHandler.Path(orgnlGrpInf, "OrgnlMsgId");
        P_ORGNL_MSG_NM_ID = new SmartDefaultHandler.Path(orgnlGrpInf, "OrgnlMsgNmId");
        P_ORGNL_NB_OF_TXS = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "NbOfTxs");
        P_ORGNL_CTRL_SUM = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "CtrlSum");
        P_INF_CXL = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "PmtInfCxl");
        SmartDefaultHandler.Path cxlRsnInf = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "CxlRsnInf");
        SmartDefaultHandler.Path rsn = new SmartDefaultHandler.Path(cxlRsnInf, "Rsn");
        P_RSN_CD = new SmartDefaultHandler.Path(rsn, "Cd");
        P_RSN_PRTRY = new SmartDefaultHandler.Path(rsn, "Prtry");
        P_ADDTL_INF = new SmartDefaultHandler.Path(cxlRsnInf, "AddtlInf");
        P_TX_INF = new SmartDefaultHandler.Path(P_ORGNL_PMT_INF_AND_CXL, "TxInf");
        P_TX_INSTD_AMT = new SmartDefaultHandler.Path(P_TX_INF, "OrgnlInstdAmt");
        SmartDefaultHandler.Path cxlRsnInfTx = new SmartDefaultHandler.Path(P_TX_INF, "CxlRsnInf");
        SmartDefaultHandler.Path rsn2 = new SmartDefaultHandler.Path(cxlRsnInfTx, "Rsn");
        P_RSN_CD_TX = new SmartDefaultHandler.Path(rsn2, "Cd");
        P_RSN_PRTRY_TX = new SmartDefaultHandler.Path(rsn2, "Prtry");
        P_ADDTL_INF_TX = new SmartDefaultHandler.Path(cxlRsnInfTx, "AddtlInf");
    }
}

