/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;

public class Camt055DisplayMessage
extends AbstractDisplayMessage {
    private static final long serialVersionUID = 1L;
    String assignmentId;
    String assignerName;
    String assigneeBic;
    Date creationDateTime;
    String caseId;
    String caseCreatorBic;
    String caseCreatorIban;
    String originalLogicalFileId;
    String originalMessageId;
    String originalMessageName;
    int revokedNbOfTxs;
    Long originalNbOfTxs;
    BigDecimal originalCtrlSum;
    String reasonCode;
    String additionalCallbackInfo;
    BigDecimal ctrlSum = null;

    @Override
    public void append() {
        this.append(this);
        this.mainSeparator();
    }

    protected void append(AbstractDisplayMessage message) {
        String[] sArr;
        message.mainSeparator();
        if (this.revokedNbOfTxs == 0) {
            if ("pain.008".equals(this.originalMessageName)) {
                message.writeLine("CAMT055_DEBIT_LOGICAL_FILE");
            } else if ("pain.001".equals(this.originalMessageName)) {
                message.writeLine("CAMT055_CREDIT_LOGICAL_FILE");
            } else {
                message.writeLine("CAMT055_LOGICAL_FILE");
            }
        } else if ("pain.008".equals(this.originalMessageName)) {
            message.writeLine("CAMT055_DEBIT_TRANSACTIONS");
        } else if ("pain.001".equals(this.originalMessageName)) {
            message.writeLine("CAMT055_CREDIT_TRANSACTIONS");
        } else {
            message.writeLine("CAMT055_TRANSACTIONS");
        }
        message.minorSeparator();
        this.calculateKeyWidth("ASSIGNER_NAME", "ASSIGNEE_BIC", "FILE_ID", "CASE_ID", "TIMESTAMP");
        if (this.reasonCode != null) {
            this.enlargeKeyWidth("CANCEL_REASON");
        }
        if (this.additionalCallbackInfo != null) {
            this.enlargeKeyWidth("ADDITIONAL_CALLBACK_INFO");
        }
        if (this.revokedNbOfTxs > 0) {
            this.enlargeKeyWidth("NB_OF_TXS");
            if (this.ctrlSum != null) {
                this.enlargeKeyWidth("CTRL_SUM_EUR");
            }
        }
        message.writeKeyValue("ASSIGNER_NAME", this.assignerName);
        message.writeKeyValue("ASSIGNEE_BIC", this.assigneeBic);
        message.writeKeyValue("CANCEL_REASON", this.reasonCode);
        if (this.additionalCallbackInfo != null && (sArr = StringUtils.getStringArrayFromString(this.additionalCallbackInfo, 45)) != null) {
            for (int i = 0; i < sArr.length; ++i) {
                if (i == 0) {
                    message.writeKeyValue("ADDITIONAL_CALLBACK_INFO", sArr[i]);
                    continue;
                }
                message.writeRawKeyValue("", sArr[i]);
            }
        }
        message.writeKeyValue("FILE_ID", this.assignmentId);
        message.writeKeyValue("CASE_ID", this.caseId);
        message.writeDate("TIMESTAMP", "TIMESTAMP_FORMAT", this.creationDateTime);
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(this.locale));
        if (this.revokedNbOfTxs > 0) {
            message.writeKeyValue("NB_OF_TXS", Integer.toString(this.revokedNbOfTxs));
            if (this.ctrlSum != null) {
                message.writeKeyValue("CTRL_SUM_EUR", df.format(this.ctrlSum));
            }
        }
        message.minorSeparator();
        message.writeLine("ORIGINAL_ORDER_DATA");
        this.calculateKeyWidth("FILE_ID", "PMT_INF_ID", "ACCOUNT_NUMBER");
        if (this.caseCreatorBic != null) {
            this.enlargeKeyWidth("BANK_CODE");
        }
        if (this.originalNbOfTxs != null) {
            this.enlargeKeyWidth("NB_OF_TXS");
        }
        if (this.originalCtrlSum != null) {
            this.enlargeKeyWidth("CTRL_SUM_EUR");
        }
        message.writeKeyValue("FILE_ID", this.originalMessageId);
        message.writeKeyValue("PMT_INF_ID", this.originalLogicalFileId);
        message.writeKeyValue("BANK_CODE", this.caseCreatorBic);
        message.writeKeyValue("ACCOUNT_NUMBER", this.caseCreatorIban);
        if (this.originalNbOfTxs != null) {
            message.writeKeyValue("NB_OF_TXS", this.originalNbOfTxs.toString());
        }
        if (this.originalCtrlSum != null) {
            message.writeKeyValue("CTRL_SUM_EUR", df.format(this.originalCtrlSum));
        }
    }

    public boolean isCreditCallback() {
        return "pain.001".equals(this.originalMessageName);
    }

    public String getAssignmentId() {
        return this.assignmentId;
    }

    public String getAssignerName() {
        return this.assignerName;
    }

    public String getAssigneeBic() {
        return this.assigneeBic;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public String getCaseCreatorBic() {
        return this.caseCreatorBic;
    }

    public String getCaseCreatorIban() {
        return this.caseCreatorIban;
    }

    public String getOriginalLogicalFileId() {
        return this.originalLogicalFileId;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public String getOriginalMessageName() {
        return this.originalMessageName;
    }

    public int getRevokedNbOfTxs() {
        return this.revokedNbOfTxs;
    }

    public Long getOriginalNbOfTxs() {
        return this.originalNbOfTxs;
    }

    public BigDecimal getOriginalCtrlSum() {
        return this.originalCtrlSum;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }
}

