/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.CcyException;
import de.businesslogics.format.ticket.CtrlSumException;
import de.businesslogics.format.ticket.LclInstException;
import de.businesslogics.format.ticket.NbOfTxsException;
import de.businesslogics.format.ticket.OmniscientXmlDisplayMessageGenerator;
import de.businesslogics.format.ticket.Pain00100103Ticket;
import de.businesslogics.format.ticket.SvcLvlException;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.math.BigDecimal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CIPDisplayMessageGenerator
extends OmniscientXmlDisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P113_CSTMR_CDT_TRF_INITN = P113_MSG_ID.getParent().getParent();
    public static final SmartDefaultHandler.Path P113_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(P113_MSG_ID.getParent(), "NbOfTxs");
    public static final SmartDefaultHandler.Path P113_HDR_CTRL_SUM = new SmartDefaultHandler.Path(P113_MSG_ID.getParent(), "CtrlSum");
    public static final SmartDefaultHandler.Path P113_PMT_INF = P113_PMT_INF_ID.getParent();
    public static final SmartDefaultHandler.Path P113_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P113_PMT_INF, "NbOfTxs");
    public static final SmartDefaultHandler.Path P113_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P113_PMT_INF, "CtrlSum");
    public static final SmartDefaultHandler.Path P113_CDT_TRF_TX_INF = P113_TX_PMT_TP_INF.getParent();
    public static final SmartDefaultHandler.Path P113_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P113_PMT_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P113_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P113_TX_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P118_CSTMR_CDT_TRF_INITN;
    public static final SmartDefaultHandler.Path P118_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P118_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P118_PMT_INF;
    public static final SmartDefaultHandler.Path P118_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P118_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P118_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P118_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P118_PMT_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P118_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P118_TX_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P119_CSTMR_CDT_TRF_INITN;
    public static final SmartDefaultHandler.Path P119_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P119_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P119_PMT_INF;
    public static final SmartDefaultHandler.Path P119_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P119_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P119_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P119_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P119_PMT_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P119_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P119_TX_LCL_INSTRM;
    private boolean p113 = true;
    private boolean p118 = true;
    private boolean p1193 = true;
    private boolean p1194 = true;
    private boolean p1195 = true;
    private long hdrNbOfTxs;
    private int pmtNbOfTxs;
    private boolean pmtSvcLvlSeen;
    private boolean pmtLclInstrmSeen;
    private boolean txSvcLvlSeen;
    private boolean txLclInstrmSeen;
    private BigDecimal hdrCtrlSum;
    private BigDecimal pmtCtrlSum;

    protected boolean isNamespaceP119() {
        String uri = this.getPath().getUri();
        return "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09".equals(uri);
    }

    public boolean isP113() {
        return this.p113;
    }

    public void setP113(boolean p113) {
        this.p113 = p113;
    }

    public boolean isP118() {
        return this.p118;
    }

    public void setP118(boolean p118) {
        this.p118 = p118;
    }

    public boolean isP1193() {
        return this.p1193;
    }

    public void setP1193(boolean p1193) {
        this.p1193 = p1193;
    }

    public boolean isP1194() {
        return this.p1194;
    }

    public void setP1194(boolean p1194) {
        this.p1194 = p1194;
    }

    public boolean isP1195() {
        return this.p1195;
    }

    public void setP1195(boolean p1195) {
        this.p1195 = p1195;
    }

    public void setValidateScheme(boolean validateScheme) {
        this.p1194 = this.p1195 = validateScheme;
        this.p1193 = this.p1195;
        this.p118 = this.p1195;
        this.p113 = this.p1195;
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        StringBuilder toReturn = new StringBuilder();
        if (this.p113) {
            CIPDisplayMessageGenerator.appendNamespaceSchemaLocation(toReturn, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "/de/businesslogics/format/dk33/pain.001.001.03_GBIC_3.xsd");
        }
        if (this.p118) {
            CIPDisplayMessageGenerator.appendNamespaceSchemaLocation(toReturn, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.08", "/de/businesslogics/format/dk33/pain.001.001.08_GBIC_3.xsd");
        }
        if (this.p1195) {
            CIPDisplayMessageGenerator.appendNamespaceSchemaLocation(toReturn, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", this.p1193 ? "/de/businesslogics/format/dk39/pain.001.001.09_CIP_GBIC_35.xsd" : "/de/businesslogics/format/dk39/pain.001.001.09_GBIC_5.xsd");
        } else if (this.p1193) {
            CIPDisplayMessageGenerator.appendNamespaceSchemaLocation(toReturn, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", this.p1194 ? "/de/businesslogics/format/dk37/pain.001.001.09_GBIC_3and4.xsd" : "/de/businesslogics/format/dk35/pain.001.001.09_GBIC_3.xsd");
        } else if (this.p1194) {
            CIPDisplayMessageGenerator.appendNamespaceSchemaLocation(toReturn, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk37/pain.001.001.09_GBIC_4.xsd");
        }
        return CIPDisplayMessageGenerator.finishNamespaceSchemaLocations(toReturn);
    }

    @SmartDefaultHandler.Callback(value={"P113_CSTMR_CDT_TRF_INITN", "P118_CSTMR_CDT_TRF_INITN", "P119_CSTMR_CDT_TRF_INITN"})
    public void startCstmrCdtTrfInitn(Attributes attrs) {
        this.hdrNbOfTxs = 0L;
        this.hdrCtrlSum = null;
    }

    @SmartDefaultHandler.Callback(value={"P113_CSTMR_CDT_TRF_INITN", "P118_CSTMR_CDT_TRF_INITN", "P119_CSTMR_CDT_TRF_INITN"})
    public void endCstmrCdtTrfInitn() throws SAXException {
        if (this.p113Message.getTotalNumberOfPayments() != this.hdrNbOfTxs) {
            this.error(new SAXParseException("Wrong number of payments (expected " + this.p113Message.getTotalNumberOfPayments() + ")", this.locator));
        }
        if (this.hdrCtrlSum != null && this.hdrCtrlSum.compareTo(this.p113Message.getTotalAmount()) != 0) {
            this.error(new SAXParseException("Wrong control sum (expected " + String.valueOf(this.p113Message.getTotalAmount()) + ")", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_HDR_NB_OF_TXS", "P118_HDR_NB_OF_TXS", "P119_HDR_NB_OF_TXS"})
    public void setHdrNbOfTxs() throws SAXParseException {
        this.hdrNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P113_HDR_CTRL_SUM", "P118_HDR_CTRL_SUM", "P119_HDR_CTRL_SUM"})
    public void setHdrCtrlSum() throws SAXParseException {
        this.hdrCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF", "P118_PMT_INF", "P119_PMT_INF"})
    public void startPmtInf(Attributes attributes) throws SAXParseException {
        this.pmtNbOfTxs = 0;
        this.pmtCtrlSum = null;
        this.pmtSvcLvlSeen = false;
        this.pmtLclInstrmSeen = false;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF", "P118_PMT_INF", "P119_PMT_INF"})
    public void endPmtInf() throws SAXException {
        if (this.p113Payment.getNumberOfPayments() != this.pmtNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.p113Payment.numberOfPayments + ")", this.locator));
        }
        if (this.pmtCtrlSum != null && this.pmtCtrlSum.compareTo(this.p113Payment.ctrlSum) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.p113Payment.ctrlSum) + ")", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_SVC_LVL", "P118_PMT_SVC_LVL", "P119_PMT_SVC_LVL"})
    public void setP113PmtSvcLvl() throws SAXException {
        if (!"SEPA".equals(this.getString())) {
            this.error(new SvcLvlException("Service level must be SEPA", this.locator));
        }
        this.pmtSvcLvlSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_LCL_INSTRM", "P118_PMT_LCL_INSTRM", "P119_PMT_LCL_INSTRM"})
    public void setP113PmtLclInstrm() throws SAXException {
        if (!"INST".equals(this.getString())) {
            this.error(new LclInstException("Local instrument must be INST", this.locator));
        }
        this.pmtLclInstrmSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_NB_OF_TXS", "P118_PMT_NB_OF_TXS", "P119_PMT_NB_OF_TXS"})
    public void setPmtNbOfTxs() throws SAXParseException {
        this.pmtNbOfTxs = this.getInt();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_CTRL_SUM", "P118_PMT_CTRL_SUM", "P119_PMT_CTRL_SUM"})
    public void setPmtCtrlSum() throws SAXParseException {
        this.pmtCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P113_CDT_TRF_TX_INF", "P118_CDT_TRF_TX_INF", "P119_CDT_TRF_TX_INF"})
    public void startP113CdtTrfTxInf(Attributes atts) throws SAXParseException {
        this.txSvcLvlSeen = this.pmtSvcLvlSeen;
        this.txLclInstrmSeen = this.pmtLclInstrmSeen;
    }

    @Override
    public void startInstdAmt(Attributes attributes) throws SAXException {
        super.startInstdAmt(attributes);
        if (!(this.ccy == null || "EUR".equals(this.ccy) || this.isNamespaceP119() && this.p1194)) {
            this.error(new CcyException("Wrong currency " + this.ccy + " in Instructed Amount. Only EUR is allowed.", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_CDT_TRF_TX_INF", "P118_CDT_TRF_TX_INF", "P119_CDT_TRF_TX_INF"})
    public void endP113CdtTrfTxInf() throws SAXException {
        if (!this.txSvcLvlSeen) {
            this.error(new SvcLvlException("Service level must be SEPA", this.locator));
        }
        if (!this.txLclInstrmSeen) {
            this.error(new LclInstException("Local instrument must be INST", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_TX_SVC_LVL", "P118_TX_SVC_LVL", "P119_TX_SVC_LVL"})
    public void setP113TxSvcLvl() throws SAXException {
        if (!"SEPA".equals(this.getString())) {
            this.error(new SvcLvlException("Service level must be SEPA", this.locator));
        }
        this.txSvcLvlSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P113_TX_LCL_INSTRM", "P118_TX_LCL_INSTRM", "P119_TX_LCL_INSTRM"})
    public void setP113TxLclInstrm() throws SAXException {
        if (!"INST".equals(this.getString())) {
            this.error(new LclInstException("Local instrument must be INST", this.locator));
        }
        this.txLclInstrmSeen = true;
    }

    @Override
    public Pain00100103Ticket getMessage() {
        return (Pain00100103Ticket)super.getMessage();
    }

    static {
        SmartDefaultHandler.Path svcLvl = new SmartDefaultHandler.Path(P113_PMT_PMT_TP_INF, "SvcLvl");
        P113_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        SmartDefaultHandler.Path lclInstrm = new SmartDefaultHandler.Path(P113_PMT_PMT_TP_INF, "LclInstrm");
        P113_PMT_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        svcLvl = new SmartDefaultHandler.Path(P113_TX_PMT_TP_INF, "SvcLvl");
        P113_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(P113_TX_PMT_TP_INF, "LclInstrm");
        P113_TX_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P118_CSTMR_CDT_TRF_INITN = P118_MSG_ID.getParent().getParent();
        P118_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(P118_MSG_ID.getParent(), "NbOfTxs");
        P118_HDR_CTRL_SUM = new SmartDefaultHandler.Path(P118_MSG_ID.getParent(), "CtrlSum");
        P118_PMT_INF = P118_PMT_INF_ID.getParent();
        P118_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P118_PMT_INF, "NbOfTxs");
        P118_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P118_PMT_INF, "CtrlSum");
        P118_CDT_TRF_TX_INF = P118_TX_PMT_TP_INF.getParent();
        svcLvl = new SmartDefaultHandler.Path(P118_PMT_PMT_TP_INF, "SvcLvl");
        P118_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(P118_PMT_PMT_TP_INF, "LclInstrm");
        P118_PMT_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        svcLvl = new SmartDefaultHandler.Path(P118_TX_PMT_TP_INF, "SvcLvl");
        P118_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(P118_TX_PMT_TP_INF, "LclInstrm");
        P118_TX_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P119_CSTMR_CDT_TRF_INITN = P119_MSG_ID.getParent().getParent();
        P119_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(P119_MSG_ID.getParent(), "NbOfTxs");
        P119_HDR_CTRL_SUM = new SmartDefaultHandler.Path(P119_MSG_ID.getParent(), "CtrlSum");
        P119_PMT_INF = P119_PMT_INF_ID.getParent();
        P119_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P119_PMT_INF, "NbOfTxs");
        P119_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P119_PMT_INF, "CtrlSum");
        P119_CDT_TRF_TX_INF = P119_TX_PMT_TP_INF.getParent();
        svcLvl = new SmartDefaultHandler.Path(P119_PMT_PMT_TP_INF, "SvcLvl");
        P119_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(P119_PMT_PMT_TP_INF, "LclInstrm");
        P119_PMT_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        svcLvl = new SmartDefaultHandler.Path(P119_TX_PMT_TP_INF, "SvcLvl");
        P119_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(P119_TX_PMT_TP_INF, "LclInstrm");
        P119_TX_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
    }
}

