/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.CDxSingleTicket;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CDxTicket
extends AbstractDisplayMessage {
    private static final long serialVersionUID = 1L;
    List<CDxSingleTicket> singleTickets = new ArrayList<CDxSingleTicket>();
    String messageIdentification;
    Date creationDateTime;
    String debitType = "";
    String initiatorName;
    String initiatorId;

    public String getDebitType() {
        return this.debitType;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<CDxSingleTicket> getSingleTickets() {
        return this.singleTickets;
    }

    @Override
    public void append() {
        this.append(this);
        this.mainSeparator();
    }

    public void append(AbstractDisplayMessage message) {
        message.mainSeparator();
        message.calculateKeyWidth("FILE_ID", "TIMESTAMP", "INITIATOR_NAME", "INITIATOR_ID");
        message.buffer.append("     ").append(message.bundle.getString("DEBITS"));
        if (!StringUtils.isEmpty(this.debitType)) {
            message.buffer.append("  (");
            message.buffer.append(this.debitType);
            message.buffer.append(")");
        }
        message.buffer.append("\r\n");
        message.writeKeyValue("FILE_ID", this.messageIdentification);
        message.writeDate("TIMESTAMP", "TIMESTAMP_FORMAT", this.creationDateTime);
        message.writeKeyValue("INITIATOR_NAME", this.initiatorName);
        message.writeKeyValue("INITIATOR_ID", this.initiatorId);
        message.keyWidth = 0;
        if (Boolean.getBoolean("de.businesslogics.format.sepa.WithGroupTotal")) {
            message.calculateKeyWidth("TOTAL_AMOUNT", "TOTAL_ANZAHL");
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(this.locale));
            String amount = df.format(this.getTotalAmount());
            message.minorSeparator();
            message.writeKeyValue("TOTAL_ANZAHL", String.valueOf(this.getTotalNumberOfPayments()));
            message.writeKeyValue("TOTAL_AMOUNT", amount);
        }
        for (CDxSingleTicket t : this.singleTickets) {
            if (message.keyWidth == 0) {
                t.calculateKeyWidth(message);
            }
            t.append(message);
        }
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (CDxSingleTicket t : this.singleTickets) {
            totalAmount = totalAmount.add(t.getCtrlSum());
        }
        return totalAmount;
    }

    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (CDxSingleTicket t : this.singleTickets) {
            totalNumber += (long)t.getNumberOfPayments();
        }
        return totalNumber;
    }
}

