/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class CDxSingleTicket
implements Serializable {
    private static final long serialVersionUID = 1L;
    String paymentInformationIdentification;
    String creditorBIC;
    String creditorAccount;
    transient String creditorAccountCcy;
    String creditorName;
    YYMMDD requestedCollectionDate;
    BigDecimal ctrlSum = BigDecimal.ZERO;
    int numberOfPayments = 0;

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public String getCreditorAccount() {
        return this.creditorAccount;
    }

    @Deprecated
    public Currency getCreditorAccountCcy() {
        return this.creditorAccountCcy == null ? null : Currency.getInstance(this.creditorAccountCcy);
    }

    public String getCreditorBIC() {
        return this.creditorBIC;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }

    protected void append(AbstractDisplayMessage message) {
        message.minorSeparator();
        message.writeKeyValue("PMT_INF_ID", this.paymentInformationIdentification);
        message.writeKeyValue("BANK_CODE", this.creditorBIC);
        message.writeKeyValue("ACCOUNT_NUMBER", this.creditorAccount);
        message.writeKeyValue("ORIGINATOR2", this.creditorName);
        message.writeKeyValue("ANZAHL_DER_ZAHLUNGSSAETZE", Integer.toString(this.numberOfPayments));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(message.locale));
        message.writeKeyValue("CTRL_SUM_EUR", df.format(this.ctrlSum));
        message.writeDate("COLLECTION_DATE", "DATE_FORMAT", this.requestedCollectionDate);
    }

    public String getPaymentInformationIdentification() {
        return this.paymentInformationIdentification;
    }

    public YYMMDD getRequestedCollectionDate() {
        return this.requestedCollectionDate;
    }

    public void calculateKeyWidth(AbstractDisplayMessage message) {
        message.calculateKeyWidth("PMT_INF_ID", "BANK_CODE", "ACCOUNT_NUMBER", "ORIGINATOR2", "ANZAHL_DER_ZAHLUNGSSAETZE", "CTRL_SUM_EUR", "COLLECTION_DATE");
    }
}

