/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.CDxSingleTicket;
import de.businesslogics.format.ticket.CDxTicket;
import de.businesslogics.format.ticket.CcyException;
import de.businesslogics.format.ticket.CtrlSumException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.LclInstException;
import de.businesslogics.format.ticket.NbOfTxsException;
import de.businesslogics.format.ticket.SvcLvlException;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CDxDisplayMessageGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P818_MSG_ID;
    public static final SmartDefaultHandler.Path P818_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P818_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P818_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P818_INITG_NM;
    public static final SmartDefaultHandler.Path P818_INITG_ID;
    public static final SmartDefaultHandler.Path P818_PMT_INF;
    public static final SmartDefaultHandler.Path P818_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P818_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P818_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P818_SVC_LVL;
    public static final SmartDefaultHandler.Path P818_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P818_PMT_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P818_CDTR_NM;
    public static final SmartDefaultHandler.Path P818_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P818_CDTR_BIC;
    public static final SmartDefaultHandler.Path P818_CDTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P818_ULTMT_CDTR_ID;
    public static final SmartDefaultHandler.Path P818_DRCT_DBT_TX_INF;
    public static final SmartDefaultHandler.Path P818_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P818_TX_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P818_INSTD_AMT;
    public static final SmartDefaultHandler.Path P812_MSG_ID;
    public static final SmartDefaultHandler.Path P812_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P812_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P812_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P812_INITG_NM;
    public static final SmartDefaultHandler.Path P812_INITG_ID;
    public static final SmartDefaultHandler.Path P812_PMT_INF;
    public static final SmartDefaultHandler.Path P812_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P812_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P812_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P812_SVC_LVL;
    public static final SmartDefaultHandler.Path P812_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P812_PMT_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P812_CDTR_NM;
    public static final SmartDefaultHandler.Path P812_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P812_CDTR_BIC;
    public static final SmartDefaultHandler.Path P812_CDTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P812_ULTMT_CDTR_ID;
    public static final SmartDefaultHandler.Path P812_DRCT_DBT_TX_INF;
    public static final SmartDefaultHandler.Path P812_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P812_TX_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P812_INSTD_AMT;
    public static final SmartDefaultHandler.Path P832_MSG_ID;
    public static final SmartDefaultHandler.Path P832_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P832_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P832_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P832_INITG_NM;
    public static final SmartDefaultHandler.Path P832_INITG_ID;
    public static final SmartDefaultHandler.Path P832_PMT_INF;
    public static final SmartDefaultHandler.Path P832_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P832_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P832_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P832_SVC_LVL;
    public static final SmartDefaultHandler.Path P832_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P832_PMT_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P832_CDTR_NM;
    public static final SmartDefaultHandler.Path P832_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P832_CDTR_BIC;
    public static final SmartDefaultHandler.Path P832_CDTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P832_ULTMT_CDTR_ID;
    public static final SmartDefaultHandler.Path P832_INSTD_AMT;
    public static final SmartDefaultHandler.Path P822_MSG_ID;
    public static final SmartDefaultHandler.Path P822_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P822_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P822_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P822_INITG_NM;
    public static final SmartDefaultHandler.Path P822_INITG_ID;
    public static final SmartDefaultHandler.Path P822_PMT_INF;
    public static final SmartDefaultHandler.Path P822_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P822_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P822_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P822_SVC_LVL;
    public static final SmartDefaultHandler.Path P822_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P822_PMT_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P822_CDTR_NM;
    public static final SmartDefaultHandler.Path P822_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P822_CDTR_BIC;
    public static final SmartDefaultHandler.Path P822_CDTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P822_ULTMT_CDTR_ID;
    public static final SmartDefaultHandler.Path P822_INSTD_AMT;
    public static final SmartDefaultHandler.Path P821_MSG_ID;
    public static final SmartDefaultHandler.Path P821_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P821_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P821_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P821_INITG_NM;
    public static final SmartDefaultHandler.Path P821_PMT_INF;
    public static final SmartDefaultHandler.Path P821_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P821_SVC_LVL;
    public static final SmartDefaultHandler.Path P821_LCL_INSTRM;
    public static final SmartDefaultHandler.Path P821_PMT_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P821_CDTR_NM;
    public static final SmartDefaultHandler.Path P821_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P821_CDTR_BIC;
    public static final SmartDefaultHandler.Path P821_CDTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P821_INSTD_AMT;
    private boolean bundesbank;
    protected CDxTicket ticket;
    private CDxSingleTicket currentTicket;
    private boolean dk39 = true;
    private boolean dk37 = true;
    private boolean dk31 = true;
    private boolean dk30 = true;
    private boolean dk27 = true;
    private boolean dk25 = true;
    private boolean dk24 = true;
    private Integer pmtNbOfTxs;
    private long hdrNbOfTxs;
    private BigDecimal hdrCtrlSum;
    private BigDecimal pmtCtrlSum;
    protected boolean pmtSvcLvlSeen = false;
    protected boolean txSvcLvlSeen = false;
    private String namespace;

    public void setValidateScheme(boolean validateScheme) {
        this.dk37 = this.dk39 = validateScheme;
        this.dk31 = this.dk39;
        this.dk30 = this.dk39;
        this.dk27 = this.dk39;
        this.dk25 = this.dk39;
        this.dk24 = this.dk39;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.ticket = this.mkTicket();
        this.currentTicket = null;
        this.hdrNbOfTxs = 0L;
        this.hdrCtrlSum = null;
        this.pmtSvcLvlSeen = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.ticket.getTotalNumberOfPayments() != this.hdrNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.ticket.getTotalNumberOfPayments() + ")", this.locator));
        }
        if (this.hdrCtrlSum != null && this.hdrCtrlSum.compareTo(this.ticket.getTotalAmount()) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.ticket.getTotalAmount()) + ")", this.locator));
        }
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        StringBuilder sb = new StringBuilder();
        if (this.dk39) {
            CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.08", "/de/businesslogics/format/dk39/pain.008.001.08_GBIC_5.xsd");
        } else if (this.dk37) {
            CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.08", "/de/businesslogics/format/dk37/pain.008.001.08_GBIC_4.xsd");
        }
        if (this.dk30) {
            if (this.dk31) {
                CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02", "/de/businesslogics/format/sepa/containernnn00102/pain.008.001.02_GBIC_1and2.xsd");
            } else {
                CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02", "/de/businesslogics/format/sepa/containernnn00102/pain.008.001.02.xsd");
            }
        } else if (this.dk31) {
            CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02", "/de/businesslogics/format/dk31/pain.008.001.02_GBIC_2.xsd");
        }
        if (this.dk27) {
            CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.003.02", "/de/businesslogics/format/sepa/pain00800302/pain.008.003.02.xsd");
        }
        if (this.dk25) {
            CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.008.002.02", "/de/businesslogics/format/sepa/pain00800202/pain.008.002.02.xsd");
        }
        if (this.dk24) {
            CDxDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:swift:xsd:$pain.008.002.01", "/de/businesslogics/format/sepa/pain00800201/pain.008.002.01.xsd");
        }
        return CDxDisplayMessageGenerator.finishNamespaceSchemaLocations(sb);
    }

    @SmartDefaultHandler.Callback(value={"P812_MSG_ID", "P818_MSG_ID", "P832_MSG_ID", "P822_MSG_ID", "P821_MSG_ID"})
    public void setMsgId() {
        this.namespace = this.getPath().getUri();
        this.ticket.messageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_CRE_DT_TM", "P818_CRE_DT_TM", "P832_CRE_DT_TM", "P822_CRE_DT_TM", "P821_CRE_DT_TM"})
    public void setCreDtTm() throws SAXParseException {
        this.ticket.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P812_HDR_NB_OF_TXS", "P818_HDR_NB_OF_TXS", "P832_HDR_NB_OF_TXS", "P822_HDR_NB_OF_TXS", "P821_HDR_NB_OF_TXS"})
    public void setHdrNbOfTxs() throws SAXParseException {
        this.hdrNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P812_HDR_CTRL_SUM", "P818_HDR_CTRL_SUM", "P832_HDR_CTRL_SUM", "P822_HDR_CTRL_SUM", "P821_HDR_CTRL_SUM"})
    public void setHdrCtrlSum() throws SAXParseException {
        this.hdrCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P812_INITG_NM", "P818_INITG_NM", "P832_INITG_NM", "P822_INITG_NM", "P821_INITG_NM"})
    public void setInitiatorName() {
        this.ticket.initiatorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_INITG_ID", "P818_INITG_ID", "P832_INITG_ID", "P822_INITG_ID"})
    public void setInitiatorId() {
        this.ticket.initiatorId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_PMT_INF", "P818_PMT_INF", "P832_PMT_INF", "P822_PMT_INF", "P821_PMT_INF"})
    public void startPmtInf(Attributes attributes) {
        this.currentTicket = new CDxSingleTicket();
        this.ticket.singleTickets.add(this.currentTicket);
        this.pmtNbOfTxs = null;
        this.pmtCtrlSum = null;
    }

    @SmartDefaultHandler.Callback(value={"P812_PMT_INF", "P818_PMT_INF", "P832_PMT_INF", "P822_PMT_INF", "P821_PMT_INF"})
    public void endPmtInf() throws SAXException {
        if (this.pmtNbOfTxs != null && this.currentTicket.numberOfPayments != this.pmtNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.currentTicket.numberOfPayments + ")", this.locator));
        }
        if (this.pmtCtrlSum != null && this.pmtCtrlSum.compareTo(this.currentTicket.ctrlSum) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.currentTicket.ctrlSum) + ")", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P812_PMT_INF_ID", "P818_PMT_INF_ID", "P832_PMT_INF_ID", "P822_PMT_INF_ID", "P821_PMT_INF_ID"})
    public void setPmtInfId() {
        this.currentTicket.paymentInformationIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_PMT_NB_OF_TXS", "P818_PMT_NB_OF_TXS", "P832_PMT_NB_OF_TXS", "P822_PMT_NB_OF_TXS"})
    public void setPmtNbOfTxs() throws SAXParseException {
        this.pmtNbOfTxs = this.getInt();
    }

    @SmartDefaultHandler.Callback(value={"P812_PMT_CTRL_SUM", "P818_PMT_CTRL_SUM", "P832_PMT_CTRL_SUM", "P822_PMT_CTRL_SUM"})
    public void setPmtCtrlSum() throws SAXParseException {
        this.pmtCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P812_SVC_LVL", "P818_SVC_LVL", "P832_SVC_LVL", "P822_SVC_LVL", "P821_SVC_LVL"})
    public void setSvcLvl() throws SAXException {
        if (!"SEPA".equals(this.getString())) {
            this.error(new SvcLvlException("Service level must be SEPA", this.locator));
        }
        this.pmtSvcLvlSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P812_DRCT_DBT_TX_INF", "P818_DRCT_DBT_TX_INF"})
    public void startDrctDbtTxInf(Attributes attributes) {
        this.txSvcLvlSeen = this.pmtSvcLvlSeen;
    }

    @SmartDefaultHandler.Callback(value={"P812_TX_SVC_LVL", "P818_TX_SVC_LVL"})
    public void setTxSvcLvl() throws SAXException {
        if (!"SEPA".equals(this.getString())) {
            this.error(new SvcLvlException("Service level must be SEPA", this.locator));
        }
        this.txSvcLvlSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P812_DRCT_DBT_TX_INF", "P818_DRCT_DBT_TX_INF"})
    public void endDrctDbtTxInf() throws SAXException {
        if (!this.txSvcLvlSeen) {
            this.error(new SvcLvlException("Service level not defined. Service level must be SEPA", this.locator));
        }
        if (this.ticket.debitType == null) {
            this.error(new LclInstException("Multiple Local instruments were defined.", this.locator));
        }
        if (this.ticket.debitType.length() == 0) {
            this.error(new LclInstException("Local Instrument not defined", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P812_LCL_INSTRM", "P812_TX_LCL_INSTRM", "P818_LCL_INSTRM", "P818_TX_LCL_INSTRM", "P832_LCL_INSTRM", "P822_LCL_INSTRM", "P821_LCL_INSTRM"})
    public void handleLocalInstrument() {
        if (this.ticket.debitType != null) {
            String s = this.getString();
            if (this.ticket.debitType.length() == 0) {
                this.ticket.debitType = s;
            } else if (!s.equals(this.ticket.debitType)) {
                this.ticket.debitType = null;
            }
        }
    }

    @SmartDefaultHandler.Callback(value={"P812_PMT_REQD_COLLTN_DT", "P818_PMT_REQD_COLLTN_DT", "P832_PMT_REQD_COLLTN_DT", "P822_PMT_REQD_COLLTN_DT", "P821_PMT_REQD_COLLTN_DT"})
    public void setReqdColltnDt() throws SAXException {
        this.currentTicket.requestedCollectionDate = this.getDate();
    }

    @SmartDefaultHandler.Callback(value={"P812_CDTR_NM", "P818_CDTR_NM", "P832_CDTR_NM", "P822_CDTR_NM", "P821_CDTR_NM"})
    public void setCdtrNm() {
        this.currentTicket.creditorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_CDTR_IBAN", "P818_CDTR_IBAN", "P832_CDTR_IBAN", "P822_CDTR_IBAN", "P821_CDTR_IBAN"})
    public void setCdtrIban() {
        this.currentTicket.creditorAccount = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_CDTR_ACCT_CCY", "P818_CDTR_ACCT_CCY", "P832_CDTR_ACCT_CCY", "P822_CDTR_ACCT_CCY", "P821_CDTR_ACCT_CCY"})
    public void setCdtrAcctCcy() {
        this.currentTicket.creditorAccountCcy = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_CDTR_BIC", "P818_CDTR_BIC", "P832_CDTR_BIC", "P822_CDTR_BIC", "P821_CDTR_BIC"})
    public void setCdtrBic() {
        this.currentTicket.creditorBIC = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P812_ULTMT_CDTR_ID", "P818_ULTMT_CDTR_ID", "P832_ULTMT_CDTR_ID", "P822_ULTMT_CDTR_ID"})
    public void setAlternativeIban() {
        if (this.bundesbank) {
            this.currentTicket.creditorBIC = null;
            this.currentTicket.creditorAccount = this.getString();
        }
    }

    @SmartDefaultHandler.Callback(value={"P812_INSTD_AMT", "P818_INSTD_AMT", "P832_INSTD_AMT", "P822_INSTD_AMT", "P821_INSTD_AMT"})
    public void startInstdAmt(Attributes attributes) throws SAXException {
        String ccy = attributes.getValue("Ccy");
        if (ccy != null && !"EUR".equals(ccy)) {
            this.error(new CcyException("Wrong currency " + ccy + " in Instructed Amount. Only EUR is allowed.", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P812_INSTD_AMT", "P818_INSTD_AMT", "P832_INSTD_AMT", "P822_INSTD_AMT", "P821_INSTD_AMT"})
    public void handleAmount() throws SAXParseException {
        this.currentTicket.ctrlSum = this.currentTicket.ctrlSum.add(this.getDecimal());
        ++this.currentTicket.numberOfPayments;
    }

    @Override
    public DisplayMessage getMessage(InputStream in) throws IOException, SAXException {
        this.parse(in);
        return this.ticket;
    }

    public CDxTicket getMessage() {
        return this.ticket;
    }

    public void setBundesbank(boolean b) {
        this.bundesbank = b;
    }

    public void setNoSchema() {
        this.dk24 = false;
        this.dk25 = false;
        this.dk27 = false;
        this.dk30 = false;
        this.dk31 = false;
        this.dk37 = false;
        this.dk39 = false;
    }

    protected CDxTicket mkTicket() {
        return new CDxTicket();
    }

    public boolean isDk39() {
        return this.dk39;
    }

    public void setDk39(boolean dk39) {
        this.dk39 = dk39;
    }

    public boolean isDk37() {
        return this.dk37;
    }

    public void setDk37(boolean dk37) {
        this.dk37 = dk37;
    }

    public boolean isDk31() {
        return this.dk31;
    }

    public void setDk31(boolean dk31) {
        this.dk31 = dk31;
    }

    public boolean isDk30() {
        return this.dk30;
    }

    public void setDk30(boolean dk30) {
        this.dk30 = dk30;
    }

    public boolean isDk27() {
        return this.dk27;
    }

    public void setDk27(boolean dk27) {
        this.dk27 = dk27;
    }

    public boolean isDk25() {
        return this.dk25;
    }

    public void setDk25(boolean dk25) {
        this.dk25 = dk25;
    }

    public boolean isDk24() {
        return this.dk24;
    }

    public void setDk24(boolean dk24) {
        this.dk24 = dk24;
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.08", "Document");
        SmartDefaultHandler.Path cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrDrctDbtInitn");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P818_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P818_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P818_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P818_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        SmartDefaultHandler.Path initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P818_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(initgPty, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P818_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P818_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P818_PMT_INF_ID = new SmartDefaultHandler.Path(P818_PMT_INF, "PmtInfId");
        P818_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P818_PMT_INF, "NbOfTxs");
        P818_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P818_PMT_INF, "CtrlSum");
        SmartDefaultHandler.Path pmtTpInf = new SmartDefaultHandler.Path(P818_PMT_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P818_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        SmartDefaultHandler.Path lclInstrm = new SmartDefaultHandler.Path(pmtTpInf, "LclInstrm");
        P818_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P818_PMT_REQD_COLLTN_DT = new SmartDefaultHandler.Path(P818_PMT_INF, "ReqdColltnDt");
        SmartDefaultHandler.Path cdtr = new SmartDefaultHandler.Path(P818_PMT_INF, "Cdtr");
        P818_CDTR_NM = new SmartDefaultHandler.Path(cdtr, "Nm");
        SmartDefaultHandler.Path cdtrAcct = new SmartDefaultHandler.Path(P818_PMT_INF, "CdtrAcct");
        SmartDefaultHandler.Path id2 = new SmartDefaultHandler.Path(cdtrAcct, "Id");
        P818_CDTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        P818_CDTR_ACCT_CCY = new SmartDefaultHandler.Path(cdtrAcct, "Ccy");
        SmartDefaultHandler.Path cdtrAgt = new SmartDefaultHandler.Path(P818_PMT_INF, "CdtrAgt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(cdtrAgt, "FinInstnId");
        P818_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        SmartDefaultHandler.Path ultmtCdtr = new SmartDefaultHandler.Path(P818_PMT_INF, "UltmtCdtr");
        SmartDefaultHandler.Path id3 = new SmartDefaultHandler.Path(ultmtCdtr, "Id");
        SmartDefaultHandler.Path orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        SmartDefaultHandler.Path othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        P818_ULTMT_CDTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        P818_DRCT_DBT_TX_INF = new SmartDefaultHandler.Path(P818_PMT_INF, "DrctDbtTxInf");
        SmartDefaultHandler.Path pmtTpInf2 = new SmartDefaultHandler.Path(P818_DRCT_DBT_TX_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl2 = new SmartDefaultHandler.Path(pmtTpInf2, "SvcLvl");
        P818_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        SmartDefaultHandler.Path lclInstrm2 = new SmartDefaultHandler.Path(pmtTpInf2, "LclInstrm");
        P818_TX_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm2, "Cd");
        P818_INSTD_AMT = new SmartDefaultHandler.Path(P818_DRCT_DBT_TX_INF, "InstdAmt");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02", "Document");
        cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrDrctDbtInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P812_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P812_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P812_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P812_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P812_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P812_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P812_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P812_PMT_INF_ID = new SmartDefaultHandler.Path(P812_PMT_INF, "PmtInfId");
        P812_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P812_PMT_INF, "NbOfTxs");
        P812_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P812_PMT_INF, "CtrlSum");
        pmtTpInf = new SmartDefaultHandler.Path(P812_PMT_INF, "PmtTpInf");
        svcLvl = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P812_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(pmtTpInf, "LclInstrm");
        P812_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P812_PMT_REQD_COLLTN_DT = new SmartDefaultHandler.Path(P812_PMT_INF, "ReqdColltnDt");
        cdtr = new SmartDefaultHandler.Path(P812_PMT_INF, "Cdtr");
        P812_CDTR_NM = new SmartDefaultHandler.Path(cdtr, "Nm");
        cdtrAcct = new SmartDefaultHandler.Path(P812_PMT_INF, "CdtrAcct");
        id2 = new SmartDefaultHandler.Path(cdtrAcct, "Id");
        P812_CDTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        P812_CDTR_ACCT_CCY = new SmartDefaultHandler.Path(cdtrAcct, "Ccy");
        cdtrAgt = new SmartDefaultHandler.Path(P812_PMT_INF, "CdtrAgt");
        finInstnId = new SmartDefaultHandler.Path(cdtrAgt, "FinInstnId");
        P812_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId, "BIC");
        ultmtCdtr = new SmartDefaultHandler.Path(P812_PMT_INF, "UltmtCdtr");
        id3 = new SmartDefaultHandler.Path(ultmtCdtr, "Id");
        orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        P812_ULTMT_CDTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        P812_DRCT_DBT_TX_INF = new SmartDefaultHandler.Path(P812_PMT_INF, "DrctDbtTxInf");
        pmtTpInf2 = new SmartDefaultHandler.Path(P812_DRCT_DBT_TX_INF, "PmtTpInf");
        svcLvl2 = new SmartDefaultHandler.Path(pmtTpInf2, "SvcLvl");
        P812_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        lclInstrm2 = new SmartDefaultHandler.Path(pmtTpInf2, "LclInstrm");
        P812_TX_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm2, "Cd");
        P812_INSTD_AMT = new SmartDefaultHandler.Path(P812_DRCT_DBT_TX_INF, "InstdAmt");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.008.003.02", "Document");
        cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrDrctDbtInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P832_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P832_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P832_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P832_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P832_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P832_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P832_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P832_PMT_INF_ID = new SmartDefaultHandler.Path(P832_PMT_INF, "PmtInfId");
        P832_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P832_PMT_INF, "NbOfTxs");
        P832_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P832_PMT_INF, "CtrlSum");
        pmtTpInf = new SmartDefaultHandler.Path(P832_PMT_INF, "PmtTpInf");
        svcLvl = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P832_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(pmtTpInf, "LclInstrm");
        P832_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P832_PMT_REQD_COLLTN_DT = new SmartDefaultHandler.Path(P832_PMT_INF, "ReqdColltnDt");
        SmartDefaultHandler.Path cdtr2 = new SmartDefaultHandler.Path(P832_PMT_INF, "Cdtr");
        P832_CDTR_NM = new SmartDefaultHandler.Path(cdtr2, "Nm");
        SmartDefaultHandler.Path cdtrAcct2 = new SmartDefaultHandler.Path(P832_PMT_INF, "CdtrAcct");
        SmartDefaultHandler.Path id4 = new SmartDefaultHandler.Path(cdtrAcct2, "Id");
        P832_CDTR_IBAN = new SmartDefaultHandler.Path(id4, "IBAN");
        P832_CDTR_ACCT_CCY = new SmartDefaultHandler.Path(cdtrAcct2, "Ccy");
        SmartDefaultHandler.Path cdtrAgt2 = new SmartDefaultHandler.Path(P832_PMT_INF, "CdtrAgt");
        SmartDefaultHandler.Path finInstnId2 = new SmartDefaultHandler.Path(cdtrAgt2, "FinInstnId");
        P832_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId2, "BIC");
        SmartDefaultHandler.Path ultmtCdtr2 = new SmartDefaultHandler.Path(P832_PMT_INF, "UltmtCdtr");
        SmartDefaultHandler.Path id5 = new SmartDefaultHandler.Path(ultmtCdtr2, "Id");
        SmartDefaultHandler.Path orgId3 = new SmartDefaultHandler.Path(id5, "OrgId");
        SmartDefaultHandler.Path othr3 = new SmartDefaultHandler.Path(orgId3, "Othr");
        P832_ULTMT_CDTR_ID = new SmartDefaultHandler.Path(othr3, "Id");
        SmartDefaultHandler.Path drctDbtTxInf = new SmartDefaultHandler.Path(P832_PMT_INF, "DrctDbtTxInf");
        P832_INSTD_AMT = new SmartDefaultHandler.Path(drctDbtTxInf, "InstdAmt");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.008.002.02", "Document");
        SmartDefaultHandler.Path cstmrDrctDbtInitn = new SmartDefaultHandler.Path(document, "CstmrDrctDbtInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrDrctDbtInitn, "GrpHdr");
        P822_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P822_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P822_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P822_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P822_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P822_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P822_PMT_INF = new SmartDefaultHandler.Path(cstmrDrctDbtInitn, "PmtInf");
        P822_PMT_INF_ID = new SmartDefaultHandler.Path(P822_PMT_INF, "PmtInfId");
        P822_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P822_PMT_INF, "NbOfTxs");
        P822_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P822_PMT_INF, "CtrlSum");
        pmtTpInf = new SmartDefaultHandler.Path(P822_PMT_INF, "PmtTpInf");
        svcLvl = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P822_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(pmtTpInf, "LclInstrm");
        P822_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P822_PMT_REQD_COLLTN_DT = new SmartDefaultHandler.Path(P822_PMT_INF, "ReqdColltnDt");
        cdtr2 = new SmartDefaultHandler.Path(P822_PMT_INF, "Cdtr");
        P822_CDTR_NM = new SmartDefaultHandler.Path(cdtr2, "Nm");
        cdtrAcct2 = new SmartDefaultHandler.Path(P822_PMT_INF, "CdtrAcct");
        id4 = new SmartDefaultHandler.Path(cdtrAcct2, "Id");
        P822_CDTR_IBAN = new SmartDefaultHandler.Path(id4, "IBAN");
        P822_CDTR_ACCT_CCY = new SmartDefaultHandler.Path(cdtrAcct2, "Ccy");
        cdtrAgt2 = new SmartDefaultHandler.Path(P822_PMT_INF, "CdtrAgt");
        finInstnId2 = new SmartDefaultHandler.Path(cdtrAgt2, "FinInstnId");
        P822_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId2, "BIC");
        ultmtCdtr2 = new SmartDefaultHandler.Path(P822_PMT_INF, "UltmtCdtr");
        id5 = new SmartDefaultHandler.Path(ultmtCdtr2, "Id");
        orgId3 = new SmartDefaultHandler.Path(id5, "OrgId");
        othr3 = new SmartDefaultHandler.Path(orgId3, "Othr");
        P822_ULTMT_CDTR_ID = new SmartDefaultHandler.Path(othr3, "Id");
        drctDbtTxInf = new SmartDefaultHandler.Path(P822_PMT_INF, "DrctDbtTxInf");
        P822_INSTD_AMT = new SmartDefaultHandler.Path(drctDbtTxInf, "InstdAmt");
        document = new SmartDefaultHandler.Path(null, "urn:swift:xsd:$pain.008.002.01", "Document");
        SmartDefaultHandler.Path pain00800101 = new SmartDefaultHandler.Path(document, "pain.008.001.01");
        grpHdr = new SmartDefaultHandler.Path(pain00800101, "GrpHdr");
        P821_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P821_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P821_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P821_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P821_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        P821_PMT_INF = new SmartDefaultHandler.Path(pain00800101, "PmtInf");
        P821_PMT_INF_ID = new SmartDefaultHandler.Path(P821_PMT_INF, "PmtInfId");
        pmtTpInf = new SmartDefaultHandler.Path(P821_PMT_INF, "PmtTpInf");
        svcLvl = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P821_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        lclInstrm = new SmartDefaultHandler.Path(pmtTpInf, "LclInstrm");
        P821_LCL_INSTRM = new SmartDefaultHandler.Path(lclInstrm, "Cd");
        P821_PMT_REQD_COLLTN_DT = new SmartDefaultHandler.Path(P821_PMT_INF, "ReqdColltnDt");
        cdtr2 = new SmartDefaultHandler.Path(P821_PMT_INF, "Cdtr");
        P821_CDTR_NM = new SmartDefaultHandler.Path(cdtr2, "Nm");
        cdtrAcct2 = new SmartDefaultHandler.Path(P821_PMT_INF, "CdtrAcct");
        id4 = new SmartDefaultHandler.Path(cdtrAcct2, "Id");
        P821_CDTR_IBAN = new SmartDefaultHandler.Path(id4, "IBAN");
        P821_CDTR_ACCT_CCY = new SmartDefaultHandler.Path(cdtrAcct2, "Ccy");
        cdtrAgt2 = new SmartDefaultHandler.Path(P821_PMT_INF, "CdtrAgt");
        finInstnId2 = new SmartDefaultHandler.Path(cdtrAgt2, "FinInstnId");
        P821_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId2, "BIC");
        SmartDefaultHandler.Path drctDbtTxInf2 = new SmartDefaultHandler.Path(P821_PMT_INF, "DrctDbtTxInf");
        P821_INSTD_AMT = new SmartDefaultHandler.Path(drctDbtTxInf2, "InstdAmt");
    }
}

