/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.ebics.schema.SignatureContentHandler;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.CDxContainerSingleTicket;
import de.businesslogics.format.ticket.CDxContainerTicket;
import de.businesslogics.format.ticket.CDxDisplayMessageGenerator;
import de.businesslogics.format.ticket.CDxTicket;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.HashHolder;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.xml.OutputSAXParser;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CDxContainerDisplayMessageGenerator
extends SignatureContentHandler
implements DisplayMessageGenerator {
    private static final HashSet<String> DOCUMENT_URIS = new HashSet();
    protected final CDxSP handler;
    private boolean checkDigest = true;

    public CDxContainerDisplayMessageGenerator() {
        this(new CDxSP(new CDxSingleTicketGenerator()));
    }

    protected CDxContainerDisplayMessageGenerator(CDxSP handler) {
        this.handler = handler;
        super.setNextHandler(handler);
    }

    public boolean isCheckDigest() {
        return this.checkDigest;
    }

    public void setCheckDigest(boolean checkDigest) {
        this.checkDigest = checkDigest;
    }

    public boolean isDk39() {
        return this.handler.sub.isDk39();
    }

    public void setDk39(boolean dk39) {
        this.handler.sub.setDk39(dk39);
    }

    public boolean isDk37() {
        return this.handler.sub.isDk37();
    }

    public void setDk37(boolean dk37) {
        this.handler.sub.setDk37(dk37);
    }

    public boolean isDk36() {
        return this.handler.dk36;
    }

    public void setDk36(boolean dk36) {
        this.handler.dk36 = dk36;
    }

    public boolean isDk31() {
        return this.handler.sub.isDk31();
    }

    public void setDk31(boolean dk31) {
        this.handler.sub.setDk31(dk31);
    }

    public boolean isDk30() {
        return this.handler.sub.isDk30();
    }

    public void setDk30(boolean dk30) {
        this.handler.sub.setDk30(dk30);
    }

    public boolean isDk27() {
        return this.handler.sub.isDk27();
    }

    public void setDk27(boolean dk27) {
        this.handler.sub.setDk27(dk27);
    }

    public boolean isDk25() {
        return this.handler.sub.isDk25();
    }

    public void setDk25(boolean dk25) {
        this.handler.sub.setDk25(dk25);
    }

    public boolean isDk24() {
        return this.handler.sub.isDk24();
    }

    public void setDk24(boolean dk24) {
        this.handler.sub.setDk24(dk24);
    }

    public void setValidateScheme(boolean validateScheme) {
        this.setDk24(validateScheme);
        this.setDk25(validateScheme);
        this.setDk27(validateScheme);
        this.setDk30(validateScheme);
        this.setDk31(validateScheme);
        this.setDk36(validateScheme);
        this.setDk37(validateScheme);
        this.setDk39(validateScheme);
    }

    public String getDocumentNamespace() {
        return this.handler.documentNamespace;
    }

    @Override
    protected boolean startDigest(String namespaceURI, String localName, String qName, Attributes atts) {
        return ((HashHolder)((Object)this.handler.sub)).getGivenHash() != null && "Document".equals(localName) && this.isDocumentUri(namespaceURI);
    }

    protected boolean isDocumentUri(String namespaceURI) {
        return DOCUMENT_URIS.contains(namespaceURI);
    }

    @Override
    protected void endDigest() throws SAXException {
        try {
            this.w.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.w = null;
        byte[] d = this.digest.digest();
        if (this.checkDigest && !Arrays.equals(((HashHolder)((Object)this.handler.sub)).getGivenHash(), d)) {
            throw new SAXException("Expected hash " + HexTool.toHex(d) + ", found " + HexTool.toHex(((HashHolder)((Object)this.handler.sub)).getGivenHash()));
        }
    }

    @Override
    public DisplayMessage getMessage(InputStream in) throws Exception {
        int i;
        OutputSAXParser op = this.handler.getOutputSAXParser(this);
        byte[] buffer = new byte[4096];
        while ((i = in.read(buffer)) > 0) {
            op.write(buffer, 0, i);
        }
        op.close();
        return this.handler.ticket;
    }

    public CDxContainerTicket getMessage() {
        return this.handler.ticket;
    }

    public OutputSAXParser getOutputSAXParser() throws IOException, SAXException {
        return this.handler.getOutputSAXParser(this);
    }

    public static class CDxSP
    extends SmartDefaultHandler {
        public static final SmartDefaultHandler.Path C15_MSG8;
        public static final SmartDefaultHandler.Path C15_MSG8_HASH;
        public static final SmartDefaultHandler.Path P818_5_DOCUMENT;
        public static final SmartDefaultHandler.Path C14_MSG8;
        public static final SmartDefaultHandler.Path C14_MSG8_HASH;
        public static final SmartDefaultHandler.Path P818_DOCUMENT;
        public static final SmartDefaultHandler.Path C13_MSG8;
        public static final SmartDefaultHandler.Path C13_MSG8_HASH;
        public static final SmartDefaultHandler.Path P812_36_DOCUMENT;
        public static final SmartDefaultHandler.Path C12_MSG8;
        public static final SmartDefaultHandler.Path C12_MSG8_HASH;
        public static final SmartDefaultHandler.Path P812_DOCUMENT;
        public static final SmartDefaultHandler.Path C32_MSG8;
        public static final SmartDefaultHandler.Path C32_MSG8_HASH;
        public static final SmartDefaultHandler.Path P832_DOCUMENT;
        public static final SmartDefaultHandler.Path C22_MSG8;
        public static final SmartDefaultHandler.Path C22_MSG8_HASH;
        public static final SmartDefaultHandler.Path P822_DOCUMENT;
        public static final SmartDefaultHandler.Path C2_MSG8;
        public static final SmartDefaultHandler.Path C2_MSG8_HASH;
        public static final SmartDefaultHandler.Path P821_DOCUMENT;
        protected final CDxDisplayMessageGenerator sub;
        public CDxContainerTicket ticket;
        private String documentNamespace;
        private boolean dk36 = true;

        protected CDxSP(CDxDisplayMessageGenerator sub) {
            this.sub = sub;
        }

        @Override
        protected String getNamespaceSchemaLocations() {
            String s;
            if (this.dk36) {
                this.sub.setDk31(true);
            }
            if ((s = this.sub.getNamespaceSchemaLocations()) == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(s);
            if (this.sub.isDk39()) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.GBIC5", "/de/businesslogics/format/dk39/container.nnn.001.GBIC5.sdd.xsd");
            }
            if (this.sub.isDk37()) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.GBIC4", "/de/businesslogics/format/ticket/container.nnn.001.GBIC4.sdd.xsd");
            }
            if (this.dk36) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.03", "/de/businesslogics/format/ticket/container.nnn.001.03.sdd.xsd");
            }
            if (this.sub.isDk30() || this.sub.isDk31()) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.02", "/de/businesslogics/format/ticket/container.nnn.001.02.sdd.xsd");
            }
            if (this.sub.isDk27()) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.003.02", "/de/businesslogics/format/ticket/container.nnn.003.02.sdd.xsd");
            }
            if (this.sub.isDk25()) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.002.02", "/de/businesslogics/format/ticket/container.nnn.002.02.sdd.xsd");
            }
            if (this.sub.isDk24()) {
                CDxSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.002", "/de/businesslogics/format/ticket/container.nnn.002.sdd.xsd");
            }
            return CDxSP.finishNamespaceSchemaLocations(sb);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.ticket = new CDxContainerTicket();
        }

        @SmartDefaultHandler.Callback(value={"C12_MSG8_HASH", "C13_MSG8_HASH", "C14_MSG8_HASH", "C15_MSG8_HASH", "C32_MSG8_HASH", "C22_MSG8_HASH", "C2_MSG8_HASH"})
        public void setGivenHash() throws SAXParseException {
            CDxSP.setGivenHash((HashHolder)((Object)this.sub), this.getString(), this.locator);
        }

        @SmartDefaultHandler.Callback(value={"P812_DOCUMENT", "P812_36_DOCUMENT", "P818_DOCUMENT", "P818_5_DOCUMENT", "P832_DOCUMENT", "P822_DOCUMENT", "P821_DOCUMENT"})
        public SmartDefaultHandler startPainDocument(Attributes atts) {
            this.documentNamespace = this.getPath().getUri();
            return this.sub;
        }

        @SmartDefaultHandler.Callback(value={"P812_DOCUMENT", "P818_DOCUMENT", "P818_5_DOCUMENT", "P812_36_DOCUMENT", "P832_DOCUMENT", "P822_DOCUMENT", "P821_DOCUMENT"})
        public void endPainDocument() {
            this.ticket.getSingleTickets().add((CDxContainerSingleTicket)this.sub.getMessage());
        }

        @SmartDefaultHandler.Callback(value={"C12_MSG8", "C13_MSG8", "C14_MSG8", "C15_MSG8", "C32_MSG8", "C22_MSG8", "C2_MSG8"})
        public void endMsg008() {
            ((HashHolder)((Object)this.sub)).setGivenHash(null);
        }

        static {
            SmartDefaultHandler.Path p818Document = CDxDisplayMessageGenerator.P818_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p818Document.getUri());
            SmartDefaultHandler.Path conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.GBIC5", "conxml");
            C15_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C15_MSG8_HASH = new SmartDefaultHandler.Path(C15_MSG8, "HashValue");
            P818_5_DOCUMENT = p818Document.prefixPath(C15_MSG8);
            p818Document = CDxDisplayMessageGenerator.P818_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p818Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.GBIC4", "conxml");
            C14_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C14_MSG8_HASH = new SmartDefaultHandler.Path(C14_MSG8, "HashValue");
            P818_DOCUMENT = p818Document.prefixPath(C14_MSG8);
            SmartDefaultHandler.Path p812Document = CDxDisplayMessageGenerator.P812_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p812Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.03", "conxml");
            C13_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C13_MSG8_HASH = new SmartDefaultHandler.Path(C13_MSG8, "HashValue");
            P812_36_DOCUMENT = p812Document.prefixPath(C13_MSG8);
            p812Document = CDxDisplayMessageGenerator.P812_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p812Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.02", "conxml");
            C12_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C12_MSG8_HASH = new SmartDefaultHandler.Path(C12_MSG8, "HashValue");
            P812_DOCUMENT = p812Document.prefixPath(C12_MSG8);
            SmartDefaultHandler.Path p832Document = CDxDisplayMessageGenerator.P832_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p832Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.003.02", "conxml");
            C32_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C32_MSG8_HASH = new SmartDefaultHandler.Path(C32_MSG8, "HashValue");
            P832_DOCUMENT = p832Document.prefixPath(C32_MSG8);
            SmartDefaultHandler.Path p822Document = CDxDisplayMessageGenerator.P822_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p822Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.002.02", "conxml");
            C22_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C22_MSG8_HASH = new SmartDefaultHandler.Path(C22_MSG8, "HashValue");
            P822_DOCUMENT = p822Document.prefixPath(C22_MSG8);
            SmartDefaultHandler.Path p821Document = CDxDisplayMessageGenerator.P821_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p821Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.002", "conxml");
            C2_MSG8 = new SmartDefaultHandler.Path(conxml, "MsgPain008");
            C2_MSG8_HASH = new SmartDefaultHandler.Path(C2_MSG8, "HashValue");
            P821_DOCUMENT = p821Document.prefixPath(C2_MSG8);
        }
    }

    public static class CDxSingleTicketGenerator
    extends CDxDisplayMessageGenerator
    implements HashHolder {
        byte[] givenHash;

        @Override
        protected CDxTicket mkTicket() {
            return new CDxContainerSingleTicket(this.givenHash);
        }

        @Override
        public byte[] getGivenHash() {
            return this.givenHash;
        }

        @Override
        public void setGivenHash(byte[] givenHash) {
            this.givenHash = givenHash;
        }
    }
}

