/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.CCTSingleTicket;
import de.businesslogics.format.ticket.VOPResult;
import de.businesslogics.format.ticket.VOPResultHolder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CCTTicket
extends AbstractDisplayMessage
implements VOPResultHolder {
    private static final long serialVersionUID = 1L;
    List<CCTSingleTicket> singleTickets = new ArrayList<CCTSingleTicket>();
    String messageIdentification;
    Date creationDateTime;
    String serviceLevel = "";
    String initiatorName;
    String initiatorId;
    private VOPResult vopResult;

    @Override
    public void setVopResult(VOPResult result) {
        this.vopResult = result;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    @Override
    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<CCTSingleTicket> getSingleTickets() {
        return this.singleTickets;
    }

    protected void append(AbstractDisplayMessage message) {
        message.mainSeparator();
        message.calculateKeyWidth("FILE_ID", "TIMESTAMP", "INITIATOR_NAME", "INITIATOR_ID");
        message.writeLine("URGP".equals(this.serviceLevel) ? "EIL_UEBERWEISUNGEN" : "CREDITS");
        message.writeKeyValue("FILE_ID", this.messageIdentification);
        message.writeDate("TIMESTAMP", "TIMESTAMP_FORMAT", this.creationDateTime);
        message.writeKeyValue("INITIATOR_NAME", this.initiatorName);
        message.writeKeyValue("INITIATOR_ID", this.initiatorId);
        if (Boolean.getBoolean("de.businesslogics.format.sepa.WithGroupTotal")) {
            message.calculateKeyWidth("TOTAL_AMOUNT", "TOTAL_ANZAHL");
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(this.locale));
            String amount = df.format(this.getTotalAmount());
            message.minorSeparator();
            message.writeKeyValue("TOTAL_ANZAHL", String.valueOf(this.getTotalNumberOfPayments()));
            message.writeKeyValue("TOTAL_AMOUNT", amount);
        }
        if (this.vopResult != null) {
            this.vopResult.append(message);
        }
        message.keyWidth = 0;
        for (CCTSingleTicket t : this.singleTickets) {
            if (message.keyWidth == 0) {
                t.calculateKeyWidth(message);
            }
            t.append(message);
        }
    }

    @Override
    public void append() {
        this.append(this);
        this.mainSeparator();
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (CCTSingleTicket t : this.singleTickets) {
            totalAmount = totalAmount.add(t.getCtrlSum());
        }
        return totalAmount;
    }

    @Override
    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (CCTSingleTicket t : this.singleTickets) {
            totalNumber += (long)t.getNumberOfPayments();
        }
        return totalNumber;
    }

    public String getServiceLevel() {
        return this.serviceLevel;
    }
}

