/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class CCTSingleTicket
implements Serializable {
    private static final long serialVersionUID = 1L;
    String paymentInformationIdentification;
    String debitorBIC;
    String debitorAccount;
    String debitorName;
    YYMMDD requestedExecutionDate;
    BigDecimal ctrlSum = BigDecimal.ZERO;
    int numberOfPayments = 0;
    transient String debitorAccountCcy;

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public String getDebitorAccount() {
        return this.debitorAccount;
    }

    @Deprecated
    public Currency getDebitorAccountCcy() {
        return this.debitorAccountCcy != null ? Currency.getInstance(this.debitorAccountCcy) : null;
    }

    public String getDebitorBIC() {
        return this.debitorBIC;
    }

    public String getDebitorName() {
        return this.debitorName;
    }

    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void calculateKeyWidth(AbstractDisplayMessage message) {
        message.calculateKeyWidth("PMT_INF_ID", "BANK_CODE", "ACCOUNT_NUMBER", "ORIGINATOR2", "ANZAHL_DER_ZAHLUNGSSAETZE", "CTRL_SUM_EUR", "EXECUTION_DATE");
    }

    public void append(AbstractDisplayMessage message) {
        message.minorSeparator();
        message.writeKeyValue("PMT_INF_ID", this.paymentInformationIdentification);
        message.writeKeyValue("BANK_CODE", this.debitorBIC);
        message.writeKeyValue("ACCOUNT_NUMBER", this.debitorAccount);
        message.writeKeyValue("ORIGINATOR2", this.debitorName);
        message.writeKeyValue("ANZAHL_DER_ZAHLUNGSSAETZE", Integer.toString(this.numberOfPayments));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(message.locale));
        message.writeKeyValue("CTRL_SUM_EUR", df.format(this.ctrlSum));
        message.writeDate("EXECUTION_DATE", "DATE_FORMAT", this.requestedExecutionDate);
    }

    public String getPaymentInformationIdentification() {
        return this.paymentInformationIdentification;
    }

    public YYMMDD getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }
}

