/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bankrechner.SystemProperties;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.CCTSingleTicket;
import de.businesslogics.format.ticket.CCTTicket;
import de.businesslogics.format.ticket.CcyException;
import de.businesslogics.format.ticket.CtrlSumException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.MltplPmtTpInfException;
import de.businesslogics.format.ticket.NbOfTxsException;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CCTDisplayMessageGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final int DK37_DISABLED = 0;
    public static final int DK37_CCT_CIP = 1;
    public static final int DK37_CCU = 2;
    public static final int DK37_ALL = 3;
    public static final SmartDefaultHandler.Path P119_MSG_ID;
    public static final SmartDefaultHandler.Path P119_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P119_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P119_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P119_INITG_NM;
    public static final SmartDefaultHandler.Path P119_INITG_ID;
    public static final SmartDefaultHandler.Path P119_PMT_INF;
    public static final SmartDefaultHandler.Path P119_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P119_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P119_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P119_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P119_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P119_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P119_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P119_PMT_REQD_EXCTN_DT_TM;
    public static final SmartDefaultHandler.Path P119_DBTR_NM;
    public static final SmartDefaultHandler.Path P119_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P119_DBTR_BICFI;
    public static final SmartDefaultHandler.Path P119_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P119_ULTMT_DBTR_ID;
    public static final SmartDefaultHandler.Path P119_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P119_TX_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P119_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P119_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P119_INSTD_AMT;
    public static final SmartDefaultHandler.Path P119_PURP;
    public static final SmartDefaultHandler.Path P113_MSG_ID;
    public static final SmartDefaultHandler.Path P113_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P113_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P113_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P113_INITG_NM;
    public static final SmartDefaultHandler.Path P113_INITG_ID;
    public static final SmartDefaultHandler.Path P113_PMT_INF;
    public static final SmartDefaultHandler.Path P113_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P113_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P113_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P113_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P113_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P113_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P113_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P113_DBTR_NM;
    public static final SmartDefaultHandler.Path P113_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P113_DBTR_BIC;
    public static final SmartDefaultHandler.Path P113_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P113_ULTMT_DBTR_ID;
    public static final SmartDefaultHandler.Path P113_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P113_TX_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P113_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P113_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P113_INSTD_AMT;
    public static final SmartDefaultHandler.Path P113_PURP;
    public static final SmartDefaultHandler.Path P133_MSG_ID;
    public static final SmartDefaultHandler.Path P133_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P133_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P133_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P133_INITG_NM;
    public static final SmartDefaultHandler.Path P133_INITG_ID;
    public static final SmartDefaultHandler.Path P133_PMT_INF;
    public static final SmartDefaultHandler.Path P133_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P133_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P133_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P133_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P133_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P133_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P133_DBTR_NM;
    public static final SmartDefaultHandler.Path P133_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P133_DBTR_BIC;
    public static final SmartDefaultHandler.Path P133_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P133_ULTMT_DBTR_ID;
    public static final SmartDefaultHandler.Path P133_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P133_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P133_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P133_INSTD_AMT;
    public static final SmartDefaultHandler.Path P133_PURP;
    public static final SmartDefaultHandler.Path P123_MSG_ID;
    public static final SmartDefaultHandler.Path P123_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P123_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P123_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P123_INITG_NM;
    public static final SmartDefaultHandler.Path P123_INITG_ID;
    public static final SmartDefaultHandler.Path P123_PMT_INF;
    public static final SmartDefaultHandler.Path P123_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P123_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P123_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P123_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P123_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P123_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P123_DBTR_NM;
    public static final SmartDefaultHandler.Path P123_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P123_DBTR_BIC;
    public static final SmartDefaultHandler.Path P123_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P123_ULTMT_DBTR_ID;
    public static final SmartDefaultHandler.Path P123_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P123_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P123_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P123_INSTD_AMT;
    public static final SmartDefaultHandler.Path P123_PURP;
    public static final SmartDefaultHandler.Path P122_MSG_ID;
    public static final SmartDefaultHandler.Path P122_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P122_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P122_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P122_INITG_NM;
    public static final SmartDefaultHandler.Path P122_PMT_INF;
    public static final SmartDefaultHandler.Path P122_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P122_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P122_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P122_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P122_DBTR_NM;
    public static final SmartDefaultHandler.Path P122_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P122_DBTR_BIC;
    public static final SmartDefaultHandler.Path P122_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P122_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P122_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P122_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P122_INSTD_AMT;
    public static final SmartDefaultHandler.Path P122_PURP;
    public static final SmartDefaultHandler.Path P112_MSG_ID;
    public static final SmartDefaultHandler.Path P112_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P112_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P112_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P112_INITG_NM;
    public static final SmartDefaultHandler.Path P112_PMT_INF;
    public static final SmartDefaultHandler.Path P112_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P112_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P112_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P112_DBTR_NM;
    public static final SmartDefaultHandler.Path P112_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P112_DBTR_BIC;
    public static final SmartDefaultHandler.Path P112_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P112_INSTD_AMT;
    private static final HashSet<String> salariesCodes;
    private boolean bundesbank;
    private boolean salary;
    protected CCTTicket ticket;
    private CCTSingleTicket currentTicket;
    private Integer pmtNbOfTxs;
    private long hdrNbOfTxs;
    private BigDecimal hdrCtrlSum;
    private BigDecimal pmtCtrlSum;
    private String namespace;
    private boolean pmtTpInfSeen = false;
    private boolean pmtSvcLvlSeen = false;
    private boolean txSvcLvlSeen = false;
    private int dk37 = 3;
    private int dk39 = 3;
    private boolean dk31 = true;
    private boolean dk30 = true;
    private boolean dk27 = true;
    private boolean dk25 = true;
    private boolean dk24 = true;
    private boolean dk23 = true;

    public void setNoSchema() {
        this.dk31 = false;
        this.dk30 = false;
        this.dk27 = false;
        this.dk25 = false;
        this.dk24 = false;
        this.dk23 = false;
        this.dk39 = 0;
        this.dk37 = 0;
    }

    public void setValidateScheme(boolean validateScheme) {
        this.dk30 = this.dk31 = validateScheme;
        this.dk27 = this.dk31;
        this.dk25 = this.dk31;
        this.dk24 = this.dk31;
        this.dk23 = this.dk31;
        this.dk39 = validateScheme ? 3 : 0;
        this.dk37 = this.dk39;
    }

    public boolean isDk30() {
        return this.dk30;
    }

    public int getDk37() {
        return this.dk37;
    }

    public void setDk37(int dk37) {
        this.dk37 = dk37;
    }

    public int getDk39() {
        return this.dk39;
    }

    public void setDk39(int dk39) {
        this.dk39 = dk39;
    }

    public boolean isDk31() {
        return this.dk31;
    }

    public void setDk31(boolean dk31) {
        this.dk31 = dk31;
    }

    public void setDk30(boolean dk30) {
        this.dk30 = dk30;
    }

    public boolean isDk27() {
        return this.dk27;
    }

    public void setDk27(boolean dk27) {
        this.dk27 = dk27;
    }

    public boolean isDk25() {
        return this.dk25;
    }

    public void setDk25(boolean dk25) {
        this.dk25 = dk25;
    }

    public boolean isDk24() {
        return this.dk24;
    }

    public void setDk24(boolean dk24) {
        this.dk24 = dk24;
    }

    public boolean isDk23() {
        return this.dk23;
    }

    public void setDk23(boolean dk23) {
        this.dk23 = dk23;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.ticket = this.mkTicket();
        this.currentTicket = null;
        this.salary = false;
        this.hdrNbOfTxs = 0L;
        this.hdrCtrlSum = null;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.ticket.getTotalNumberOfPayments() != this.hdrNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.ticket.getTotalNumberOfPayments() + ")", this.locator));
        }
        if (this.hdrCtrlSum != null && this.hdrCtrlSum.compareTo(this.ticket.getTotalAmount()) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.ticket.getTotalAmount()) + ")", this.locator));
        }
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        StringBuilder toReturn = new StringBuilder();
        this.addNamespaceSchemaLocations(toReturn);
        return CCTDisplayMessageGenerator.finishNamespaceSchemaLocations(toReturn);
    }

    protected void addNamespaceSchemaLocations(StringBuilder sb) {
        if (this.dk39 != 0) {
            int myMode = this.dk39 != this.dk37 ? 3 : this.dk39;
            switch (myMode) {
                case 1: {
                    CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk39/pain.001.001.09_GBIC_5.xsd");
                    break;
                }
                case 2: {
                    CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk39/pain.001.001.09_CCU_GBIC_5.xsd");
                    break;
                }
                case 3: {
                    CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk39/pain.001.001.09_GBIC_5_ccx.xsd");
                }
            }
        } else {
            switch (this.dk37) {
                case 1: {
                    CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk37/pain.001.001.09_GBIC_4_cct.xsd");
                    break;
                }
                case 2: {
                    CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk37/pain.001.001.09_CCU_GBIC_4.xsd");
                    break;
                }
                case 3: {
                    CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/dk37/pain.001.001.09_GBIC_4_ccx.xsd");
                }
            }
        }
        if (this.dk30) {
            CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "/de/businesslogics/format/sepa/containernnn00102/pain.001.001.03.xsd");
        } else if (this.dk31) {
            CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "/de/businesslogics/format/dk31/pain.001.001.03_GBIC_2.xsd");
        }
        if (this.dk27) {
            CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.003.03", "/de/businesslogics/format/sepa/pain00100303/pain.001.003.03.xsd");
        }
        if (this.dk25) {
            CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.002.03", "/de/businesslogics/format/sepa/pain00100203/pain.001.002.03.xsd");
        }
        if (this.dk24) {
            CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:swift:xsd:$pain.001.002.02", "/de/businesslogics/format/sepa/pain00100202/pain.001.002.02.xsd");
        }
        if (this.dk23) {
            CCTDisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:sepade:xsd:pain.001.001.02.grp", "/de/businesslogics/format/sepa/pain.001.001.02.grp.xsd");
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_MSG_ID", "P119_MSG_ID", "P133_MSG_ID", "P123_MSG_ID", "P122_MSG_ID", "P112_MSG_ID"})
    public void setMsgId() {
        this.namespace = this.getPath().getUri();
        this.ticket.messageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_CRE_DT_TM", "P119_CRE_DT_TM", "P133_CRE_DT_TM", "P123_CRE_DT_TM", "P122_CRE_DT_TM", "P112_CRE_DT_TM"})
    public void setCreDtTm() throws SAXParseException {
        this.ticket.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P113_HDR_NB_OF_TXS", "P119_HDR_NB_OF_TXS", "P133_HDR_NB_OF_TXS", "P123_HDR_NB_OF_TXS", "P122_HDR_NB_OF_TXS", "P112_HDR_NB_OF_TXS"})
    public void setHdrNbOfTxs() throws SAXParseException {
        this.hdrNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P113_HDR_CTRL_SUM", "P119_HDR_CTRL_SUM", "P133_HDR_CTRL_SUM", "P123_HDR_CTRL_SUM", "P122_HDR_CTRL_SUM", "P112_HDR_CTRL_SUM"})
    public void setHdrCtrlSum() throws SAXParseException {
        this.hdrCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P113_INITG_NM", "P119_INITG_NM", "P133_INITG_NM", "P123_INITG_NM", "P122_INITG_NM", "P112_INITG_NM"})
    public void setInitiatorName() {
        this.ticket.initiatorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_INITG_ID", "P119_INITG_ID", "P133_INITG_ID", "P123_INITG_ID"})
    public void setInitiatorId() {
        this.ticket.initiatorId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF", "P119_PMT_INF", "P133_PMT_INF", "P123_PMT_INF", "P122_PMT_INF", "P112_PMT_INF"})
    public void startPmtInf(Attributes attributes) {
        this.currentTicket = new CCTSingleTicket();
        this.ticket.singleTickets.add(this.currentTicket);
        this.pmtNbOfTxs = null;
        this.pmtCtrlSum = null;
        this.pmtSvcLvlSeen = false;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_TP_INF", "P119_PMT_TP_INF"})
    public void handlePmtTpInf() {
        this.pmtTpInfSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF", "P119_PMT_INF", "P133_PMT_INF", "P123_PMT_INF"})
    public void endPmtInf() throws SAXException {
        if (this.pmtNbOfTxs != null && this.currentTicket.numberOfPayments != this.pmtNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.currentTicket.numberOfPayments + ")", this.locator));
        }
        if (this.pmtCtrlSum != null && this.pmtCtrlSum.compareTo(this.currentTicket.ctrlSum) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.currentTicket.ctrlSum) + ")", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_INF_ID", "P119_PMT_INF_ID", "P133_PMT_INF_ID", "P123_PMT_INF_ID", "P122_PMT_INF_ID", "P112_PMT_INF_ID"})
    public void setPmtInfId() {
        this.currentTicket.paymentInformationIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_NB_OF_TXS", "P119_PMT_NB_OF_TXS", "P133_PMT_NB_OF_TXS", "P123_PMT_NB_OF_TXS"})
    public void setPmtNbOfTxs() throws SAXParseException {
        this.pmtNbOfTxs = this.getInt();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_CTRL_SUM", "P119_PMT_CTRL_SUM", "P133_PMT_CTRL_SUM", "P123_PMT_CTRL_SUM"})
    public void setPmtCtrlSum() throws SAXParseException {
        this.pmtCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_SVC_LVL", "P119_PMT_SVC_LVL", "P133_PMT_SVC_LVL", "P123_PMT_SVC_LVL", "P122_PMT_SVC_LVL", "P112_PMT_SVC_LVL"})
    public void setPmtSvcLvl() {
        this.ticket.serviceLevel = this.getString();
        this.pmtSvcLvlSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_CTGY_PURP", "P113_TX_CTGY_PURP", "P113_PURP", "P119_PMT_CTGY_PURP", "P119_TX_CTGY_PURP", "P119_PURP", "P133_PMT_CTGY_PURP", "P133_TX_CTGY_PURP", "P133_PURP", "P123_PMT_CTGY_PURP", "P123_TX_CTGY_PURP", "P123_PURP", "P122_PMT_CTGY_PURP", "P122_TX_CTGY_PURP", "P122_PURP"})
    public void handleCtgyPurp() {
        String s = this.getString();
        this.salary |= salariesCodes.contains(s);
    }

    @SmartDefaultHandler.Callback(value={"P113_PMT_REQD_EXCTN_DT", "P119_PMT_REQD_EXCTN_DT", "P133_PMT_REQD_EXCTN_DT", "P123_PMT_REQD_EXCTN_DT", "P122_PMT_REQD_EXCTN_DT", "P112_PMT_REQD_EXCTN_DT"})
    public void setReqdExctnDt() throws SAXParseException {
        this.currentTicket.requestedExecutionDate = this.getDate();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_REQD_EXCTN_DT_TM"})
    public void setReqdExctnDtTm() throws SAXParseException {
        this.currentTicket.requestedExecutionDate = new YYMMDD(this.getDateTime().getTime());
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_NM", "P119_DBTR_NM", "P133_DBTR_NM", "P123_DBTR_NM", "P122_DBTR_NM", "P112_DBTR_NM"})
    public void setDbtrNm() {
        this.currentTicket.debitorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_IBAN", "P119_DBTR_IBAN", "P133_DBTR_IBAN", "P123_DBTR_IBAN", "P122_DBTR_IBAN", "P112_DBTR_IBAN"})
    public void setDbtrIban() {
        this.currentTicket.debitorAccount = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_BIC", "P119_DBTR_BICFI", "P133_DBTR_BIC", "P123_DBTR_BIC", "P122_DBTR_BIC", "P112_DBTR_BIC"})
    public void setDbtrBic() {
        this.currentTicket.debitorBIC = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_DBTR_ACCT_CCY", "P119_DBTR_ACCT_CCY", "P133_DBTR_ACCT_CCY", "P123_DBTR_ACCT_CCY", "P122_DBTR_ACCT_CCY"})
    public void setDbtrAcctCcy() {
        this.currentTicket.debitorAccountCcy = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P113_ULTMT_DBTR_ID", "P119_ULTMT_DBTR_ID", "P133_ULTMT_DBTR_ID", "P123_ULTMT_DBTR_ID"})
    public void setAlternativeIban() {
        if (this.bundesbank) {
            this.currentTicket.debitorBIC = null;
            this.currentTicket.debitorAccount = this.getString();
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_CDT_TRF_TX_INF", "P119_CDT_TRF_TX_INF", "P133_CDT_TRF_TX_INF", "P123_CDT_TRF_TX_INF", "P122_CDT_TRF_TX_INF", "P112_CDT_TRF_TX_INF"})
    public void startCdtTrfTxInf(Attributes attributes) {
        this.txSvcLvlSeen = this.pmtSvcLvlSeen;
    }

    @SmartDefaultHandler.Callback(value={"P113_TX_PMT_TP_INF", "P119_TX_PMT_TP_INF"})
    public void handleTxPmtTpInf() throws SAXException {
        if (this.pmtTpInfSeen) {
            this.error(new MltplPmtTpInfException("Payment type information already defined at batch level.", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_TX_SVC_LVL", "P119_TX_SVC_LVL", "P133_TX_SVC_LVL", "P123_TX_SVC_LVL", "P122_TX_SVC_LVL"})
    public void setTxSvcLvl() {
        this.txSvcLvlSeen = true;
        if (this.ticket.serviceLevel != null) {
            String s = this.getString();
            if (this.ticket.serviceLevel.length() == 0) {
                this.ticket.serviceLevel = s;
            } else if (!s.equals(this.ticket.serviceLevel)) {
                this.ticket.serviceLevel = null;
            }
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_INSTD_AMT", "P119_INSTD_AMT", "P133_INSTD_AMT", "P123_INSTD_AMT", "P122_INSTD_AMT", "P112_INSTD_AMT"})
    public void startInstdAmt(Attributes attributes) throws SAXException {
        String ccy = attributes.getValue("Ccy");
        if (ccy != null && !"EUR".equals(ccy)) {
            this.error(new CcyException("Wrong currency " + ccy + " in Instructed Amount. Only EUR is allowed.", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P113_INSTD_AMT", "P119_INSTD_AMT", "P133_INSTD_AMT", "P123_INSTD_AMT", "P122_INSTD_AMT", "P112_INSTD_AMT"})
    public void handleAmount() throws SAXParseException {
        this.currentTicket.ctrlSum = this.currentTicket.ctrlSum.add(this.getDecimal());
        ++this.currentTicket.numberOfPayments;
    }

    @Override
    public CCTTicket getMessage(InputStream in) throws IOException, SAXException {
        this.parse(in);
        return this.ticket;
    }

    public boolean containsSalary() {
        return this.salary;
    }

    public CCTTicket getMessage() {
        return this.ticket;
    }

    public void setBundesbank(boolean b) {
        this.bundesbank = b;
    }

    protected CCTTicket mkTicket() {
        return new CCTTicket();
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        boolean enableMltplPmtTpInf = SystemProperties.isCustomerCreditMultiplePaymentTypeInformation();
        boolean isMltplPmtTpInfException = e instanceof MltplPmtTpInfException;
        if (!isMltplPmtTpInfException || isMltplPmtTpInfException && !enableMltplPmtTpInf) {
            super.error(e);
        }
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "Document");
        SmartDefaultHandler.Path cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P119_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P119_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P119_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P119_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        SmartDefaultHandler.Path initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P119_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(initgPty, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P119_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P119_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P119_PMT_INF_ID = new SmartDefaultHandler.Path(P119_PMT_INF, "PmtInfId");
        P119_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P119_PMT_INF, "NbOfTxs");
        P119_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P119_PMT_INF, "CtrlSum");
        P119_PMT_TP_INF = new SmartDefaultHandler.Path(P119_PMT_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl = new SmartDefaultHandler.Path(P119_PMT_TP_INF, "SvcLvl");
        P119_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        SmartDefaultHandler.Path ctgyPurp = new SmartDefaultHandler.Path(P119_PMT_TP_INF, "CtgyPurp");
        P119_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp, "Cd");
        SmartDefaultHandler.Path reqdExctnDt = new SmartDefaultHandler.Path(P119_PMT_INF, "ReqdExctnDt");
        P119_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(reqdExctnDt, "Dt");
        P119_PMT_REQD_EXCTN_DT_TM = new SmartDefaultHandler.Path(reqdExctnDt, "DtTm");
        SmartDefaultHandler.Path dbtr = new SmartDefaultHandler.Path(P119_PMT_INF, "Dbtr");
        P119_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        SmartDefaultHandler.Path dbtrAcct = new SmartDefaultHandler.Path(P119_PMT_INF, "DbtrAcct");
        SmartDefaultHandler.Path id2 = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        P119_DBTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        P119_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct, "Ccy");
        SmartDefaultHandler.Path dbtrAgt = new SmartDefaultHandler.Path(P119_PMT_INF, "DbtrAgt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        P119_DBTR_BICFI = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        SmartDefaultHandler.Path ultmtDbtr = new SmartDefaultHandler.Path(P119_PMT_INF, "UltmtDbtr");
        SmartDefaultHandler.Path id3 = new SmartDefaultHandler.Path(ultmtDbtr, "Id");
        SmartDefaultHandler.Path orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        SmartDefaultHandler.Path othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        P119_ULTMT_DBTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        P119_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P119_PMT_INF, "CdtTrfTxInf");
        P119_TX_PMT_TP_INF = new SmartDefaultHandler.Path(P119_CDT_TRF_TX_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl2 = new SmartDefaultHandler.Path(P119_TX_PMT_TP_INF, "SvcLvl");
        P119_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        SmartDefaultHandler.Path ctgyPurp2 = new SmartDefaultHandler.Path(P119_TX_PMT_TP_INF, "CtgyPurp");
        P119_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp2, "Cd");
        SmartDefaultHandler.Path amt = new SmartDefaultHandler.Path(P119_CDT_TRF_TX_INF, "Amt");
        P119_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        SmartDefaultHandler.Path purp = new SmartDefaultHandler.Path(P119_CDT_TRF_TX_INF, "Purp");
        P119_PURP = new SmartDefaultHandler.Path(purp, "Cd");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "Document");
        cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P113_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P113_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P113_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P113_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P113_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P113_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P113_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P113_PMT_INF_ID = new SmartDefaultHandler.Path(P113_PMT_INF, "PmtInfId");
        P113_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P113_PMT_INF, "NbOfTxs");
        P113_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P113_PMT_INF, "CtrlSum");
        P113_PMT_TP_INF = new SmartDefaultHandler.Path(P113_PMT_INF, "PmtTpInf");
        svcLvl = new SmartDefaultHandler.Path(P113_PMT_TP_INF, "SvcLvl");
        P113_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        ctgyPurp = new SmartDefaultHandler.Path(P113_PMT_TP_INF, "CtgyPurp");
        P113_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp, "Cd");
        P113_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(P113_PMT_INF, "ReqdExctnDt");
        dbtr = new SmartDefaultHandler.Path(P113_PMT_INF, "Dbtr");
        P113_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        dbtrAcct = new SmartDefaultHandler.Path(P113_PMT_INF, "DbtrAcct");
        id2 = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        P113_DBTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        P113_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct, "Ccy");
        dbtrAgt = new SmartDefaultHandler.Path(P113_PMT_INF, "DbtrAgt");
        finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        P113_DBTR_BIC = new SmartDefaultHandler.Path(finInstnId, "BIC");
        ultmtDbtr = new SmartDefaultHandler.Path(P113_PMT_INF, "UltmtDbtr");
        id3 = new SmartDefaultHandler.Path(ultmtDbtr, "Id");
        orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        P113_ULTMT_DBTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        P113_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P113_PMT_INF, "CdtTrfTxInf");
        P113_TX_PMT_TP_INF = new SmartDefaultHandler.Path(P113_CDT_TRF_TX_INF, "PmtTpInf");
        svcLvl2 = new SmartDefaultHandler.Path(P113_TX_PMT_TP_INF, "SvcLvl");
        P113_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        ctgyPurp2 = new SmartDefaultHandler.Path(P113_TX_PMT_TP_INF, "CtgyPurp");
        P113_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp2, "Cd");
        amt = new SmartDefaultHandler.Path(P113_CDT_TRF_TX_INF, "Amt");
        P113_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        purp = new SmartDefaultHandler.Path(P113_CDT_TRF_TX_INF, "Purp");
        P113_PURP = new SmartDefaultHandler.Path(purp, "Cd");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.003.03", "Document");
        cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P133_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P133_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P133_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P133_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P133_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P133_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P133_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P133_PMT_INF_ID = new SmartDefaultHandler.Path(P133_PMT_INF, "PmtInfId");
        P133_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P133_PMT_INF, "NbOfTxs");
        P133_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P133_PMT_INF, "CtrlSum");
        SmartDefaultHandler.Path pmtTpInf = new SmartDefaultHandler.Path(P133_PMT_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl3 = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P133_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl3, "Cd");
        SmartDefaultHandler.Path ctgyPurp3 = new SmartDefaultHandler.Path(pmtTpInf, "CtgyPurp");
        P133_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp3, "Cd");
        P133_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(P133_PMT_INF, "ReqdExctnDt");
        SmartDefaultHandler.Path dbtr2 = new SmartDefaultHandler.Path(P133_PMT_INF, "Dbtr");
        P133_DBTR_NM = new SmartDefaultHandler.Path(dbtr2, "Nm");
        SmartDefaultHandler.Path dbtrAcct2 = new SmartDefaultHandler.Path(P133_PMT_INF, "DbtrAcct");
        SmartDefaultHandler.Path id4 = new SmartDefaultHandler.Path(dbtrAcct2, "Id");
        P133_DBTR_IBAN = new SmartDefaultHandler.Path(id4, "IBAN");
        P133_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct2, "Ccy");
        SmartDefaultHandler.Path dbtrAgt2 = new SmartDefaultHandler.Path(P133_PMT_INF, "DbtrAgt");
        SmartDefaultHandler.Path finInstnId2 = new SmartDefaultHandler.Path(dbtrAgt2, "FinInstnId");
        P133_DBTR_BIC = new SmartDefaultHandler.Path(finInstnId2, "BIC");
        SmartDefaultHandler.Path ultmtDbtr2 = new SmartDefaultHandler.Path(P133_PMT_INF, "UltmtDbtr");
        SmartDefaultHandler.Path id5 = new SmartDefaultHandler.Path(ultmtDbtr2, "Id");
        SmartDefaultHandler.Path orgId3 = new SmartDefaultHandler.Path(id5, "OrgId");
        SmartDefaultHandler.Path othr3 = new SmartDefaultHandler.Path(orgId3, "Othr");
        P133_ULTMT_DBTR_ID = new SmartDefaultHandler.Path(othr3, "Id");
        P133_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P133_PMT_INF, "CdtTrfTxInf");
        SmartDefaultHandler.Path txPmtTpInf = new SmartDefaultHandler.Path(P133_CDT_TRF_TX_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl4 = new SmartDefaultHandler.Path(txPmtTpInf, "SvcLvl");
        P133_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl4, "Cd");
        SmartDefaultHandler.Path ctgyPurp4 = new SmartDefaultHandler.Path(txPmtTpInf, "CtgyPurp");
        P133_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp4, "Cd");
        SmartDefaultHandler.Path amt2 = new SmartDefaultHandler.Path(P133_CDT_TRF_TX_INF, "Amt");
        P133_INSTD_AMT = new SmartDefaultHandler.Path(amt2, "InstdAmt");
        SmartDefaultHandler.Path purp2 = new SmartDefaultHandler.Path(P133_CDT_TRF_TX_INF, "Purp");
        P133_PURP = new SmartDefaultHandler.Path(purp2, "Cd");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.002.03", "Document");
        cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P123_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P123_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P123_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P123_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P123_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P123_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P123_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P123_PMT_INF_ID = new SmartDefaultHandler.Path(P123_PMT_INF, "PmtInfId");
        P123_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P123_PMT_INF, "NbOfTxs");
        P123_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P123_PMT_INF, "CtrlSum");
        pmtTpInf = new SmartDefaultHandler.Path(P123_PMT_INF, "PmtTpInf");
        svcLvl3 = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P123_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl3, "Cd");
        ctgyPurp3 = new SmartDefaultHandler.Path(pmtTpInf, "CtgyPurp");
        P123_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp3, "Cd");
        P123_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(P123_PMT_INF, "ReqdExctnDt");
        dbtr = new SmartDefaultHandler.Path(P123_PMT_INF, "Dbtr");
        P123_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        dbtrAcct = new SmartDefaultHandler.Path(P123_PMT_INF, "DbtrAcct");
        id2 = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        P123_DBTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        P123_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct, "Ccy");
        dbtrAgt = new SmartDefaultHandler.Path(P123_PMT_INF, "DbtrAgt");
        finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        P123_DBTR_BIC = new SmartDefaultHandler.Path(finInstnId, "BIC");
        ultmtDbtr = new SmartDefaultHandler.Path(P123_PMT_INF, "UltmtDbtr");
        id3 = new SmartDefaultHandler.Path(ultmtDbtr, "Id");
        orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        P123_ULTMT_DBTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        P123_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P123_PMT_INF, "CdtTrfTxInf");
        SmartDefaultHandler.Path txPmtTpInf2 = new SmartDefaultHandler.Path(P123_CDT_TRF_TX_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl5 = new SmartDefaultHandler.Path(txPmtTpInf2, "SvcLvl");
        P123_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl5, "Cd");
        SmartDefaultHandler.Path ctgyPurp5 = new SmartDefaultHandler.Path(txPmtTpInf2, "CtgyPurp");
        P123_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp5, "Cd");
        amt = new SmartDefaultHandler.Path(P123_CDT_TRF_TX_INF, "Amt");
        P123_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        purp = new SmartDefaultHandler.Path(P123_CDT_TRF_TX_INF, "Purp");
        P123_PURP = new SmartDefaultHandler.Path(purp, "Cd");
        document = new SmartDefaultHandler.Path(null, "urn:swift:xsd:$pain.001.002.02", "Document");
        SmartDefaultHandler.Path pain00100102 = new SmartDefaultHandler.Path(document, "pain.001.001.02");
        grpHdr = new SmartDefaultHandler.Path(pain00100102, "GrpHdr");
        P122_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P122_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P122_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P122_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P122_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        P122_PMT_INF = new SmartDefaultHandler.Path(pain00100102, "PmtInf");
        P122_PMT_INF_ID = new SmartDefaultHandler.Path(P122_PMT_INF, "PmtInfId");
        pmtTpInf = new SmartDefaultHandler.Path(P122_PMT_INF, "PmtTpInf");
        svcLvl3 = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P122_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl3, "Cd");
        P122_PMT_CTGY_PURP = new SmartDefaultHandler.Path(pmtTpInf, "CtgyPurp");
        P122_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(P122_PMT_INF, "ReqdExctnDt");
        dbtr2 = new SmartDefaultHandler.Path(P122_PMT_INF, "Dbtr");
        P122_DBTR_NM = new SmartDefaultHandler.Path(dbtr2, "Nm");
        dbtrAcct2 = new SmartDefaultHandler.Path(P122_PMT_INF, "DbtrAcct");
        id4 = new SmartDefaultHandler.Path(dbtrAcct2, "Id");
        P122_DBTR_IBAN = new SmartDefaultHandler.Path(id4, "IBAN");
        P122_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct2, "Ccy");
        dbtrAgt2 = new SmartDefaultHandler.Path(P122_PMT_INF, "DbtrAgt");
        finInstnId2 = new SmartDefaultHandler.Path(dbtrAgt2, "FinInstnId");
        P122_DBTR_BIC = new SmartDefaultHandler.Path(finInstnId2, "BIC");
        P122_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P122_PMT_INF, "CdtTrfTxInf");
        txPmtTpInf2 = new SmartDefaultHandler.Path(P122_CDT_TRF_TX_INF, "PmtTpInf");
        svcLvl5 = new SmartDefaultHandler.Path(txPmtTpInf2, "SvcLvl");
        P122_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl5, "Cd");
        P122_TX_CTGY_PURP = new SmartDefaultHandler.Path(txPmtTpInf2, "CtgyPurp");
        amt = new SmartDefaultHandler.Path(P122_CDT_TRF_TX_INF, "Amt");
        P122_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        purp = new SmartDefaultHandler.Path(P122_CDT_TRF_TX_INF, "Purp");
        P122_PURP = new SmartDefaultHandler.Path(purp, "Cd");
        document = new SmartDefaultHandler.Path(null, "urn:sepade:xsd:pain.001.001.02.grp", "Document");
        pain00100102 = new SmartDefaultHandler.Path(document, "pain.001.001.02");
        grpHdr = new SmartDefaultHandler.Path(pain00100102, "GrpHdr");
        P112_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P112_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P112_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P112_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P112_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        P112_PMT_INF = new SmartDefaultHandler.Path(pain00100102, "PmtInf");
        P112_PMT_INF_ID = new SmartDefaultHandler.Path(P112_PMT_INF, "PmtInfId");
        pmtTpInf = new SmartDefaultHandler.Path(P112_PMT_INF, "PmtTpInf");
        svcLvl3 = new SmartDefaultHandler.Path(pmtTpInf, "SvcLvl");
        P112_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl3, "Cd");
        P112_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(P112_PMT_INF, "ReqdExctnDt");
        dbtr2 = new SmartDefaultHandler.Path(P112_PMT_INF, "Dbtr");
        P112_DBTR_NM = new SmartDefaultHandler.Path(dbtr2, "Nm");
        dbtrAcct2 = new SmartDefaultHandler.Path(P112_PMT_INF, "DbtrAcct");
        id4 = new SmartDefaultHandler.Path(dbtrAcct2, "Id");
        P112_DBTR_IBAN = new SmartDefaultHandler.Path(id4, "IBAN");
        dbtrAgt2 = new SmartDefaultHandler.Path(P112_PMT_INF, "DbtrAgt");
        finInstnId2 = new SmartDefaultHandler.Path(dbtrAgt2, "FinInstnId");
        P112_DBTR_BIC = new SmartDefaultHandler.Path(finInstnId2, "BIC");
        P112_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P112_PMT_INF, "CdtTrfTxInf");
        amt = new SmartDefaultHandler.Path(P112_CDT_TRF_TX_INF, "Amt");
        P112_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        salariesCodes = new HashSet(3);
        salariesCodes.add("BONU");
        salariesCodes.add("PENS");
        salariesCodes.add("SALA");
    }
}

