/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.CCTTicket;
import de.businesslogics.util.HexTool;

public class CCCSingleTicket
extends CCTTicket {
    private static final long serialVersionUID = 1L;
    private byte[] hashValue;

    public CCCSingleTicket(byte[] hashValue) {
        this.hashValue = hashValue;
    }

    @Override
    public void append(AbstractDisplayMessage message) {
        super.append(message);
        if (this.hashValue != null) {
            byte[] oneByte = new byte[1];
            String key = message.bundle.getString("HASH_VALUE");
            message.buffer.append("     ").append(key);
            int j = key.length();
            while (j++ < message.keyWidth) {
                message.buffer.append(' ');
            }
            message.buffer.append(": ");
            for (int i = 0; i < this.hashValue.length; ++i) {
                if (i % 8 == 0) {
                    if (i > 0) {
                        message.buffer.append("\r\n");
                        for (j = message.keyWidth + 7; j > 0; --j) {
                            message.buffer.append(' ');
                        }
                    }
                } else {
                    message.buffer.append(' ');
                }
                oneByte[0] = this.hashValue[i];
                message.buffer.append(HexTool.toHex(oneByte));
            }
            message.buffer.append("\r\n");
        }
    }

    public byte[] getHashValue() {
        return this.hashValue;
    }
}

