/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.ebics.schema.SignatureContentHandler;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.CCCSingleTicket;
import de.businesslogics.format.ticket.CCCTicket;
import de.businesslogics.format.ticket.CCTDisplayMessageGenerator;
import de.businesslogics.format.ticket.CCTTicket;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.HashHolder;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.xml.OutputSAXParser;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CCCDisplayMessageGenerator
extends SignatureContentHandler
implements DisplayMessageGenerator {
    protected static final HashSet<String> DOCUMENT_URIS = new HashSet();
    private final CCCSP handler;
    private boolean checkDigest = true;

    public CCCDisplayMessageGenerator() {
        this(new CCCSP());
    }

    protected CCCDisplayMessageGenerator(CCCSP handler) {
        this.handler = handler;
        super.setNextHandler(handler);
    }

    public String getDocumentNamespace() {
        return this.handler.documentNamespace;
    }

    public boolean isCheckDigest() {
        return this.checkDigest;
    }

    public void setCheckDigest(boolean checkDigest) {
        this.checkDigest = checkDigest;
    }

    public boolean isDk37() {
        return this.handler.sub.getDk37() == 3;
    }

    public void setDk37(boolean dk37) {
        this.handler.sub.setDk37(dk37 ? 3 : 0);
    }

    public boolean isDk39() {
        return this.handler.sub.getDk39() == 3;
    }

    public void setDk39(boolean dk39) {
        this.handler.sub.setDk39(dk39 ? 3 : 0);
    }

    public boolean isDk36() {
        return this.handler.dk36;
    }

    public void setDk36(boolean dk36) {
        this.handler.dk36 = dk36;
    }

    public boolean isDk31() {
        return this.handler.sub.isDk31();
    }

    public void setDk31(boolean dk31) {
        this.handler.sub.setDk31(dk31);
    }

    public boolean isDk30() {
        return this.handler.sub.isDk30();
    }

    public void setDk30(boolean dk30) {
        this.handler.sub.setDk30(dk30);
    }

    public boolean isDk27() {
        return this.handler.sub.isDk27();
    }

    public void setDk27(boolean dk27) {
        this.handler.sub.setDk27(dk27);
    }

    public boolean isDk25() {
        return this.handler.sub.isDk25();
    }

    public void setDk25(boolean dk25) {
        this.handler.sub.setDk25(dk25);
    }

    public boolean isDk24() {
        return this.handler.sub.isDk24();
    }

    public void setDk24(boolean dk24) {
        this.handler.sub.setDk24(dk24);
    }

    public void setValidateScheme(boolean validateScheme) {
        this.setDk24(validateScheme);
        this.setDk25(validateScheme);
        this.setDk27(validateScheme);
        this.setDk30(validateScheme);
        this.setDk31(validateScheme);
        this.setDk36(validateScheme);
        this.setDk37(validateScheme);
        this.setDk39(validateScheme);
    }

    @Override
    protected boolean startDigest(String namespaceURI, String localName, String qName, Attributes atts) {
        return ((HashHolder)((Object)this.handler.sub)).getGivenHash() != null && "Document".equals(localName) && this.isDocumentUri(namespaceURI);
    }

    protected boolean isDocumentUri(String namespaceURI) {
        return DOCUMENT_URIS.contains(namespaceURI);
    }

    @Override
    protected void endDigest() throws SAXException {
        try {
            this.w.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.w = null;
        byte[] d = this.digest.digest();
        if (this.checkDigest && !Arrays.equals(((HashHolder)((Object)this.handler.sub)).getGivenHash(), d)) {
            throw new SAXException("Expected hash " + HexTool.toHex(d) + ", found " + HexTool.toHex(((HashHolder)((Object)this.handler.sub)).getGivenHash()));
        }
    }

    @Override
    public DisplayMessage getMessage(InputStream in) throws Exception {
        int i;
        OutputSAXParser op = this.handler.getOutputSAXParser(this);
        byte[] buffer = new byte[4096];
        while ((i = in.read(buffer)) > 0) {
            op.write(buffer, 0, i);
        }
        op.close();
        return this.handler.ticket;
    }

    public CCCTicket getMessage() {
        return this.handler.ticket;
    }

    public boolean containsSalary() {
        return this.handler.salary;
    }

    public OutputSAXParser getOutputSAXParser() throws IOException, SAXException {
        return this.handler.getOutputSAXParser(this);
    }

    public static class CCCSP
    extends SmartDefaultHandler {
        boolean dk36 = true;
        public static final SmartDefaultHandler.Path C15_MSG1;
        public static final SmartDefaultHandler.Path C15_MSG1_HASH;
        public static final SmartDefaultHandler.Path P119_5_DOCUMENT;
        public static final SmartDefaultHandler.Path C14_MSG1;
        public static final SmartDefaultHandler.Path C14_MSG1_HASH;
        public static final SmartDefaultHandler.Path P119_DOCUMENT;
        public static final SmartDefaultHandler.Path C13_MSG1;
        public static final SmartDefaultHandler.Path C13_MSG1_HASH;
        public static final SmartDefaultHandler.Path P113_36_DOCUMENT;
        public static final SmartDefaultHandler.Path C12_MSG1;
        public static final SmartDefaultHandler.Path C12_MSG1_HASH;
        public static final SmartDefaultHandler.Path P113_DOCUMENT;
        public static final SmartDefaultHandler.Path C32_MSG1;
        public static final SmartDefaultHandler.Path C32_MSG1_HASH;
        public static final SmartDefaultHandler.Path P133_DOCUMENT;
        public static final SmartDefaultHandler.Path C22_MSG1;
        public static final SmartDefaultHandler.Path C22_MSG1_HASH;
        public static final SmartDefaultHandler.Path P123_DOCUMENT;
        public static final SmartDefaultHandler.Path C2_MSG1;
        public static final SmartDefaultHandler.Path C2_MSG1_HASH;
        public static final SmartDefaultHandler.Path P122_DOCUMENT;
        protected final CCTDisplayMessageGenerator sub;
        private CCCTicket ticket;
        private boolean salary;
        private String documentNamespace;

        private CCCSP() {
            this(new CCCSingleTicketGenerator());
        }

        protected CCCSP(CCTDisplayMessageGenerator sub) {
            this.sub = sub;
            sub.setDk23(false);
        }

        @Override
        protected String getNamespaceSchemaLocations() {
            String s;
            if (this.dk36) {
                this.sub.setDk31(true);
            }
            if ((s = this.sub.getNamespaceSchemaLocations()) == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(s);
            if (this.sub.getDk39() != 0) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.GBIC5", "/de/businesslogics/format/dk39/container.nnn.001.GBIC5.ccc.xsd");
            }
            if (this.sub.getDk37() != 0) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.GBIC4", "/de/businesslogics/format/ticket/container.nnn.001.GBIC4.ccc.xsd");
            }
            if (this.dk36) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.03", "/de/businesslogics/format/ticket/container.nnn.001.03.ccc.xsd");
            }
            if (this.sub.isDk30() || this.sub.isDk31()) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.02", "/de/businesslogics/format/ticket/container.nnn.001.02.ccc.xsd");
            }
            if (this.sub.isDk27()) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.003.02", "/de/businesslogics/format/ticket/container.nnn.003.02.ccc.xsd");
            }
            if (this.sub.isDk25()) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.002.02", "/de/businesslogics/format/ticket/container.nnn.002.02.ccc.xsd");
            }
            if (this.sub.isDk24()) {
                CCCSP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.002", "/de/businesslogics/format/ticket/container.nnn.002.ccc.xsd");
            }
            return CCCSP.finishNamespaceSchemaLocations(sb);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.ticket = new CCCTicket();
            this.salary = false;
        }

        @SmartDefaultHandler.Callback(value={"C12_MSG1_HASH", "C13_MSG1_HASH", "C14_MSG1_HASH", "C15_MSG1_HASH", "C32_MSG1_HASH", "C22_MSG1_HASH", "C2_MSG1_HASH"})
        public void setGivenHash() throws SAXParseException {
            CCCSP.setGivenHash((HashHolder)((Object)this.sub), this.getString(), this.locator);
        }

        @SmartDefaultHandler.Callback(value={"P113_DOCUMENT", "P113_36_DOCUMENT", "P119_DOCUMENT", "P119_5_DOCUMENT", "P133_DOCUMENT", "P123_DOCUMENT", "P122_DOCUMENT"})
        public SmartDefaultHandler startPainDocument(Attributes atts) {
            this.documentNamespace = this.getPath().getUri();
            return this.sub;
        }

        @SmartDefaultHandler.Callback(value={"P113_DOCUMENT", "P113_36_DOCUMENT", "P119_DOCUMENT", "P119_5_DOCUMENT", "P133_DOCUMENT", "P123_DOCUMENT", "P122_DOCUMENT"})
        public void endPainDocument() {
            this.ticket.getSingleTickets().add((CCCSingleTicket)this.sub.getMessage());
            this.salary |= this.sub.containsSalary();
        }

        @SmartDefaultHandler.Callback(value={"C12_MSG1", "C13_MSG1", "C14_MSG1", "C15_MSG1", "C32_MSG1", "C22_MSG1", "C2_MSG1"})
        public void endMsg001() {
            ((HashHolder)((Object)this.sub)).setGivenHash(null);
        }

        static {
            SmartDefaultHandler.Path p119Document = CCTDisplayMessageGenerator.P119_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p119Document.getUri());
            SmartDefaultHandler.Path conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.GBIC5", "conxml");
            C15_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C15_MSG1_HASH = new SmartDefaultHandler.Path(C15_MSG1, "HashValue");
            P119_5_DOCUMENT = p119Document.prefixPath(C15_MSG1);
            p119Document = CCTDisplayMessageGenerator.P119_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p119Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.GBIC4", "conxml");
            C14_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C14_MSG1_HASH = new SmartDefaultHandler.Path(C14_MSG1, "HashValue");
            P119_DOCUMENT = p119Document.prefixPath(C14_MSG1);
            SmartDefaultHandler.Path p113Document = CCTDisplayMessageGenerator.P113_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p113Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.03", "conxml");
            C13_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C13_MSG1_HASH = new SmartDefaultHandler.Path(C13_MSG1, "HashValue");
            P113_36_DOCUMENT = p113Document.prefixPath(C13_MSG1);
            p113Document = CCTDisplayMessageGenerator.P113_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p113Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.02", "conxml");
            C12_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C12_MSG1_HASH = new SmartDefaultHandler.Path(C12_MSG1, "HashValue");
            P113_DOCUMENT = p113Document.prefixPath(C12_MSG1);
            SmartDefaultHandler.Path p133Document = CCTDisplayMessageGenerator.P133_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p133Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.003.02", "conxml");
            C32_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C32_MSG1_HASH = new SmartDefaultHandler.Path(C32_MSG1, "HashValue");
            P133_DOCUMENT = p133Document.prefixPath(C32_MSG1);
            SmartDefaultHandler.Path p123Document = CCTDisplayMessageGenerator.P123_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p123Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.002.02", "conxml");
            C22_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C22_MSG1_HASH = new SmartDefaultHandler.Path(C22_MSG1, "HashValue");
            P123_DOCUMENT = p123Document.prefixPath(C22_MSG1);
            SmartDefaultHandler.Path p122Document = CCTDisplayMessageGenerator.P122_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p122Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.002", "conxml");
            C2_MSG1 = new SmartDefaultHandler.Path(conxml, "MsgPain001");
            C2_MSG1_HASH = new SmartDefaultHandler.Path(C2_MSG1, "HashValue");
            P122_DOCUMENT = p122Document.prefixPath(C2_MSG1);
        }
    }

    public static class CCCSingleTicketGenerator
    extends CCTDisplayMessageGenerator
    implements HashHolder {
        byte[] givenHash;

        @Override
        protected CCTTicket mkTicket() {
            return new CCCSingleTicket(this.givenHash);
        }

        @Override
        public byte[] getGivenHash() {
            return this.givenHash;
        }

        @Override
        public void setGivenHash(byte[] givenHash) {
            this.givenHash = givenHash;
        }
    }
}

