/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.C07Ticket;
import de.businesslogics.util.HexTool;

public class CC7SingleTicket
extends C07Ticket {
    private static final long serialVersionUID = 1L;
    private byte[] hashValue;

    public CC7SingleTicket(byte[] hashValue) {
        this.hashValue = hashValue;
    }

    @Override
    public void append(AbstractDisplayMessage message) {
        super.append(message);
        if (this.hashValue != null) {
            byte[] oneByte = new byte[1];
            String key = message.bundle.getString("HASH_VALUE");
            message.buffer.append("     ").append(key);
            int j = key.length();
            while (j++ < message.keyWidth) {
                message.buffer.append(' ');
            }
            message.buffer.append(": ");
            for (int i = 0; i < this.hashValue.length; ++i) {
                if (i % 8 == 0) {
                    if (i > 0) {
                        message.buffer.append("\r\n");
                        for (j = message.keyWidth + 7; j > 0; --j) {
                            message.buffer.append(' ');
                        }
                    }
                } else {
                    message.buffer.append(' ');
                }
                oneByte[0] = this.hashValue[i];
                message.buffer.append(HexTool.toHex(oneByte));
            }
            message.buffer.append("\r\n");
        }
    }

    public byte[] getHashValue() {
        return this.hashValue;
    }
}

