/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.ebics.schema.SignatureContentHandler;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.C07DisplayMessageGenerator;
import de.businesslogics.format.ticket.C07Ticket;
import de.businesslogics.format.ticket.CC7SingleTicket;
import de.businesslogics.format.ticket.CC7Ticket;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.HashHolder;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.xml.OutputSAXParser;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CC7DisplayMessageGenerator
extends SignatureContentHandler
implements DisplayMessageGenerator {
    protected static final HashSet<String> DOCUMENT_URIS = new HashSet();
    private final CC7SP handler;
    private boolean checkDigest = true;

    public CC7DisplayMessageGenerator() {
        this(new CC7SP());
    }

    protected CC7DisplayMessageGenerator(CC7SP handler) {
        this.handler = handler;
        super.setNextHandler(handler);
    }

    public boolean isCheckDigest() {
        return this.checkDigest;
    }

    public void setCheckDigest(boolean checkDigest) {
        this.checkDigest = checkDigest;
    }

    public boolean isDk39() {
        return this.handler.sub.isDk39();
    }

    public void setDk39(boolean dk39) {
        this.handler.sub.setDk39(dk39);
    }

    public boolean isDk37() {
        return this.handler.sub.isDk37();
    }

    public void setDk37(boolean dk37) {
        this.handler.sub.setDk37(dk37);
    }

    public boolean isDk31() {
        return this.handler.sub.isDk31();
    }

    public void setDk31(boolean dk31) {
        this.handler.sub.setDk31(dk31);
    }

    public String getDocumentNamespace() {
        return this.handler.documentNamespace;
    }

    protected boolean isDocumentUri(String namespaceURI) {
        return DOCUMENT_URIS.contains(namespaceURI);
    }

    @Override
    public DisplayMessage getMessage(InputStream in) throws Exception {
        int i;
        OutputSAXParser op = this.handler.getOutputSAXParser(this);
        byte[] buffer = new byte[4096];
        while ((i = in.read(buffer)) > 0) {
            op.write(buffer, 0, i);
        }
        op.close();
        return this.handler.ticket;
    }

    @Override
    protected boolean startDigest(String namespaceURI, String localName, String qName, Attributes atts) {
        return ((HashHolder)((Object)this.handler.sub)).getGivenHash() != null && "Document".equals(localName) && this.isDocumentUri(namespaceURI);
    }

    @Override
    protected void endDigest() throws SAXException {
        try {
            this.w.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.w = null;
        byte[] d = this.digest.digest();
        if (this.checkDigest && !Arrays.equals(((HashHolder)((Object)this.handler.sub)).getGivenHash(), d)) {
            throw new SAXException("Expected hash " + HexTool.toHex(d) + ", found " + HexTool.toHex(((HashHolder)((Object)this.handler.sub)).getGivenHash()));
        }
    }

    public CC7Ticket getMessage() {
        return this.handler.ticket;
    }

    public OutputSAXParser getOutputSAXParser() throws IOException, SAXException {
        return this.handler.getOutputSAXParser(this);
    }

    public static class CC7SP
    extends SmartDefaultHandler {
        public static final SmartDefaultHandler.Path C15_MSG7;
        public static final SmartDefaultHandler.Path C15_MSG7_HASH;
        public static final SmartDefaultHandler.Path P719_5_DOCUMENT;
        public static final SmartDefaultHandler.Path C14_MSG7;
        public static final SmartDefaultHandler.Path C14_MSG7_HASH;
        public static final SmartDefaultHandler.Path P719_DOCUMENT;
        public static final SmartDefaultHandler.Path C12_MSG7;
        public static final SmartDefaultHandler.Path C12_MSG7_HASH;
        public static final SmartDefaultHandler.Path P712_DOCUMENT;
        protected final C07DisplayMessageGenerator sub;
        private CC7Ticket ticket;
        private String documentNamespace;

        private CC7SP() {
            this(new CC7SingleTicketGenerator());
        }

        public CC7SP(C07DisplayMessageGenerator sub) {
            this.sub = sub;
        }

        @Override
        protected String getNamespaceSchemaLocations() {
            String s = this.sub.getNamespaceSchemaLocations();
            if (s == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(s);
            if (this.sub.isDk39()) {
                CC7SP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.GBIC5", "/de/businesslogics/format/dk39/container.nnn.001.GBIC5.cc7.xsd");
            }
            if (this.sub.isDk37()) {
                CC7SP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.GBIC4", "/de/businesslogics/format/ticket/container.nnn.001.GBIC4.cc7.xsd");
            }
            if (this.sub.isDk31()) {
                CC7SP.appendNamespaceSchemaLocation(sb, "urn:conxml:xsd:container.nnn.001.02", "/de/businesslogics/format/ticket/container.nnn.001.02.cc7.xsd");
            }
            return CC7SP.finishNamespaceSchemaLocations(sb);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.ticket = new CC7Ticket();
        }

        @SmartDefaultHandler.Callback(value={"C12_MSG7_HASH", "C14_MSG7_HASH", "C15_MSG7_HASH"})
        public void setGivenHash() throws SAXParseException {
            CC7SP.setGivenHash((HashHolder)((Object)this.sub), this.getString(), this.locator);
        }

        @SmartDefaultHandler.Callback(value={"P712_DOCUMENT", "P719_DOCUMENT", "P719_5_DOCUMENT"})
        public SmartDefaultHandler startPainDocument(Attributes atts) {
            this.documentNamespace = this.getPath().getUri();
            return this.sub;
        }

        @SmartDefaultHandler.Callback(value={"P712_DOCUMENT", "P719_DOCUMENT", "P719_5_DOCUMENT"})
        public void endPainDocument() {
            this.ticket.getSingleTickets().add((CC7SingleTicket)this.sub.getMessage());
        }

        @SmartDefaultHandler.Callback(value={"C12_MSG7", "C14_MSG7", "C15_MSG7"})
        public void endMsg007() {
            ((HashHolder)((Object)this.sub)).setGivenHash(null);
        }

        static {
            SmartDefaultHandler.Path p719Document = C07DisplayMessageGenerator.P719_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p719Document.getUri());
            SmartDefaultHandler.Path conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.GBIC5", "conxml");
            C15_MSG7 = new SmartDefaultHandler.Path(conxml, "MsgPain007");
            C15_MSG7_HASH = new SmartDefaultHandler.Path(C15_MSG7, "HashValue");
            P719_5_DOCUMENT = p719Document.prefixPath(C15_MSG7);
            p719Document = C07DisplayMessageGenerator.P719_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p719Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.GBIC4", "conxml");
            C14_MSG7 = new SmartDefaultHandler.Path(conxml, "MsgPain007");
            C14_MSG7_HASH = new SmartDefaultHandler.Path(C14_MSG7, "HashValue");
            P719_DOCUMENT = p719Document.prefixPath(C14_MSG7);
            SmartDefaultHandler.Path p712Document = C07DisplayMessageGenerator.P712_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p712Document.getUri());
            conxml = new SmartDefaultHandler.Path(null, "urn:conxml:xsd:container.nnn.001.02", "conxml");
            C12_MSG7 = new SmartDefaultHandler.Path(conxml, "MsgPain007");
            C12_MSG7_HASH = new SmartDefaultHandler.Path(C12_MSG7, "HashValue");
            P712_DOCUMENT = p712Document.prefixPath(C12_MSG7);
        }
    }

    public static class CC7SingleTicketGenerator
    extends C07DisplayMessageGenerator
    implements HashHolder {
        byte[] givenHash;

        @Override
        protected C07Ticket mkTicket() {
            return new CC7SingleTicket(this.givenHash);
        }

        @Override
        public byte[] getGivenHash() {
            return this.givenHash;
        }

        @Override
        public void setGivenHash(byte[] hash) {
            this.givenHash = hash;
        }
    }
}

