/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.C07SingleTicket;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class C07Ticket
extends AbstractDisplayMessage {
    private static final long serialVersionUID = 1L;
    String messageIdentification;
    Date creationDateTime;
    long hdrNbOfRvls = 0L;
    BigDecimal hdrCtrlSum = BigDecimal.ZERO;
    String initiatorName;
    String initiatorId;
    String originalMessageIdentification;
    boolean groupReversal = false;
    List<C07SingleTicket> singleTickets = new ArrayList<C07SingleTicket>();

    public List<C07SingleTicket> getSingleTickets() {
        return this.singleTickets;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public int getNumberOfReversalDetails() {
        return this.singleTickets.size();
    }

    public long getNumberOfReversals() {
        if (this.singleTickets.isEmpty()) {
            return this.hdrNbOfRvls;
        }
        return this.getNumberOfReversalDetails();
    }

    public BigDecimal getTotalAmountOfReversalDetails() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (C07SingleTicket t : this.singleTickets) {
            totalAmount = totalAmount.add(t.getCtrlSum());
        }
        return totalAmount;
    }

    public BigDecimal getTotalAmountOfReversals() {
        if (this.singleTickets.isEmpty()) {
            return this.hdrCtrlSum;
        }
        return this.getTotalAmountOfReversalDetails();
    }

    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (C07SingleTicket t : this.singleTickets) {
            totalNumber += t.getNumberOfReversals();
        }
        return totalNumber;
    }

    protected void append(AbstractDisplayMessage message) {
        message.mainSeparator();
        message.calculateKeyWidth("FILE_ID", "TIMESTAMP", "INITIATOR_NAME", "INITIATOR_ID", "NB_OF_RVSL", "CTRL_SUM");
        message.buffer.append("     ").append(message.bundle.getString("DEBIT_REVERSAL"));
        message.buffer.append("\r\n");
        if (this.groupReversal) {
            message.buffer.append("     ").append(message.bundle.getString("GRP_RVSL"));
            message.buffer.append("\r\n");
        }
        message.writeKeyValue("FILE_ID", this.messageIdentification);
        message.writeDate("TIMESTAMP", "TIMESTAMP_FORMAT", this.creationDateTime);
        message.writeKeyValue("INITIATOR_NAME", this.initiatorName);
        message.writeKeyValue("INITIATOR_ID", this.initiatorId);
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(message.locale));
        message.writeKeyValue("NB_OF_RVSL", Long.toString(this.getNumberOfReversals()));
        message.writeKeyValue("CTRL_SUM", df.format(this.getTotalAmountOfReversals()));
        message.keyWidth = 0;
        for (C07SingleTicket t : this.singleTickets) {
            if (message.keyWidth == 0) {
                t.calculateKeyWidth(message);
            }
            t.append(message);
        }
    }

    @Override
    protected void append() {
        this.append(this);
        this.mainSeparator();
    }
}

