/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;

public class C07SingleTicket
implements Serializable {
    private static final long serialVersionUID = 1L;
    String originalPaymentInformationIdentification;
    Date originalRequestedCollectionDate;
    BigDecimal orgnlCtrlSum = BigDecimal.ZERO;
    long orgnlNbOfTxs;
    String creditorName;
    String creditorAccount;
    String creditorAccountCcy;
    String creditorBIC;
    BigDecimal ctrlSum = BigDecimal.ZERO;
    long numberOfReversals;

    public String getOriginalPaymentInformationIdentification() {
        return this.originalPaymentInformationIdentification;
    }

    public Date getOriginalRequestedCollectionDate() {
        return this.originalRequestedCollectionDate;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public String getCreditorAccount() {
        return this.creditorAccount;
    }

    public Currency getCreditorAccountCcy() {
        return Currency.getInstance(this.creditorAccountCcy);
    }

    public String getCreditorBIC() {
        return this.creditorBIC;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum.compareTo(BigDecimal.ZERO) == 0 ? this.orgnlCtrlSum : this.ctrlSum;
    }

    public long getNumberOfReversals() {
        return this.numberOfReversals > 0L ? this.numberOfReversals : this.orgnlNbOfTxs;
    }

    protected void append(AbstractDisplayMessage message) {
        message.minorSeparator();
        message.writeKeyValue("PMT_INF_ID", this.originalPaymentInformationIdentification);
        message.writeKeyValue("BANK_CODE", this.creditorBIC);
        message.writeKeyValue("ACCOUNT_NUMBER", this.creditorAccount);
        message.writeKeyValue("ORIGINATOR2", this.creditorName);
        message.writeKeyValue("NB_OF_RVSL", Long.toString(this.getNumberOfReversals()));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(message.locale));
        message.writeKeyValue("CTRL_SUM", df.format(this.getCtrlSum()));
        message.writeDate("COLLECTION_DATE", "DATE_FORMAT", this.originalRequestedCollectionDate);
    }

    public void calculateKeyWidth(AbstractDisplayMessage message) {
        message.calculateKeyWidth("PMT_INF_ID", "BANK_CODE", "ACCOUNT_NUMBER", "ORIGINATOR2", "NB_OF_RVSL", "CTRL_SUM", "COLLECTION_DATE");
    }
}

