/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.C07SingleTicket;
import de.businesslogics.format.ticket.C07Ticket;
import de.businesslogics.format.ticket.CtrlSumException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.NbOfTxsException;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.InputStream;
import java.math.BigDecimal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class C07DisplayMessageGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P719_MSG_ID;
    public static final SmartDefaultHandler.Path P719_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P719_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P719_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P719_GRP_RVSL;
    public static final SmartDefaultHandler.Path P719_INITG_NM;
    public static final SmartDefaultHandler.Path P719_INITG_ORG_ID;
    public static final SmartDefaultHandler.Path P719_INITG_PRVT_ID;
    public static final SmartDefaultHandler.Path P719_ORGNL_MSG_ID;
    public static final SmartDefaultHandler.Path P719_PMT_INF;
    public static final SmartDefaultHandler.Path P719_ORGNL_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P719_ORGNL_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P719_ORGNL_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P719_ORGNL_TX_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P719_ORGNL_TX_CDTR_NM;
    public static final SmartDefaultHandler.Path P719_ORGNL_TX_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P719_ORGNL_TX_CDTR_CUR;
    public static final SmartDefaultHandler.Path P719_ORGNL_TX_CDTR_BIC;
    public static final SmartDefaultHandler.Path P719_ORGNL_TX_INSTD_AMT;
    public static final SmartDefaultHandler.Path P719_RVSD_TX_INSTD_AMT;
    public static final SmartDefaultHandler.Path P712_MSG_ID;
    public static final SmartDefaultHandler.Path P712_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P712_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P712_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P712_GRP_RVSL;
    public static final SmartDefaultHandler.Path P712_INITG_NM;
    public static final SmartDefaultHandler.Path P712_INITG_ORG_ID;
    public static final SmartDefaultHandler.Path P712_INITG_PRVT_ID;
    public static final SmartDefaultHandler.Path P712_ORGNL_MSG_ID;
    public static final SmartDefaultHandler.Path P712_PMT_INF;
    public static final SmartDefaultHandler.Path P712_ORGNL_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P712_ORGNL_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P712_ORGNL_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P712_ORGNL_TX_REQD_COLLTN_DT;
    public static final SmartDefaultHandler.Path P712_ORGNL_TX_CDTR_NM;
    public static final SmartDefaultHandler.Path P712_ORGNL_TX_CDTR_IBAN;
    public static final SmartDefaultHandler.Path P712_ORGNL_TX_CDTR_CUR;
    public static final SmartDefaultHandler.Path P712_ORGNL_TX_CDTR_BIC;
    public static final SmartDefaultHandler.Path P712_ORGNL_TX_INSTD_AMT;
    public static final SmartDefaultHandler.Path P712_RVSD_TX_INSTD_AMT;
    protected C07Ticket ticket;
    private boolean forceDetails;
    private boolean dk39 = true;
    private boolean dk37 = true;
    private boolean dk31 = true;
    private C07SingleTicket currentTicket;
    private String namespace;
    private boolean isFirstTx = true;
    private boolean orgnlCtrlSumSeen = false;

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public C07Ticket getMessage(InputStream in) throws Exception {
        this.parse(in);
        return this.ticket;
    }

    public C07Ticket getMessage() {
        return this.ticket;
    }

    public boolean isForceDetails() {
        return this.forceDetails;
    }

    public void setForceDetails(boolean forceDetails) {
        this.forceDetails = forceDetails;
    }

    public boolean isDk39() {
        return this.dk39;
    }

    public void setDk39(boolean dk39) {
        this.dk39 = dk39;
    }

    public boolean isDk37() {
        return this.dk37;
    }

    public void setDk37(boolean dk37) {
        this.dk37 = dk37;
    }

    public boolean isDk31() {
        return this.dk31;
    }

    public void setDk31(boolean dk31) {
        this.dk31 = dk31;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.ticket = this.mkTicket();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.forceDetails) {
            if (this.ticket.getNumberOfReversalDetails() == 0) {
                this.error(new NbOfTxsException("No details found (expected " + this.ticket.hdrNbOfRvls + ")", this.locator));
            }
            if ((long)this.ticket.getNumberOfReversalDetails() != this.ticket.hdrNbOfRvls) {
                this.error(new NbOfTxsException("Wrong number of details (expected " + this.ticket.hdrNbOfRvls + ")", this.locator));
            }
            if (this.forceDetails && this.ticket.hdrCtrlSum.compareTo(this.ticket.getTotalAmountOfReversalDetails()) != 0) {
                this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.ticket.hdrCtrlSum) + ")", this.locator));
            }
        }
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        StringBuilder sb = new StringBuilder();
        if (this.dk37) {
            C07DisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.007.001.09", "/de/businesslogics/format/dk37/pain.007.001.09_GBIC_4.xsd");
        } else if (this.dk39) {
            C07DisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.007.001.09", "/de/businesslogics/format/dk39/pain.007.001.09_GBIC_5.xsd");
        }
        if (this.dk31) {
            C07DisplayMessageGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.007.001.02", "/de/businesslogics/format/dk31/pain.007.001.02_GBIC_2.xsd");
        }
        return C07DisplayMessageGenerator.finishNamespaceSchemaLocations(sb);
    }

    @SmartDefaultHandler.Callback(value={"P719_MSG_ID", "P712_MSG_ID"})
    public void setMsgId() {
        this.namespace = this.getPath().getUri();
        this.ticket.messageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_CRE_DT_TM", "P712_CRE_DT_TM"})
    public void setCreDtTm() throws SAXParseException {
        this.ticket.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P719_HDR_NB_OF_TXS", "P712_HDR_NB_OF_TXS"})
    public void setHdrNbOfRvls() throws SAXParseException {
        this.ticket.hdrNbOfRvls = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P719_HDR_CTRL_SUM", "P712_HDR_CTRL_SUM"})
    public void setHdrCtrlSum() throws SAXParseException {
        this.ticket.hdrCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P719_GRP_RVSL", "P712_GRP_RVSL"})
    public void setGrpRvsl() throws SAXParseException {
        this.ticket.groupReversal = this.getBoolean();
    }

    @SmartDefaultHandler.Callback(value={"P719_INITG_NM", "P712_INITG_NM"})
    public void setInitgNm() {
        this.ticket.initiatorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_INITG_ORG_ID", "P712_INITG_ORG_ID"})
    public void setInitgOrgId() {
        this.ticket.initiatorId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_INITG_PRVT_ID", "P712_INITG_PRVT_ID"})
    public void setInitgPrvtId() {
        if (this.ticket.initiatorId == null) {
            this.ticket.initiatorId = this.getString();
        }
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_MSG_ID", "P712_ORGNL_MSG_ID"})
    public void setOrgnlMsgId() {
        this.ticket.originalMessageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_PMT_INF", "P712_PMT_INF"})
    public void startPmtInf(Attributes attributes) {
        this.currentTicket = new C07SingleTicket();
        this.ticket.singleTickets.add(this.currentTicket);
        this.isFirstTx = true;
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_PMT_NB_OF_TXS", "P712_ORGNL_PMT_NB_OF_TXS"})
    public void setOrgnlNbOfTxs() throws SAXParseException {
        this.currentTicket.orgnlNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_PMT_CTRL_SUM", "P712_ORGNL_PMT_CTRL_SUM"})
    public void setOrgnlCtrlSum() throws SAXParseException {
        this.currentTicket.orgnlCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_PMT_INF_ID", "P712_ORGNL_PMT_INF_ID"})
    public void setPmtInfId() {
        this.currentTicket.originalPaymentInformationIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_TX_REQD_COLLTN_DT", "P712_ORGNL_TX_REQD_COLLTN_DT"})
    public void setReqdColltnDt() throws SAXParseException {
        this.currentTicket.originalRequestedCollectionDate = this.getDate();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_TX_CDTR_NM", "P712_ORGNL_TX_CDTR_NM"})
    public void setCdtrNm() {
        this.currentTicket.creditorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_TX_CDTR_IBAN", "P712_ORGNL_TX_CDTR_IBAN"})
    public void setCdtrIban() {
        this.currentTicket.creditorAccount = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_TX_CDTR_CUR", "P712_ORGNL_TX_CDTR_CUR"})
    public void setCdtrAcctCcy() {
        this.currentTicket.creditorAccountCcy = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_TX_CDTR_BIC", "P712_ORGNL_TX_CDTR_BIC"})
    public void setCdtrBic() {
        this.currentTicket.creditorBIC = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P719_ORGNL_TX_INSTD_AMT", "P712_ORGNL_TX_INSTD_AMT"})
    public void handleOrgnlTxAmount() throws SAXParseException {
        if (this.isFirstTx) {
            this.currentTicket.orgnlCtrlSum = BigDecimal.ZERO;
            this.currentTicket.orgnlNbOfTxs = 0L;
            this.isFirstTx = false;
        }
        this.currentTicket.orgnlCtrlSum = this.currentTicket.orgnlCtrlSum.add(this.getDecimal());
        ++this.currentTicket.orgnlNbOfTxs;
    }

    @SmartDefaultHandler.Callback(value={"P719_RVSD_TX_INSTD_AMT", "P712_RVSD_TX_INSTD_AMT"})
    public void handleRvsdTxAmount() throws SAXParseException {
        this.currentTicket.ctrlSum = this.currentTicket.ctrlSum.add(this.getDecimal());
        ++this.currentTicket.numberOfReversals;
    }

    protected C07Ticket mkTicket() {
        return new C07Ticket();
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.007.001.09", "Document");
        SmartDefaultHandler.Path cstmrPmtRvsl = new SmartDefaultHandler.Path(document, "CstmrPmtRvsl");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrPmtRvsl, "GrpHdr");
        P719_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P719_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P719_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P719_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        P719_GRP_RVSL = new SmartDefaultHandler.Path(grpHdr, "GrpRvsl");
        SmartDefaultHandler.Path initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P719_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(initgPty, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P719_INITG_ORG_ID = new SmartDefaultHandler.Path(othr, "Id");
        SmartDefaultHandler.Path prvtId = new SmartDefaultHandler.Path(id, "PrvtId");
        SmartDefaultHandler.Path othr2 = new SmartDefaultHandler.Path(prvtId, "Othr");
        P719_INITG_PRVT_ID = new SmartDefaultHandler.Path(othr2, "Id");
        SmartDefaultHandler.Path orgnlGrpInf = new SmartDefaultHandler.Path(cstmrPmtRvsl, "OrgnlGrpInf");
        P719_ORGNL_MSG_ID = new SmartDefaultHandler.Path(orgnlGrpInf, "OrgnlMsgId");
        P719_PMT_INF = new SmartDefaultHandler.Path(cstmrPmtRvsl, "OrgnlPmtInfAndRvsl");
        P719_ORGNL_PMT_INF_ID = new SmartDefaultHandler.Path(P719_PMT_INF, "OrgnlPmtInfId");
        P719_ORGNL_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P719_PMT_INF, "OrgnlNbOfTxs");
        P719_ORGNL_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P719_PMT_INF, "OrgnlCtrlSum");
        SmartDefaultHandler.Path txInf = new SmartDefaultHandler.Path(P719_PMT_INF, "TxInf");
        P719_ORGNL_TX_INSTD_AMT = new SmartDefaultHandler.Path(txInf, "OrgnlInstdAmt");
        P719_RVSD_TX_INSTD_AMT = new SmartDefaultHandler.Path(txInf, "RvsdInstdAmt");
        SmartDefaultHandler.Path orgnlTxRef = new SmartDefaultHandler.Path(txInf, "OrgnlTxRef");
        P719_ORGNL_TX_REQD_COLLTN_DT = new SmartDefaultHandler.Path(orgnlTxRef, "ReqdColltnDt");
        SmartDefaultHandler.Path cdtr = new SmartDefaultHandler.Path(orgnlTxRef, "Cdtr");
        SmartDefaultHandler.Path pty = new SmartDefaultHandler.Path(cdtr, "Pty");
        P719_ORGNL_TX_CDTR_NM = new SmartDefaultHandler.Path(pty, "Nm");
        SmartDefaultHandler.Path cdtrAcct = new SmartDefaultHandler.Path(orgnlTxRef, "CdtrAcct");
        SmartDefaultHandler.Path crdtAcctId = new SmartDefaultHandler.Path(cdtrAcct, "Id");
        P719_ORGNL_TX_CDTR_IBAN = new SmartDefaultHandler.Path(crdtAcctId, "IBAN");
        P719_ORGNL_TX_CDTR_CUR = new SmartDefaultHandler.Path(cdtrAcct, "Ccy");
        SmartDefaultHandler.Path cdtrAgt = new SmartDefaultHandler.Path(orgnlTxRef, "CdtrAgt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(cdtrAgt, "FinInstnId");
        P719_ORGNL_TX_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.007.001.02", "Document");
        cstmrPmtRvsl = new SmartDefaultHandler.Path(document, "CstmrPmtRvsl");
        grpHdr = new SmartDefaultHandler.Path(cstmrPmtRvsl, "GrpHdr");
        P712_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P712_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P712_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P712_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        P712_GRP_RVSL = new SmartDefaultHandler.Path(grpHdr, "GrpRvsl");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P712_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P712_INITG_ORG_ID = new SmartDefaultHandler.Path(othr, "Id");
        prvtId = new SmartDefaultHandler.Path(id, "PrvtId");
        othr2 = new SmartDefaultHandler.Path(prvtId, "Othr");
        P712_INITG_PRVT_ID = new SmartDefaultHandler.Path(othr2, "Id");
        orgnlGrpInf = new SmartDefaultHandler.Path(cstmrPmtRvsl, "OrgnlGrpInf");
        P712_ORGNL_MSG_ID = new SmartDefaultHandler.Path(orgnlGrpInf, "OrgnlMsgId");
        P712_PMT_INF = new SmartDefaultHandler.Path(cstmrPmtRvsl, "OrgnlPmtInfAndRvsl");
        P712_ORGNL_PMT_INF_ID = new SmartDefaultHandler.Path(P712_PMT_INF, "OrgnlPmtInfId");
        P712_ORGNL_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P712_PMT_INF, "OrgnlNbOfTxs");
        P712_ORGNL_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P712_PMT_INF, "OrgnlCtrlSum");
        txInf = new SmartDefaultHandler.Path(P712_PMT_INF, "TxInf");
        P712_ORGNL_TX_INSTD_AMT = new SmartDefaultHandler.Path(txInf, "OrgnlInstdAmt");
        P712_RVSD_TX_INSTD_AMT = new SmartDefaultHandler.Path(txInf, "RvsdInstdAmt");
        orgnlTxRef = new SmartDefaultHandler.Path(txInf, "OrgnlTxRef");
        P712_ORGNL_TX_REQD_COLLTN_DT = new SmartDefaultHandler.Path(orgnlTxRef, "ReqdColltnDt");
        cdtr = new SmartDefaultHandler.Path(orgnlTxRef, "Cdtr");
        P712_ORGNL_TX_CDTR_NM = new SmartDefaultHandler.Path(cdtr, "Nm");
        cdtrAcct = new SmartDefaultHandler.Path(orgnlTxRef, "CdtrAcct");
        crdtAcctId = new SmartDefaultHandler.Path(cdtrAcct, "Id");
        P712_ORGNL_TX_CDTR_IBAN = new SmartDefaultHandler.Path(crdtAcctId, "IBAN");
        P712_ORGNL_TX_CDTR_CUR = new SmartDefaultHandler.Path(cdtrAcct, "Ccy");
        cdtrAgt = new SmartDefaultHandler.Path(orgnlTxRef, "CdtrAgt");
        finInstnId = new SmartDefaultHandler.Path(cdtrAgt, "FinInstnId");
        P712_ORGNL_TX_CDTR_BIC = new SmartDefaultHandler.Path(finInstnId, "BIC");
    }
}

