/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.FieldC7;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.Ticket;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDTAUSDisplayMessageGenerator
implements DisplayMessageGenerator {
    protected boolean isBBKFile = false;
    private boolean containsSalaryPayments = false;
    private List<DTAUSLogicalFile> logicalFiles = new ArrayList<DTAUSLogicalFile>();

    @Override
    public Ticket getMessage(InputStream in) throws Exception {
        this.logicalFiles.clear();
        OutputStream out = this.getExtractor(new MyDTAUSListener());
        Streams.copy(in, out);
        return new Ticket(this.isBBKFile, this.logicalFiles, this.containsSalaryPayments);
    }

    public abstract OutputStream getExtractor(DTAUSExtractor.DTAUSListener var1);

    private class MyDTAUSListener
    implements DTAUSExtractor.DTAUSListener {
        private MyDTAUSListener() {
        }

        @Override
        public void startLogicalFile(DTAUSLogicalFile logicalFile) {
        }

        @Override
        public void handleItem(DTAUSItem item) {
            if (FieldC7.isSalaryPayment(item.getTextKey())) {
                BaseDTAUSDisplayMessageGenerator.this.containsSalaryPayments = true;
            }
        }

        @Override
        public void endLogicalFile(DTAUSLogicalFile logicalFile) {
            BaseDTAUSDisplayMessageGenerator.this.logicalFiles.add(logicalFile);
        }

        @Override
        public void consumeError(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }

        @Override
        public void handleWarning(InvalidFileException ife) throws InvalidFileException {
            throw ife;
        }
    }
}

