/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ptk2.DisplayMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractDisplayMessage
implements DisplayMessage {
    public static final long serialVersionUID = 1L;
    protected transient StringBuilder buffer;
    protected transient ResourceBundle bundle;
    protected transient Locale locale;
    protected transient int keyWidth;

    @Override
    public void appendText(Locale _locale, StringBuilder _buffer) {
        this.buffer = _buffer;
        this.locale = _locale;
        this.bundle = ResourceBundle.getBundle(AbstractDisplayMessage.class.getName(), _locale);
        this.append();
    }

    protected abstract void append();

    public void mainSeparator() {
        this.buffer.append("    ================================================================").append("\r\n");
    }

    public void minorSeparator() {
        this.buffer.append("    ----------------------------------------------------------------").append("\r\n");
    }

    public void writeLine(String key) {
        this.buffer.append("     ").append(this.bundle.getString(key)).append("\r\n");
    }

    public void writeKeyValue(String bundleKey, String value) {
        if (value == null) {
            return;
        }
        this.writeRawKeyValue(this.bundle.getString(bundleKey), value);
    }

    public void writeRawKeyValue(String rawKey, String value) {
        if (value == null) {
            return;
        }
        this.buffer.append("     ").append(rawKey);
        int i = rawKey.length();
        assert (i <= this.keyWidth);
        while (i++ < this.keyWidth) {
            this.buffer.append(' ');
        }
        i = 70 - i;
        this.buffer.append(": ").append(value, 0, i < value.length() ? i : value.length()).append("\r\n");
    }

    protected void calculateKeyWidth(String ... keys) {
        this.keyWidth = 0;
        for (String key : keys) {
            this.enlargeKeyWidth(key);
        }
    }

    protected void enlargeKeyWidth(String key) {
        this.enlargeRawKeyWidth(this.bundle.getString(key));
    }

    protected void enlargeRawKeyWidth(String rawKey) {
        int l = rawKey.length();
        if (l >= this.keyWidth) {
            this.keyWidth = l + 1;
        }
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        this.appendText(Locale.getDefault(), toReturn);
        return toReturn.toString();
    }

    public void writeDate(String bundleKey, String dateFormatKey, Date date) {
        if (date == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.bundle.getString(dateFormatKey));
        this.writeKeyValue(bundleKey, sdf.format(date));
    }
}

