/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ticket.AbstractDisplayMessage;
import de.businesslogics.format.ticket.Pain00100103PaymentInstruction;
import de.businesslogics.format.ticket.Pain00100103Ticket;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ATTHMTicket
extends AbstractDisplayMessage {
    private static final long serialVersionUID = 1L;
    private List<Pain00100103Ticket> singleTickets = new ArrayList<Pain00100103Ticket>();

    public List<Pain00100103Ticket> getSingleTickets() {
        return this.singleTickets;
    }

    @Override
    public void append() {
        for (Pain00100103Ticket t : this.singleTickets) {
            t.append(this);
        }
        this.mainSeparator();
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Pain00100103Ticket t : this.singleTickets) {
            totalAmount = totalAmount.add(t.getTotalAmount());
        }
        return totalAmount;
    }

    public Currency getCurrency() {
        String currency = null;
        for (Pain00100103Ticket t : this.singleTickets) {
            if (currency != null) continue;
            for (Pain00100103PaymentInstruction p : t.getPayments()) {
                if (p.currencies.size() == 1) {
                    currency = p.currencies.firstKey();
                    continue;
                }
                return null;
            }
        }
        if (currency == null) {
            return null;
        }
        return Currency.getInstance(currency);
    }

    public int getTotalNumberOfPayments() {
        int total = 0;
        for (Pain00100103Ticket t : this.singleTickets) {
            total += (int)t.getTotalNumberOfPayments();
        }
        return total;
    }
}

