/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.bankrechner.SystemProperties;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.ticket.CcyException;
import de.businesslogics.format.ticket.CtrlSumException;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.MltplPmtTpInfException;
import de.businesslogics.format.ticket.NbOfTxsException;
import de.businesslogics.format.ticket.Pain00100103PaymentInstruction;
import de.businesslogics.format.ticket.Pain00100103Ticket;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ATTHMSingleTicketGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P119_MSG_ID;
    public static final SmartDefaultHandler.Path P119_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P119_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P119_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path P119_INITG_NM;
    public static final SmartDefaultHandler.Path P119_INITG_ID;
    public static final SmartDefaultHandler.Path P119_PMT_INF;
    public static final SmartDefaultHandler.Path P119_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P119_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path P119_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path P119_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P119_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path P119_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path P119_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P119_PMT_REQD_EXCTN_DT_TM;
    public static final SmartDefaultHandler.Path P119_DBTR_NM;
    public static final SmartDefaultHandler.Path P119_DBTR_IBAN;
    public static final SmartDefaultHandler.Path P119_DBTR_BICFI;
    public static final SmartDefaultHandler.Path P119_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path P119_ULTMT_DBTR_ID;
    public static final SmartDefaultHandler.Path P119_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path P119_TX_PMT_TP_INF;
    public static final SmartDefaultHandler.Path P119_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path P119_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path P119_INSTD_AMT;
    public static final SmartDefaultHandler.Path P119_PURP;
    public static final SmartDefaultHandler.Path _P119_MSG_ID;
    public static final SmartDefaultHandler.Path _P119_CRE_DT_TM;
    public static final SmartDefaultHandler.Path _P119_HDR_NB_OF_TXS;
    public static final SmartDefaultHandler.Path _P119_HDR_CTRL_SUM;
    public static final SmartDefaultHandler.Path _P119_INITG_NM;
    public static final SmartDefaultHandler.Path _P119_INITG_ID;
    public static final SmartDefaultHandler.Path _P119_PMT_INF;
    public static final SmartDefaultHandler.Path _P119_PMT_INF_ID;
    public static final SmartDefaultHandler.Path _P119_PMT_NB_OF_TXS;
    public static final SmartDefaultHandler.Path _P119_PMT_CTRL_SUM;
    public static final SmartDefaultHandler.Path _P119_PMT_TP_INF;
    public static final SmartDefaultHandler.Path _P119_PMT_SVC_LVL;
    public static final SmartDefaultHandler.Path _P119_PMT_CTGY_PURP;
    public static final SmartDefaultHandler.Path _P119_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path _P119_PMT_REQD_EXCTN_DT_TM;
    public static final SmartDefaultHandler.Path _P119_DBTR_NM;
    public static final SmartDefaultHandler.Path _P119_DBTR_IBAN;
    public static final SmartDefaultHandler.Path _P119_DBTR_BICFI;
    public static final SmartDefaultHandler.Path _P119_DBTR_ACCT_CCY;
    public static final SmartDefaultHandler.Path _P119_ULTMT_DBTR_ID;
    public static final SmartDefaultHandler.Path _P119_CDT_TRF_TX_INF;
    public static final SmartDefaultHandler.Path _P119_TX_PMT_TP_INF;
    public static final SmartDefaultHandler.Path _P119_TX_SVC_LVL;
    public static final SmartDefaultHandler.Path _P119_TX_CTGY_PURP;
    public static final SmartDefaultHandler.Path _P119_INSTD_AMT;
    public static final SmartDefaultHandler.Path _P119_PURP;
    protected Pain00100103Ticket ticket;
    private Pain00100103PaymentInstruction currentTicket;
    private Integer pmtNbOfTxs;
    private long hdrNbOfTxs;
    private BigDecimal hdrCtrlSum;
    private BigDecimal pmtCtrlSum;
    private String namespace;
    private boolean pmtTpInfSeen = false;
    private boolean pmtSvcLvlSeen = false;
    private boolean txSvcLvlSeen = false;
    private String ccy;

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    protected boolean requireXsd11() {
        return true;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.ticket = this.mkTicket();
        this.currentTicket = null;
        this.hdrNbOfTxs = 0L;
        this.hdrCtrlSum = null;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.ticket.getTotalNumberOfPayments() != this.hdrNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.ticket.getTotalNumberOfPayments() + ")", this.locator));
        }
        if (this.hdrCtrlSum != null && this.hdrCtrlSum.compareTo(this.ticket.getTotalAmount()) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.ticket.getTotalAmount()) + ")", this.locator));
        }
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        StringBuilder toReturn = new StringBuilder();
        this.addNamespaceSchemaLocations(toReturn);
        return ATTHMSingleTicketGenerator.finishNamespaceSchemaLocations(toReturn);
    }

    protected void addNamespaceSchemaLocations(StringBuilder sb) {
        ATTHMSingleTicketGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "/de/businesslogics/format/stuzza/rb2023/ISO.pain.001.001.09.austrian.004.xsd");
        ATTHMSingleTicketGenerator.appendNamespaceSchemaLocation(sb, "urn:iso:std:iso:20022:tech:xsd:pain.001.101.09", "/de/businesslogics/format/stuzza/rb2023/ISO.pain.001.101.09.austrian.005.N.THM.xsd");
    }

    @SmartDefaultHandler.Callback(value={"P119_MSG_ID", "_P119_MSG_ID"})
    public void setMsgId() {
        this.namespace = this.getPath().getUri();
        this.ticket.messageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_CRE_DT_TM", "_P119_CRE_DT_TM"})
    public void setCreDtTm() throws SAXParseException {
        this.ticket.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P119_HDR_NB_OF_TXS", "_P119_HDR_NB_OF_TXS"})
    public void setHdrNbOfTxs() throws SAXParseException {
        this.hdrNbOfTxs = this.getLong();
    }

    @SmartDefaultHandler.Callback(value={"P119_HDR_CTRL_SUM", "_P119_HDR_CTRL_SUM"})
    public void setHdrCtrlSum() throws SAXParseException {
        this.hdrCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P119_INITG_NM", "_P119_INITG_NM"})
    public void setInitiatorName() {
        this.ticket.initiatorName = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_INITG_ID", "_P119_INITG_ID"})
    public void setInitiatorId() {
        this.ticket.initiatorId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_CTGY_PURP", "P119_TX_CTGY_PURP", "P119_PURP", "_P119_PMT_CTGY_PURP", "_P119_TX_CTGY_PURP", "_P119_PURP"})
    public void handleCtgyPurp() {
        String s = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_INF", "_P119_PMT_INF"})
    public void startPmtInf(Attributes attributes) {
        this.currentTicket = new Pain00100103PaymentInstruction();
        this.ticket.payments.add(this.currentTicket);
        this.pmtNbOfTxs = null;
        this.pmtCtrlSum = null;
        this.pmtSvcLvlSeen = false;
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_TP_INF", "_P119_PMT_TP_INF"})
    public void handlePmtTpInf() {
        this.pmtTpInfSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_INF", "_P119_PMT_INF"})
    public void endPmtInf() throws SAXException {
        if (this.pmtNbOfTxs != null && this.currentTicket.numberOfPayments != this.pmtNbOfTxs) {
            this.error(new NbOfTxsException("Wrong number of payments (expected " + this.currentTicket.numberOfPayments + ")", this.locator));
        }
        if (this.pmtCtrlSum != null && this.pmtCtrlSum.compareTo(this.currentTicket.ctrlSum) != 0) {
            this.error(new CtrlSumException("Wrong control sum (expected " + String.valueOf(this.currentTicket.ctrlSum) + ")", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_INF_ID", "_P119_PMT_INF_ID"})
    public void setPmtInfId() {
        this.currentTicket.pmtInfId = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_NB_OF_TXS", "_P119_PMT_NB_OF_TXS"})
    public void setPmtNbOfTxs() throws SAXParseException {
        this.pmtNbOfTxs = this.getInt();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_CTRL_SUM", "_P119_PMT_CTRL_SUM"})
    public void setPmtCtrlSum() throws SAXParseException {
        this.pmtCtrlSum = this.getDecimal();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_SVC_LVL", "_P119_PMT_SVC_LVL"})
    public void setPmtSvcLvl() {
        this.ticket.serviceLevel = this.getString();
        this.pmtSvcLvlSeen = true;
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_REQD_EXCTN_DT", "_P119_PMT_REQD_EXCTN_DT"})
    public void setReqdExctnDt() throws SAXParseException {
        this.currentTicket.reqdExctnDt = this.getDate();
    }

    @SmartDefaultHandler.Callback(value={"P119_PMT_REQD_EXCTN_DT_TM", "_P119_PMT_REQD_EXCTN_DT_TM"})
    public void setReqdExctnDtTm() throws SAXParseException {
        this.currentTicket.reqdExctnDt = new YYMMDD(this.getDateTime().getTime());
    }

    @SmartDefaultHandler.Callback(value={"P119_DBTR_NM", "_P119_DBTR_NM"})
    public void setDbtrNm() {
        this.currentTicket.dbtrNm = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_DBTR_IBAN", "_P119_DBTR_IBAN"})
    public void setDbtrIban() {
        this.currentTicket.dbtrAcct = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_DBTR_BICFI", "_P119_DBTR_BICFI"})
    public void setDbtrBic() {
        this.currentTicket.dbtrAgt = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_DBTR_ACCT_CCY", "_P119_DBTR_ACCT_CCY"})
    public void setDbtrAcctCcy() {
        this.currentTicket.debitorAccountCcy = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P119_ULTMT_DBTR_ID", "_P119_ULTMT_DBTR_ID"})
    public void setAlternativeIban() {
    }

    @SmartDefaultHandler.Callback(value={"P119_CDT_TRF_TX_INF", "_P119_CDT_TRF_TX_INF"})
    public void startCdtTrfTxInf(Attributes attributes) {
        this.txSvcLvlSeen = this.pmtSvcLvlSeen;
    }

    @SmartDefaultHandler.Callback(value={"P119_TX_PMT_TP_INF", "_P119_TX_PMT_TP_INF"})
    public void handleTxPmtTpInf() throws SAXException {
        if (this.pmtTpInfSeen) {
            this.error(new MltplPmtTpInfException("Payment type information already defined at batch level.", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"P119_TX_SVC_LVL", "_P119_TX_SVC_LVL"})
    public void setTxSvcLvl() {
        this.txSvcLvlSeen = true;
        if (this.ticket.serviceLevel != null) {
            String s = this.getString();
            if (this.ticket.serviceLevel.length() == 0) {
                this.ticket.serviceLevel = s;
            } else if (!s.equals(this.ticket.serviceLevel)) {
                this.ticket.serviceLevel = null;
            }
        }
    }

    @SmartDefaultHandler.Callback(value={"P119_INSTD_AMT"})
    public void startInstdAmt(Attributes attributes) throws SAXException {
        this.ccy = attributes.getValue("Ccy");
        if (this.ccy != null && !"EUR".equals(this.ccy)) {
            this.error(new CcyException("Wrong currency " + this.ccy + " in Instructed Amount. Only EUR is allowed.", this.locator));
        }
    }

    @SmartDefaultHandler.Callback(value={"_P119_INSTD_AMT"})
    public void startInstdAmtNonEUR(Attributes attributes) throws SAXException {
        this.ccy = attributes.getValue("Ccy");
    }

    @SmartDefaultHandler.Callback(value={"P119_INSTD_AMT", "_P119_INSTD_AMT"})
    public void handleAmount() throws SAXParseException {
        this.currentTicket.add(this.ccy, this.getDecimal());
    }

    @Override
    public Pain00100103Ticket getMessage(InputStream in) throws IOException, SAXException {
        this.parse(in);
        return this.ticket;
    }

    public Pain00100103Ticket getMessage() {
        return this.ticket;
    }

    protected Pain00100103Ticket mkTicket() {
        return new Pain00100103Ticket();
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        boolean enableMltplPmtTpInf = SystemProperties.isCustomerCreditMultiplePaymentTypeInformation();
        boolean isMltplPmtTpInfException = e instanceof MltplPmtTpInfException;
        if (!isMltplPmtTpInfException || isMltplPmtTpInfException && !enableMltplPmtTpInf) {
            super.error(e);
        }
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "Document");
        SmartDefaultHandler.Path cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P119_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P119_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        P119_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        P119_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        SmartDefaultHandler.Path initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        P119_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(initgPty, "Id");
        SmartDefaultHandler.Path orgId = new SmartDefaultHandler.Path(id, "OrgId");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(orgId, "Othr");
        P119_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        P119_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P119_PMT_INF_ID = new SmartDefaultHandler.Path(P119_PMT_INF, "PmtInfId");
        P119_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(P119_PMT_INF, "NbOfTxs");
        P119_PMT_CTRL_SUM = new SmartDefaultHandler.Path(P119_PMT_INF, "CtrlSum");
        P119_PMT_TP_INF = new SmartDefaultHandler.Path(P119_PMT_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl = new SmartDefaultHandler.Path(P119_PMT_TP_INF, "SvcLvl");
        P119_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        SmartDefaultHandler.Path ctgyPurp = new SmartDefaultHandler.Path(P119_PMT_TP_INF, "CtgyPurp");
        P119_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp, "Cd");
        SmartDefaultHandler.Path reqdExctnDt = new SmartDefaultHandler.Path(P119_PMT_INF, "ReqdExctnDt");
        P119_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(reqdExctnDt, "Dt");
        P119_PMT_REQD_EXCTN_DT_TM = new SmartDefaultHandler.Path(reqdExctnDt, "DtTm");
        SmartDefaultHandler.Path dbtr = new SmartDefaultHandler.Path(P119_PMT_INF, "Dbtr");
        P119_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        SmartDefaultHandler.Path dbtrAcct = new SmartDefaultHandler.Path(P119_PMT_INF, "DbtrAcct");
        SmartDefaultHandler.Path id2 = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        P119_DBTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        P119_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct, "Ccy");
        SmartDefaultHandler.Path dbtrAgt = new SmartDefaultHandler.Path(P119_PMT_INF, "DbtrAgt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        P119_DBTR_BICFI = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        SmartDefaultHandler.Path ultmtDbtr = new SmartDefaultHandler.Path(P119_PMT_INF, "UltmtDbtr");
        SmartDefaultHandler.Path id3 = new SmartDefaultHandler.Path(ultmtDbtr, "Id");
        SmartDefaultHandler.Path orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        SmartDefaultHandler.Path othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        P119_ULTMT_DBTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        P119_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(P119_PMT_INF, "CdtTrfTxInf");
        P119_TX_PMT_TP_INF = new SmartDefaultHandler.Path(P119_CDT_TRF_TX_INF, "PmtTpInf");
        SmartDefaultHandler.Path svcLvl2 = new SmartDefaultHandler.Path(P119_TX_PMT_TP_INF, "SvcLvl");
        P119_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        SmartDefaultHandler.Path ctgyPurp2 = new SmartDefaultHandler.Path(P119_TX_PMT_TP_INF, "CtgyPurp");
        P119_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp2, "Cd");
        SmartDefaultHandler.Path amt = new SmartDefaultHandler.Path(P119_CDT_TRF_TX_INF, "Amt");
        P119_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        SmartDefaultHandler.Path purp = new SmartDefaultHandler.Path(P119_CDT_TRF_TX_INF, "Purp");
        P119_PURP = new SmartDefaultHandler.Path(purp, "Cd");
        document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.101.09", "Document");
        cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        _P119_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        _P119_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        _P119_HDR_NB_OF_TXS = new SmartDefaultHandler.Path(grpHdr, "NbOfTxs");
        _P119_HDR_CTRL_SUM = new SmartDefaultHandler.Path(grpHdr, "CtrlSum");
        initgPty = new SmartDefaultHandler.Path(grpHdr, "InitgPty");
        _P119_INITG_NM = new SmartDefaultHandler.Path(initgPty, "Nm");
        id = new SmartDefaultHandler.Path(initgPty, "Id");
        orgId = new SmartDefaultHandler.Path(id, "OrgId");
        othr = new SmartDefaultHandler.Path(orgId, "Othr");
        _P119_INITG_ID = new SmartDefaultHandler.Path(othr, "Id");
        _P119_PMT_INF = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        _P119_PMT_INF_ID = new SmartDefaultHandler.Path(_P119_PMT_INF, "PmtInfId");
        _P119_PMT_NB_OF_TXS = new SmartDefaultHandler.Path(_P119_PMT_INF, "NbOfTxs");
        _P119_PMT_CTRL_SUM = new SmartDefaultHandler.Path(_P119_PMT_INF, "CtrlSum");
        _P119_PMT_TP_INF = new SmartDefaultHandler.Path(_P119_PMT_INF, "PmtTpInf");
        svcLvl = new SmartDefaultHandler.Path(_P119_PMT_TP_INF, "SvcLvl");
        _P119_PMT_SVC_LVL = new SmartDefaultHandler.Path(svcLvl, "Cd");
        ctgyPurp = new SmartDefaultHandler.Path(_P119_PMT_TP_INF, "CtgyPurp");
        _P119_PMT_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp, "Cd");
        reqdExctnDt = new SmartDefaultHandler.Path(_P119_PMT_INF, "ReqdExctnDt");
        _P119_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(reqdExctnDt, "Dt");
        _P119_PMT_REQD_EXCTN_DT_TM = new SmartDefaultHandler.Path(reqdExctnDt, "DtTm");
        dbtr = new SmartDefaultHandler.Path(_P119_PMT_INF, "Dbtr");
        _P119_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        dbtrAcct = new SmartDefaultHandler.Path(_P119_PMT_INF, "DbtrAcct");
        id2 = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        _P119_DBTR_IBAN = new SmartDefaultHandler.Path(id2, "IBAN");
        _P119_DBTR_ACCT_CCY = new SmartDefaultHandler.Path(dbtrAcct, "Ccy");
        dbtrAgt = new SmartDefaultHandler.Path(_P119_PMT_INF, "DbtrAgt");
        finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        _P119_DBTR_BICFI = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        ultmtDbtr = new SmartDefaultHandler.Path(_P119_PMT_INF, "UltmtDbtr");
        id3 = new SmartDefaultHandler.Path(ultmtDbtr, "Id");
        orgId2 = new SmartDefaultHandler.Path(id3, "OrgId");
        othr2 = new SmartDefaultHandler.Path(orgId2, "Othr");
        _P119_ULTMT_DBTR_ID = new SmartDefaultHandler.Path(othr2, "Id");
        _P119_CDT_TRF_TX_INF = new SmartDefaultHandler.Path(_P119_PMT_INF, "CdtTrfTxInf");
        _P119_TX_PMT_TP_INF = new SmartDefaultHandler.Path(_P119_CDT_TRF_TX_INF, "PmtTpInf");
        svcLvl2 = new SmartDefaultHandler.Path(_P119_TX_PMT_TP_INF, "SvcLvl");
        _P119_TX_SVC_LVL = new SmartDefaultHandler.Path(svcLvl2, "Cd");
        ctgyPurp2 = new SmartDefaultHandler.Path(_P119_TX_PMT_TP_INF, "CtgyPurp");
        _P119_TX_CTGY_PURP = new SmartDefaultHandler.Path(ctgyPurp2, "Cd");
        amt = new SmartDefaultHandler.Path(_P119_CDT_TRF_TX_INF, "Amt");
        _P119_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        purp = new SmartDefaultHandler.Path(_P119_CDT_TRF_TX_INF, "Purp");
        _P119_PURP = new SmartDefaultHandler.Path(purp, "Cd");
    }
}

