/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.ebics.schema.SignatureContentHandler;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.ATTHMSingleTicketGenerator;
import de.businesslogics.format.ticket.ATTHMTicket;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.util.xml.OutputSAXParser;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ATTHMDisplayMessageGenerator
extends SignatureContentHandler
implements DisplayMessageGenerator {
    protected static final HashSet<String> DOCUMENT_URIS = new HashSet();
    private final ATHSP handler;

    public ATTHMDisplayMessageGenerator() {
        this(new ATHSP());
    }

    protected ATTHMDisplayMessageGenerator(ATHSP handler) {
        this.handler = handler;
        super.setNextHandler(handler);
    }

    public String getDocumentNamespace() {
        return this.handler.documentNamespace;
    }

    protected boolean isDocumentUri(String namespaceURI) {
        return DOCUMENT_URIS.contains(namespaceURI);
    }

    @Override
    public DisplayMessage getMessage(InputStream in) throws Exception {
        int i;
        OutputSAXParser op = this.handler.getOutputSAXParser(this);
        byte[] buffer = new byte[4096];
        while ((i = in.read(buffer)) > 0) {
            op.write(buffer, 0, i);
        }
        op.close();
        return this.handler.ticket;
    }

    public ATTHMTicket getMessage() {
        return this.handler.ticket;
    }

    public OutputSAXParser getOutputSAXParser() throws IOException, SAXException {
        return this.handler.getOutputSAXParser(this);
    }

    @Override
    protected boolean startDigest(String namespaceURI, String localName, String qName, Attributes atts) {
        return "THMPaymentsContainer".equals(localName) && this.isDocumentUri(namespaceURI);
    }

    public static class ATHSP
    extends SmartDefaultHandler {
        public static final SmartDefaultHandler.Path P119_DOCUMENT;
        public static final SmartDefaultHandler.Path _P119_DOCUMENT;
        public static final SmartDefaultHandler.Path P119005_DOCUMENT;
        public static final SmartDefaultHandler.Path _P119005_DOCUMENT;
        protected final ATTHMSingleTicketGenerator sub = new ATTHMSingleTicketGenerator();
        private ATTHMTicket ticket;
        private String documentNamespace;

        private ATHSP() {
        }

        @Override
        protected boolean requireXsd11() {
            return true;
        }

        @Override
        protected String getNamespaceSchemaLocations() {
            String s = this.sub.getNamespaceSchemaLocations();
            if (s == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(s);
            ATHSP.appendNamespaceSchemaLocation(sb, "THM:container:19005", "/de/businesslogics/format/stuzza/rb2023/APC.STUZZA.THM.Container.V19005.xsd");
            ATHSP.appendNamespaceSchemaLocation(sb, "THM:container:19004", "/de/businesslogics/format/stuzza/rb2023/APC.STUZZA.THM.Container.V19004.RC.xsd");
            return ATHSP.finishNamespaceSchemaLocations(sb);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.ticket = new ATTHMTicket();
        }

        @SmartDefaultHandler.Callback(value={"P119_DOCUMENT", "_P119_DOCUMENT", "P119005_DOCUMENT", "_P119005_DOCUMENT"})
        public SmartDefaultHandler startPainDocument(Attributes atts) {
            this.documentNamespace = this.getPath().getUri();
            return this.sub;
        }

        @SmartDefaultHandler.Callback(value={"P119_DOCUMENT", "_P119_DOCUMENT", "P119005_DOCUMENT", "_P119005_DOCUMENT"})
        public void endPainDocument() {
            this.ticket.getSingleTickets().add(this.sub.getMessage());
        }

        static {
            SmartDefaultHandler.Path p119Document = ATTHMSingleTicketGenerator.P119_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p119Document.getUri());
            SmartDefaultHandler.Path doc = new SmartDefaultHandler.Path(null, "THM:container:19005", "Document");
            SmartDefaultHandler.Path tc = new SmartDefaultHandler.Path(doc, "THMPaymentsContainer");
            SmartDefaultHandler.Path thm = new SmartDefaultHandler.Path(tc, "THMOrdrs");
            P119005_DOCUMENT = p119Document.prefixPath(thm);
            SmartDefaultHandler.Path path = new SmartDefaultHandler.Path(thm, "Sgntr");
            p119Document = ATTHMSingleTicketGenerator._P119_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p119Document.getUri());
            doc = new SmartDefaultHandler.Path(null, "THM:container:19005", "Document");
            tc = new SmartDefaultHandler.Path(doc, "THMPaymentsContainer");
            thm = new SmartDefaultHandler.Path(tc, "THMOrdrs");
            _P119005_DOCUMENT = p119Document.prefixPath(thm);
            path = new SmartDefaultHandler.Path(thm, "Sgntr");
            p119Document = ATTHMSingleTicketGenerator.P119_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p119Document.getUri());
            doc = new SmartDefaultHandler.Path(null, "THM:container:19004", "Document");
            tc = new SmartDefaultHandler.Path(doc, "THMPaymentsContainer");
            thm = new SmartDefaultHandler.Path(tc, "THMOrdrs");
            P119_DOCUMENT = p119Document.prefixPath(thm);
            path = new SmartDefaultHandler.Path(thm, "Sgntr");
            p119Document = ATTHMSingleTicketGenerator._P119_PMT_INF.getParent().getParent();
            DOCUMENT_URIS.add(p119Document.getUri());
            doc = new SmartDefaultHandler.Path(null, "THM:container:19004", "Document");
            tc = new SmartDefaultHandler.Path(doc, "THMPaymentsContainer");
            thm = new SmartDefaultHandler.Path(tc, "THMOrdrs");
            _P119_DOCUMENT = p119Document.prefixPath(thm);
            path = new SmartDefaultHandler.Path(thm, "Sgntr");
        }
    }
}

