/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt942;

import de.businesslogics.format.swift.BeginRepeatHandler;
import de.businesslogics.format.swift.EmptyLineHandler;
import de.businesslogics.format.swift.EmptyOrInvalidLineHandler;
import de.businesslogics.format.swift.EndRepeatHandler;
import de.businesslogics.format.swift.Field13;
import de.businesslogics.format.swift.Field13DHandler;
import de.businesslogics.format.swift.Field13Handler;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field20Handler;
import de.businesslogics.format.swift.Field21;
import de.businesslogics.format.swift.Field21Handler;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.Field25Handler;
import de.businesslogics.format.swift.Field28C;
import de.businesslogics.format.swift.Field28CHandler;
import de.businesslogics.format.swift.Field34F;
import de.businesslogics.format.swift.Field34FHandler;
import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.Field61Handler;
import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.Field86Handler;
import de.businesslogics.format.swift.Field90C;
import de.businesslogics.format.swift.Field90CHandler;
import de.businesslogics.format.swift.Field90D;
import de.businesslogics.format.swift.Field90DHandler;
import de.businesslogics.format.swift.NewSwiftParser;
import de.businesslogics.format.swift.OrHandler;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import de.businesslogics.format.swift.SwiftHeaderHandler;
import de.businesslogics.format.swift.SwiftTrailerHandler;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.format.swift.mt942.MT942Header;
import de.businesslogics.format.swift.mt942.MT942Listener;
import de.businesslogics.format.swift.mt942.MT942Trailer;
import de.businesslogics.nio.charset.MT940;
import java.util.List;

public class MT942Parser
extends NewSwiftParser {
    private final MT942Listener listener;
    private Field20 field20;
    private Field21 field21;
    private Field25 field25;
    private Field28C field28C;
    private Field34F field34F_1;
    private Field34F field34F_2;
    private Field13 field13;
    private Field61 field61;
    private Field86 field86;
    private Field90D field90D;
    private Field90C field90C;
    private MT942Header mt942Header;

    public MT942Parser(MT942Listener listener) {
        super(new MT940());
        this.listener = listener;
        this.addBeginRepeat();
        this.addOptional(new EmptyOrInvalidLineHandler());
        this.addEndRepeat();
        this.addBeginRepeat();
        this.addOptional(new SwiftHeaderHandler());
        this.addMandatory(new MT942Field20Handler());
        this.addBeginRepeat();
        this.addOptional(new EmptyLineHandler());
        this.addEndRepeat();
        this.addOptional(new MT942Field21Handler());
        this.addMandatory(new MT942Field25Handler());
        this.addMandatory(new MT942Field28CHandler());
        this.addMandatory(new MT942Field34FHandler());
        this.addOptional(new MT942Field34F2Handler());
        this.addMandatory(new EndHeaderHandler());
        this.addOptional(new BeginRepeatHandler());
        this.addOptional(new MT942Field61Handler());
        this.addIf();
        this.addMandatory(new MT942Field86Handler());
        this.addOptional(new EmptyLineHandler());
        this.addOptional(new MT942LineWithMinusHandler(this));
        this.addEndIf();
        this.addOptional(new MT942EndLoopHandler());
        this.addBeginRepeat();
        this.addOptional(new EmptyLineHandler());
        this.addEndRepeat();
        this.addOptional(new MT942Field90DHandler());
        this.addOptional(new MT942Field90CHandler());
        this.addOptional(new MT942Field86Handler());
        this.addMandatory(new MT942SwiftTrailerHandler());
        this.addBeginRepeat();
        this.addOptional(new EmptyOrInvalidLineHandler());
        this.addEndRepeat();
        this.addEndRepeat();
    }

    private class MT942Field20Handler
    extends Field20Handler {
        private MT942Field20Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT942Parser.this.field20 = this.field20;
            MT942Parser.this.field21 = null;
            MT942Parser.this.field34F_2 = null;
            MT942Parser.this.field90C = null;
            MT942Parser.this.field90D = null;
        }
    }

    private class MT942Field21Handler
    extends Field21Handler {
        private MT942Field21Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT942Parser.this.field21 = this.field21;
        }
    }

    private class MT942Field25Handler
    extends Field25Handler {
        private MT942Field25Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT942Parser.this.field25 = this.field25;
        }
    }

    private class MT942Field28CHandler
    extends Field28CHandler {
        private MT942Field28CHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field28C = this.field28C;
        }
    }

    private class MT942Field34FHandler
    extends Field34FHandler {
        private MT942Field34FHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field34F_1 = this.field34F;
        }
    }

    private class MT942Field34F2Handler
    extends Field34FHandler {
        private MT942Field34F2Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field34F_2 = this.field34F;
        }
    }

    private class EndHeaderHandler
    extends OrHandler {
        private EndHeaderHandler() {
            this.add(new MT942Field13Handler());
            this.add(new MT942Field13DHandler());
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            if (MT942Parser.this.field20 != null) {
                MT942Parser.this.mt942Header = new MT942Header(MT942Parser.this.field20, MT942Parser.this.field21, MT942Parser.this.field25, MT942Parser.this.field28C, MT942Parser.this.field34F_1, MT942Parser.this.field34F_2, MT942Parser.this.field13);
                if (MT942Parser.this.listener != null) {
                    MT942Parser.this.listener.handle(MT942Parser.this.mt942Header);
                }
                MT942Parser.this.field20 = null;
            }
            MT942Parser.this.field61 = null;
            MT942Parser.this.field86 = null;
        }
    }

    private class MT942Field61Handler
    extends Field61Handler {
        private MT942Field61Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field61 = this.field61;
        }
    }

    private class MT942Field86Handler
    extends Field86Handler {
        private MT942Field86Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field86 = this.field86;
        }
    }

    private class MT942LineWithMinusHandler
    extends SwiftHandler {
        private MT942LineWithMinusHandler(MT942Parser mT942Parser) {
        }

        @Override
        public String willHandle(String firstLine) {
            if (firstLine.trim().equals("-")) {
                return firstLine;
            }
            return null;
        }

        @Override
        public void handle(List<String> block) throws ParseException {
        }
    }

    private class MT942EndLoopHandler
    extends EndRepeatHandler {
        private MT942EndLoopHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            if (MT942Parser.this.listener != null && (MT942Parser.this.field61 != null || MT942Parser.this.field86 != null)) {
                MT942Parser.this.listener.handle(new MT940Booking(MT942Parser.this.mt942Header, MT942Parser.this.field61, MT942Parser.this.field86));
                MT942Parser.this.field61 = null;
                MT942Parser.this.field86 = null;
            }
        }
    }

    private class MT942Field90DHandler
    extends Field90DHandler {
        private MT942Field90DHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field90D = this.field90D;
        }
    }

    private class MT942Field90CHandler
    extends Field90CHandler {
        private MT942Field90CHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT942Parser.this.field90C = this.field90C;
        }
    }

    private class MT942SwiftTrailerHandler
    extends SwiftTrailerHandler {
        private MT942SwiftTrailerHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            if (MT942Parser.this.listener != null) {
                MT942Trailer trailer = new MT942Trailer(MT942Parser.this.field90C, MT942Parser.this.field90D);
                MT942Parser.this.listener.handle(trailer);
            }
        }

        @Override
        public String willHandle(String firstLine) {
            if (firstLine.startsWith(":20:")) {
                return "";
            }
            return super.willHandle(firstLine);
        }
    }

    private class MT942Field13DHandler
    extends Field13DHandler {
        private MT942Field13DHandler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT942Parser.this.field13 = this.field13D;
        }
    }

    private class MT942Field13Handler
    extends Field13Handler {
        private MT942Field13Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT942Parser.this.field13 = this.field13;
        }
    }
}

