/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt942;

import de.businesslogics.format.swift.Field21;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.Field28C;
import de.businesslogics.format.swift.Field34F;
import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.Field90C;
import de.businesslogics.format.swift.Field90D;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.StructuredField86;
import de.businesslogics.format.swift.TokenMgrError;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.format.swift.mt942.MT942Header;
import de.businesslogics.format.swift.mt942.MT942Listener;
import de.businesslogics.format.swift.mt942.MT942Parser;
import de.businesslogics.format.swift.mt942.MT942Trailer;
import de.businesslogics.util.Currency;
import de.businesslogics.util.SystemUtils;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MT942Demo
implements MT942Listener {
    final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    final DecimalFormat df = new DecimalFormat();
    private Currency accountCurrency;
    private final PrintWriter out;
    private String indent;
    private static final char NEWLINE = '\n';

    public MT942Demo(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void handle(MT942Header header) {
        this.indent = "  ";
        Field25 field25 = header.getField25();
        this.out.print("Kontoauszug f\u00fcr Konto (");
        String bankcode = field25.getBankcode();
        if (bankcode != null) {
            this.out.print(field25.isBIC() ? "BIC=" : "BLZ=");
            this.out.print(bankcode);
            this.out.print(", Kontonummer=");
            this.out.print(field25.getAccount());
        } else {
            this.out.print("IBAN=");
            this.out.print(field25.getAccount());
        }
        this.out.print(')');
        this.out.print('\n');
        Field28C field28c = header.getField28C();
        if (field28c.getNumber() > 0) {
            this.out.print(this.indent);
            this.out.print("Auszugnummer ");
            this.out.print(field28c.getNumber());
            if (field28c.getSheet() > 0) {
                this.out.print(", Blatt ");
                this.out.print(field28c.getSheet());
            }
            this.out.print('\n');
        }
        this.printOptional("Auftragsreferenznummer", header.getField20().getReference());
        Field21 field21 = header.getField21();
        if (field21 != null) {
            this.printOptional("Bezugsreferenznummer", field21.getReference());
        }
        Field34F field34f_1 = header.getField34F_1();
        Field34F field34f_2 = header.getField34F_2();
        this.print(field34f_2 == null ? "Kleinster Umsatz: " : "Kleinster Sollumsatz", field34f_1.getAmount(), field34f_1.getCurrency());
        if (field34f_2 != null) {
            this.print("Kleinster Habenumsatz", field34f_2.getAmount(), field34f_2.getCurrency());
        }
        this.printOptional("Aviserstellung", header.getField13().getTimestamp());
        this.indent = "    ";
        this.accountCurrency = field34f_1.getCurrency();
    }

    @Override
    public void handle(MT940Booking booking) {
        Field86 field86;
        Field61 field61 = booking.getField61();
        if (field61 != null) {
            if (field61.isReversal()) {
                this.out.print("  ****** Storno ******");
                this.out.print('\n');
            } else if (field61.isExpected()) {
                this.out.print("  ****** Expected ******");
                this.out.print('\n');
            } else {
                this.out.print("  Buchung:");
                this.out.print('\n');
            }
            this.printOptional("Kundenreferenz", field61.getCustomerReference());
            this.printOptional("Bankreferenz", field61.getBankReference());
            this.print("Betrag", field61.getAmount(), field61.getCurrency(this.accountCurrency));
            this.printOptional("Valuta", field61.getValuta());
            this.printOptional("Buchungstag", field61.getBookingDate(null));
        }
        if ((field86 = booking.getField86()) != null) {
            if (field86 instanceof StructuredField86) {
                StructuredField86 sf = (StructuredField86)field86;
                this.printOptional("Gesch\u00e4ftsvorfallcode", sf.getGeschaeftsvorfallcode());
                this.printOptional("Buchungstext", sf.getBookingText());
                this.printOptional("Primanota", sf.getPrimaNota());
                this.printOptional("Verwendungszweck", sf.getPurpose());
                this.printOptional("BLZ/BIC", sf.getOtherBankcode());
                this.printOptional("Konto", sf.getOtherAccount());
                this.printOptional("Empf\u00e4nger/Sender", sf.getOtherName());
                this.printOptional("Textschl\u00fcsselerg\u00e4nzung", sf.getTextKeyAppendix());
            } else {
                this.printOptional("Mehrzweckfeld (unstrukturiert)", field86.getRawLines());
            }
        }
    }

    @Override
    public void handle(MT942Trailer trailer) {
        Field90C field90c;
        this.indent = "  ";
        Field90D field90d = trailer.getField90D();
        if (field90d != null) {
            this.printOptional("Anzahl Soll-Buchungen", Integer.toString(field90d.getNumberOfPayments()));
            this.print("Summe der Soll-Buchungen", field90d.getSumOfAmounts(), field90d.getCurrency());
        }
        if ((field90c = trailer.getField90C()) != null) {
            this.printOptional("Anzahl Haben-Buchungen", Integer.toString(field90c.getNumberOfPayments()));
            this.print("Summe der Haben-Buchungen", field90c.getSumOfAmounts(), field90c.getCurrency());
        }
        this.out.print('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            try {
                MT942Demo demo = new MT942Demo(new PrintWriter(System.out));
                MT942Parser parser = new MT942Parser(demo);
                FileInputStream fis = new FileInputStream(args[i]);
                try {
                    parser.parse(fis);
                    fis = null;
                    continue;
                }
                finally {
                    SystemUtils.close(fis);
                }
            }
            catch (ParseException pe) {
                System.err.println("Error parsing file: " + args[i]);
                System.err.println(pe.getMessage());
                System.exit(1);
                continue;
            }
            catch (TokenMgrError tme) {
                System.err.println("Error parsing file: " + args[i]);
                System.err.println(tme.getMessage());
                System.exit(1);
            }
        }
    }

    private void printOptional(String title, Date value) {
        if (value == null) {
            return;
        }
        this.printOptional(title, this.sdf.format(value));
    }

    private void print(String title, BigDecimal value, Currency currency) {
        this.df.setMinimumFractionDigits(currency.getDefaultFractionDigits());
        this.df.setMaximumFractionDigits(currency.getDefaultFractionDigits());
        this.printOptional(title, this.df.format(value.doubleValue()) + " " + String.valueOf(currency));
    }

    private void printOptional(String title, String value) {
        if (value == null) {
            return;
        }
        this.out.print(this.indent);
        this.out.print(title);
        this.out.print(": ");
        this.out.print(value);
        this.out.print('\n');
    }

    private void printOptional(String title, String[] s) {
        if (s.length == 0) {
            return;
        }
        this.out.print(this.indent);
        this.out.println(title);
        for (int i = 0; i < s.length; ++i) {
            this.out.print(this.indent);
            this.out.print("  ");
            this.out.print(s[i]);
            this.out.print('\n');
        }
    }
}

