/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt940;

import de.businesslogics.format.swift.BeginRepeatHandler;
import de.businesslogics.format.swift.EmptyLineHandler;
import de.businesslogics.format.swift.EndRepeatHandler;
import de.businesslogics.format.swift.Field13Handler;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field20Handler;
import de.businesslogics.format.swift.Field21;
import de.businesslogics.format.swift.Field21Handler;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.Field25Handler;
import de.businesslogics.format.swift.Field28C;
import de.businesslogics.format.swift.Field28CHandler;
import de.businesslogics.format.swift.Field34FHandler;
import de.businesslogics.format.swift.Field60F;
import de.businesslogics.format.swift.Field60FHandler;
import de.businesslogics.format.swift.Field60MHandler;
import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.Field61Handler;
import de.businesslogics.format.swift.Field62F;
import de.businesslogics.format.swift.Field62FHandler;
import de.businesslogics.format.swift.Field62MHandler;
import de.businesslogics.format.swift.Field64;
import de.businesslogics.format.swift.Field64Handler;
import de.businesslogics.format.swift.Field65;
import de.businesslogics.format.swift.Field65Handler;
import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.Field86Handler;
import de.businesslogics.format.swift.Field90CHandler;
import de.businesslogics.format.swift.Field90DHandler;
import de.businesslogics.format.swift.NewSwiftParser;
import de.businesslogics.format.swift.OSHeaderHandler;
import de.businesslogics.format.swift.OrHandler;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import de.businesslogics.format.swift.SwiftHeaderHandler;
import de.businesslogics.format.swift.SwiftTrailerHandler;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.format.swift.mt940.MT940Demo;
import de.businesslogics.format.swift.mt940.MT940Header;
import de.businesslogics.format.swift.mt940.MT940LineHandler;
import de.businesslogics.format.swift.mt940.MT940Listener;
import de.businesslogics.format.swift.mt940.MT940NonSwiftHandler;
import de.businesslogics.format.swift.mt940.MT940Trailer;
import de.businesslogics.format.swift.mt942.MT942Demo;
import de.businesslogics.format.swift.mt942.MT942Parser;
import de.businesslogics.nio.charset.MT940;
import de.businesslogics.util.Currency;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MT940Parser
extends NewSwiftParser {
    private final MT940Listener listener;
    private Field20 field20;
    private Field21 field21;
    private Field25 field25;
    private Field28C field28C;
    private Field60F field60F;
    private Field61 field61;
    private Field86 field86;
    private Field62F field62F;
    private Field62F lastField62F;
    private Field64 field64;
    private final List<Field65> fields65 = new ArrayList<Field65>();
    private MT940Header mt940Header;

    public MT940Parser(MT940Listener listener) {
        super(new MT940());
        this.listener = listener;
        this.addOptional(new MT940LineHandler());
        this.addBeginRepeat();
        this.addOptional(new EmptyLineHandler());
        this.addEndRepeat();
        this.addBeginRepeat();
        this.addOptional(new OSHeaderHandler());
        this.addOptional(new EmptyLineHandler());
        this.addEndRepeat();
        this.addBeginRepeat();
        this.addOptional(new SwiftHeaderHandler());
        this.addMandatory(new MT940Field20Handler());
        this.addOptional(new MT940Field21Handler());
        this.addMandatory(new MT940Field25Handler());
        this.addIf();
        this.addMandatory(new Field34FHandler());
        this.addOptional(new Field34FHandler());
        this.addMandatory(new Field13Handler());
        this.addBeginRepeat();
        this.addOptional(new Field61Handler());
        this.addOptional(new Field86Handler());
        this.addEndRepeat();
        this.addOptional(new Field90DHandler());
        this.addOptional(new Field90CHandler());
        this.addElse();
        this.addMandatory(new MT940Field28CHandler());
        this.addIf();
        this.addMandatory(new MT940Field61RHandler());
        this.addMandatory(new MT940BeginLoopHandler());
        this.addOptional(new MT940Field61RHandler());
        this.addMandatory(new MT940Field86EHandler());
        this.addMandatory(new MT940EndLoopHandler());
        this.addElse();
        this.addOptional(new MT940NonSwiftHandler());
        OrHandler oh = new OrHandler();
        oh.add(new MT940Field60FHandler());
        oh.add(new MT940Field60MHandler());
        this.addMandatory(oh);
        MT940Field86Handler h86 = new MT940Field86Handler();
        this.addOptional(new MT940BeginLoopHandler());
        this.addOptional(new MT940Field61Handler());
        this.addOptional(h86);
        this.addOptional(new MT940EndLoopHandler());
        oh = new OrHandler();
        oh.add(new MT940Field62FHandler());
        oh.add(new MT940Field62MHandler());
        this.addMandatory(oh);
        this.addOptional(new MT940Field64Handler());
        this.addOptional(new EmptyLineHandler());
        this.addBeginRepeat();
        this.addOptional(new MT940Field65Handler());
        this.addEndRepeat();
        this.addOptional(h86);
        this.addEndIf();
        this.addEndIf();
        this.addOptional(new SwiftTrailerHandler());
        this.addOptional(new SwiftHeaderHandler());
        this.addOptional(new SwiftTrailerHandler());
        this.addBeginRepeat();
        this.addOptional(new TwoStarsIgnoreHandler(this));
        this.addOptional(new EmptyLineHandler());
        this.addOptional(new OSHeaderHandler());
        this.addEndRepeat();
        this.addOptional(new MT940EndHandler());
    }

    public InputStream parseMixedData(InputStream is) throws IOException, ParseException {
        MT942Filter filter = new MT942Filter(is);
        super.parse(filter);
        filter.writer.close();
        if (filter.bout.size() == 0) {
            return null;
        }
        return new ByteArrayInputStream(filter.bout.toByteArray());
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            System.out.println("usage: <input-file>");
            System.exit(-1);
        }
        try (FileInputStream fin = new FileInputStream(args[0]);){
            MT940Parser parser = new MT940Parser(new MT940Demo(new PrintWriter(System.out)));
            try (InputStream in = parser.parseMixedData(fin);){
                if (in != null) {
                    System.out.println("MT942");
                    MT942Parser p = new MT942Parser(new MT942Demo(new PrintWriter(System.out)));
                    p.parse(in);
                }
            }
        }
    }

    private class MT940Field20Handler
    extends Field20Handler {
        private MT940Field20Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT940Parser.this.field20 = this.field20;
            MT940Parser.this.field21 = null;
        }
    }

    private class MT940Field21Handler
    extends Field21Handler {
        private MT940Field21Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT940Parser.this.field21 = this.field21;
        }
    }

    private class MT940Field25Handler
    extends Field25Handler {
        private MT940Field25Handler() {
        }

        @Override
        public void handle(List<String> block) {
            super.handle(block);
            MT940Parser.this.field25 = this.field25;
        }
    }

    private class MT940Field28CHandler
    extends Field28CHandler {
        private MT940Field28CHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field28C = this.field28C;
        }
    }

    private class MT940Field61RHandler
    extends SwiftHandler {
        private MT940Field61RHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            String line = block.get(0);
            String valuta = line.substring(5, 11);
            String bankReference = line.substring(11, 19);
            MT940Parser.this.field61 = new Field61(valuta, null, false, false, ' ', BigDecimal.ZERO, "", "", bankReference, null);
            if (MT940Parser.this.lastField62F != null) {
                MT940Parser.this.field60F = new Field60F(MT940Parser.this.lastField62F.getBooking(), MT940Parser.this.lastField62F.getBalance(), MT940Parser.this.lastField62F.getCurrency());
                MT940Parser.this.field62F = new Field62F(MT940Parser.this.lastField62F.getBooking(), MT940Parser.this.lastField62F.getBalance(), MT940Parser.this.lastField62F.getCurrency());
            }
        }

        @Override
        public String willHandle(String firstLine) {
            return firstLine.startsWith(":61R:") ? firstLine : null;
        }
    }

    private class MT940BeginLoopHandler
    extends BeginRepeatHandler {
        private MT940BeginLoopHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            if (MT940Parser.this.field20 != null) {
                MT940Parser.this.mt940Header = new MT940Header(MT940Parser.this.field20, MT940Parser.this.field21, MT940Parser.this.field25, MT940Parser.this.field28C, MT940Parser.this.field60F);
                if (MT940Parser.this.listener != null) {
                    MT940Parser.this.listener.handle(MT940Parser.this.mt940Header);
                }
                MT940Parser.this.field20 = null;
            }
        }
    }

    private class MT940Field86EHandler
    extends SwiftHandler {
        private MT940Field86EHandler() {
        }

        @Override
        public int getMaxBlockLength() {
            return 99;
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            String[] raw = new String[block.size()];
            int i = 0;
            int pos = 7;
            for (String s : block) {
                raw[i++] = s.substring(pos);
                pos = 2;
            }
            MT940Parser.this.field86 = new Field86(raw);
        }

        @Override
        public String willHandle(String firstLine) {
            return firstLine.startsWith(":86E:") ? firstLine : null;
        }
    }

    private class MT940EndLoopHandler
    extends EndRepeatHandler {
        private MT940EndLoopHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            if (MT940Parser.this.listener != null && (MT940Parser.this.field61 != null || MT940Parser.this.field86 != null)) {
                MT940Parser.this.listener.handle(new MT940Booking(MT940Parser.this.mt940Header, MT940Parser.this.field61, MT940Parser.this.field86));
            }
            MT940Parser.this.field61 = null;
            MT940Parser.this.field86 = null;
        }
    }

    private class MT940Field60FHandler
    extends Field60FHandler {
        private MT940Field60FHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field60F = this.field60F;
        }
    }

    private class MT940Field60MHandler
    extends Field60MHandler {
        private MT940Field60MHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field60F = this.field60M;
        }
    }

    private class MT940Field86Handler
    extends Field86Handler {
        private MT940Field86Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field86 = this.field86;
        }
    }

    private class MT940Field61Handler
    extends Field61Handler {
        private MT940Field61Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field61 = this.field61;
        }
    }

    private class MT940Field62FHandler
    extends Field62FHandler {
        private MT940Field62FHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field62F = this.field62F;
        }

        @Override
        protected Currency guessCurrency() {
            return MT940Parser.this.field60F.getCurrency();
        }
    }

    private class MT940Field62MHandler
    extends Field62MHandler {
        private MT940Field62MHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field62F = this.field62M;
        }
    }

    private class MT940Field64Handler
    extends Field64Handler {
        private MT940Field64Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.field64 = this.field64;
        }
    }

    private class MT940Field65Handler
    extends Field65Handler {
        private MT940Field65Handler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            MT940Parser.this.fields65.add(this.field65);
        }
    }

    private class TwoStarsIgnoreHandler
    extends SwiftHandler {
        private TwoStarsIgnoreHandler(MT940Parser mT940Parser) {
        }

        @Override
        public int getMaxBlockLength() {
            return 1;
        }

        @Override
        public void handle(List<String> block) {
        }

        @Override
        public String willHandle(String firstLine) {
            return firstLine.trim().equals("**") ? firstLine : null;
        }
    }

    private class MT940EndHandler
    extends EndRepeatHandler {
        private MT940EndHandler() {
        }

        @Override
        public void handle(List<String> block) throws ParseException {
            super.handle(block);
            if (MT940Parser.this.field62F != null && MT940Parser.this.listener != null) {
                Field65[] f65 = null;
                if (!MT940Parser.this.fields65.isEmpty()) {
                    f65 = new Field65[MT940Parser.this.fields65.size()];
                    MT940Parser.this.fields65.toArray(f65);
                }
                MT940Trailer trailer = new MT940Trailer(MT940Parser.this.field62F, MT940Parser.this.field64, f65, MT940Parser.this.field86);
                MT940Parser.this.listener.handle(trailer);
            }
            MT940Parser.this.lastField62F = MT940Parser.this.field62F;
            MT940Parser.this.field62F = null;
            MT940Parser.this.field64 = null;
            MT940Parser.this.fields65.clear();
            MT940Parser.this.field86 = null;
        }
    }

    public static class MT942Filter
    extends InputStream {
        private BufferedReader reader = null;
        private BufferedWriter writer = null;
        private ByteArrayOutputStream bout = null;
        private String line = null;
        private byte[] buffer = null;
        private int pos = 0;
        private final Charset charset = new MT940();

        public MT942Filter(InputStream in) {
            this.reader = new BufferedReader(new InputStreamReader(in, this.charset));
            this.bout = new ByteArrayOutputStream();
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.bout, new MT940()));
        }

        private void check() throws IOException {
            if (this.line == null || this.pos == this.buffer.length) {
                this.line = this.reader.readLine();
                if (this.line == null) {
                    return;
                }
                boolean isSTA = true;
                boolean found13D = false;
                boolean found28C = false;
                boolean found34F = false;
                do {
                    if (this.line.startsWith(":20:STARTDISP")) {
                        isSTA = false;
                        found34F = false;
                        found28C = false;
                        found13D = false;
                    } else if (this.line.startsWith(":20:")) {
                        isSTA = true;
                    }
                    if (isSTA) continue;
                    if (!found28C && this.line.startsWith(":28C:")) {
                        found28C = true;
                    } else if (!found34F && this.line.startsWith(":34F:")) {
                        if (!found28C) {
                            this.writer.write(":28C:0");
                            this.writer.newLine();
                            found28C = true;
                        }
                        found34F = true;
                    } else if (!found13D && (this.line.startsWith(":13:") || this.line.startsWith(":13D:"))) {
                        if (!found28C) {
                            this.writer.write(":28C:0");
                            this.writer.newLine();
                            found28C = true;
                        }
                        if (!found34F) {
                            this.writer.write(":34F:EUR0,00");
                            this.writer.newLine();
                            found34F = true;
                        }
                        found13D = true;
                    } else if (!(found13D && found28C && found34F || !this.line.startsWith(":61:"))) {
                        if (!found28C) {
                            this.writer.write(":28C:0");
                            this.writer.newLine();
                            found28C = true;
                        }
                        if (!found34F) {
                            this.writer.write(":34F:EUR0,00");
                            this.writer.newLine();
                            found34F = true;
                        }
                        if (!found13D) {
                            this.writer.write(":13D:");
                            if (this.line.length() >= 10) {
                                this.writer.write(this.line.substring(4, 10));
                                this.writer.write("00000-0000");
                            } else {
                                this.writer.write(new SimpleDateFormat("yyMMddHHmmZ").format(new Date()));
                            }
                            this.writer.newLine();
                            found13D = true;
                        }
                    }
                    this.writer.write(this.line);
                    this.writer.newLine();
                    this.line = this.reader.readLine();
                } while (!isSTA);
            }
            if (this.line != null) {
                this.line = this.line + "\n";
            }
            this.buffer = this.line.getBytes("ISO-8859-1");
            this.pos = 0;
        }

        @Override
        public int read() throws IOException {
            this.check();
            if (this.line == null) {
                return -1;
            }
            return this.buffer[this.pos++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.check();
            if (this.line == null) {
                return -1;
            }
            int size = this.buffer.length - this.pos;
            System.arraycopy(this.buffer, this.pos, b, off, size);
            this.pos += size;
            return size;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }
}

