/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt940;

import de.businesslogics.format.swift.Field21;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.Field28C;
import de.businesslogics.format.swift.Field60F;
import de.businesslogics.format.swift.Field60M;
import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.Field62F;
import de.businesslogics.format.swift.Field62M;
import de.businesslogics.format.swift.Field64;
import de.businesslogics.format.swift.Field65;
import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.StructuredField86;
import de.businesslogics.format.swift.TokenMgrError;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.format.swift.mt940.MT940Header;
import de.businesslogics.format.swift.mt940.MT940Listener;
import de.businesslogics.format.swift.mt940.MT940Parser;
import de.businesslogics.format.swift.mt940.MT940Trailer;
import de.businesslogics.util.Currency;
import de.businesslogics.util.SystemUtils;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class MT940Demo
implements MT940Listener {
    final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    final DecimalFormat df = new DecimalFormat();
    private Currency accountCurrency;
    private final PrintWriter out;
    private String indent;
    private final ArrayList<MT940Booking> bookingList = new ArrayList();

    public MT940Demo(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void handle(MT940Header header) {
        this.indent = "  ";
        Field25 field25 = header.getField25();
        this.out.print("Kontoauszug f\u00fcr Konto (");
        String bankcode = field25.getBankcode();
        if (bankcode != null) {
            this.out.print(field25.isBIC() ? "BIC=" : "BLZ=");
            this.out.print(bankcode);
            this.out.print(", Kontonummer=");
            this.out.print(field25.getAccount());
        } else {
            this.out.print("IBAN=");
            this.out.print(field25.getAccount());
        }
        this.out.println(')');
        Field28C field28c = header.getField28C();
        if (field28c.getNumber() > 0) {
            this.out.print(this.indent);
            this.out.print("Auszugnummer ");
            this.out.print(field28c.getNumber());
            if (field28c.getSheet() > 0) {
                this.out.print(", Blatt ");
                this.out.print(field28c.getSheet());
            }
            this.out.println();
        }
        this.printOptional("Auftragsreferenznummer", header.getField20().getReference());
        Field21 field21 = header.getField21();
        if (field21 != null) {
            this.printOptional("Bezugsreferenznummer", field21.getReference());
        }
        Field60F field60f = header.getField60F();
        this.accountCurrency = field60f.getCurrency();
        this.print(field60f instanceof Field60M ? "Zwischensaldo" : "Anfangssaldo", field60f.getBalance(), this.accountCurrency);
        this.printOptional("Letzter Auszug", field60f.getBooking());
        this.indent = "    ";
    }

    @Override
    public void handle(MT940Booking booking) {
        this.bookingList.add(booking);
    }

    private void printBooking(MT940Booking booking, MT940Trailer trailer) {
        Field61 field61 = booking.getField61();
        if (field61.isReversal()) {
            this.out.println("  ****** Storno ******");
        } else {
            this.out.println("  Buchung:");
        }
        this.printOptional("Kundenreferenz", field61.getCustomerReference());
        this.printOptional("Bankreferenz", field61.getBankReference());
        this.print("Betrag", field61.getAmount(), field61.getCurrency(this.accountCurrency));
        this.printOptional("Valuta", field61.getValuta());
        this.printOptional("Buchungstag", field61.getBooking(trailer.getField62F()));
        Field86 field86 = booking.getField86();
        if (field86 instanceof StructuredField86) {
            StructuredField86 sf = (StructuredField86)field86;
            this.printOptional("Gesch\u00e4ftsvorfallcode", sf.getGeschaeftsvorfallcode());
            this.printOptional("Buchungstext", sf.getBookingText());
            this.printOptional("Primanota", sf.getPrimaNota());
            this.printOptional("Verwendungszweck", sf.getPurpose());
            this.printOptional("BLZ/BIC", sf.getOtherBankcode());
            this.printOptional("Konto", sf.getOtherAccount());
            this.printOptional("Empf\u00e4nger/Sender", sf.getOtherName());
            this.printOptional("Mein Name", sf.getMyName());
            this.printOptional("Textschl\u00fcsselerg\u00e4nzung", sf.getTextKeyAppendix());
        } else if (field86 != null) {
            this.printOptional("Mehrzweckfeld (unstrukturiert)", field86.getRawLines());
        }
    }

    @Override
    public void handle(MT940Trailer trailer) {
        Field65[] fields65;
        String s;
        for (MT940Booking b : this.bookingList) {
            this.printBooking(b, trailer);
        }
        this.bookingList.clear();
        this.indent = "  ";
        Field62F field62f = trailer.getField62F();
        this.print(field62f instanceof Field62M ? "Zwischensaldo" : "Schlusssaldo", field62f.getBalance(), field62f.getCurrency());
        Field64 field64 = trailer.getField64();
        if (field64 != null) {
            s = "Valutarischer Saldo am " + this.sdf.format(field64.getValuta());
            this.print(s, field64.getBalance(), field64.getCurrency());
        }
        for (Field65 field65 : fields65 = trailer.getFields65()) {
            s = "Valutarischer Saldo am " + this.sdf.format(field65.getValuta());
            this.print(s, field65.getBalance(), field65.getCurrency());
        }
        Field86 field86 = trailer.getField86();
        if (field86 != null) {
            this.printOptional("Freier Text", field86.getRawLines());
        }
        this.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            try {
                MT940Demo demo = new MT940Demo(new PrintWriter(System.out));
                MT940Parser parser = new MT940Parser(demo);
                FileInputStream fis = new FileInputStream(arg);
                try {
                    parser.parse(fis);
                    fis = null;
                }
                finally {
                    SystemUtils.close(fis);
                }
            }
            catch (ParseException pe) {
                System.err.println("Error parsing file: " + arg);
                System.err.println(pe.getMessage());
                System.exit(1);
            }
            catch (TokenMgrError tme) {
                System.err.println("Error parsing file: " + arg);
                System.err.println(tme.getMessage());
                System.exit(1);
            }
        }
    }

    private void printOptional(String title, Date value) {
        if (value == null) {
            return;
        }
        this.printOptional(title, this.sdf.format(value));
    }

    private void print(String title, BigDecimal value, Currency currency) {
        this.df.setMinimumFractionDigits(currency.getDefaultFractionDigits());
        this.df.setMaximumFractionDigits(currency.getDefaultFractionDigits());
        this.printOptional(title, this.df.format(value.doubleValue()) + " " + String.valueOf(currency));
    }

    private void printOptional(String title, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        this.out.print(this.indent);
        this.out.print(title);
        this.out.print(": ");
        this.out.println(value);
    }

    private void printOptional(String title, String[] s) {
        if (s == null || s.length == 0) {
            return;
        }
        this.out.print(this.indent);
        this.out.println(title);
        for (String value : s) {
            this.out.print(this.indent);
            this.out.print("  ");
            this.out.println(value);
        }
    }
}

