/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt940;

import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.SwiftElement;
import de.businesslogics.format.swift.mt940.MT940Header;
import de.businesslogics.format.swift.mt942.MT942Header;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MT940Booking
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    public static final String EREF = "EREF";
    public static final String SVWZ = "SVWZ";
    public static final String KREF = "KREF";
    public static final String MREF = "MREF";
    public static final String CRED = "CRED";
    public static final String OAMT = "OAMT";
    private static final String OCMT = "/OCMT/";
    private static final String CHGS = "/CHGS/";
    private static final String DELIMITER = "/";
    private final Object parent;
    private final Field61 field61;
    private final Field86 field86;

    public MT940Booking(Object parent, Field61 field61, Field86 field86) {
        this.parent = parent;
        this.field61 = field61;
        this.field86 = field86;
    }

    public Field61 getField61() {
        return this.field61;
    }

    public Field86 getField86() {
        return this.field86;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        if (this.field61 != null) {
            this.field61.writeTo(w);
        }
        if (this.field86 != null) {
            this.field86.writeTo(w);
        }
    }

    public Object getParent() {
        return this.parent;
    }

    public Currency getCurrency() {
        Object o = this.getParent();
        if (o instanceof MT940Header) {
            return ((MT940Header)o).getField60F().getCurrency();
        }
        if (o instanceof MT942Header) {
            return ((MT942Header)o).getField34F_1().getCurrency();
        }
        return null;
    }

    public Currency parseCurrency(String ocmt_chgs) {
        try {
            return Currency.getInstance(ocmt_chgs.substring(0, 3));
        }
        catch (IllegalArgumentException arg) {
            return null;
        }
    }

    public BigDecimal parseAmount(String ocmt_chgs) {
        return new BigDecimal(ocmt_chgs.substring(3).replace(',', '.'));
    }

    public String getOCMT() {
        return this.getTagContent(OCMT);
    }

    public String getCHGS() {
        return this.getTagContent(CHGS);
    }

    private String getTagContent(String tag) {
        String[] rawLines;
        String content = StringUtils.getContentBetweenTags(this.getField61().getAdditionalInformation(), tag, DELIMITER);
        if (content == null && this.getField86() != null && (rawLines = this.getField86().getRawLines()) != null && rawLines.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (String line : rawLines) {
                sb.append(line);
            }
            return StringUtils.getContentBetweenTags(sb.toString(), tag, DELIMITER);
        }
        return content;
    }

    private static String getIdentifier(String purposeLine) {
        if (purposeLine.indexOf("+") == 4) {
            return purposeLine.substring(0, 4);
        }
        return null;
    }

    public static Map<String, String> extractIdentifiers(String[] pArray) {
        String previousIdentifier = null;
        Object value = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (pArray != null && pArray.length > 0) {
            for (String p : pArray) {
                if (p == null) continue;
                String identifier = MT940Booking.getIdentifier(p);
                if (identifier != null) {
                    if (previousIdentifier != null) {
                        map.put(previousIdentifier, (String)value);
                    }
                    previousIdentifier = identifier;
                    value = p.substring(5);
                    continue;
                }
                if (previousIdentifier == null) continue;
                value = value + p;
            }
            if (previousIdentifier != null) {
                map.put(previousIdentifier, (String)value);
            }
        }
        return map;
    }
}

