/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt940;

import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Field86HandlerSG {
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String NEWLINE = "\n";
    private static final String TEMP_TOKEN = "_";
    public static final String ROC = "ROC";
    private static final String FROM = "FROM:";
    private static final String BEN = "BEN:";
    public static final String BNK = "BNK:";
    public static final String ACT = "ACT:";
    public static final String PURP = "PURP";
    public static final String RTRN = "RTRN";
    private static final String REMI = "REMI";
    public static final String CPRP = "CPRP";
    public static final String ORDP = "ORDP";
    public static final String ULTB = "ULTB";
    public static final String ULTD = "ULTD";
    public static final String IREF = "IREF";
    public static final String MARF = "MARF";
    public static final String SVCL = "SVCL";
    public static final String CSID = "CSID";
    private static final String INFO = "INFO";
    private static final String CHGS = "CHGS";
    private static final String OCMT = "OCMT";
    public static final String EXCH = "/EXCH/";
    public static final String BL_COUNTER_PARTY = "BL_COUNTER_PARTY";
    public static final String BL_BOOKING_TEXT = "BL_BOOKING_TEXT";
    public static final String BL_END_TO_END_ID = "BL_END_TO_END_ID";
    public static final String BL_TOTAL_PURPOSE = "BL_TOTAL_PURPOSE";
    public static final String BL_PURPOSE_OVERVIEW = "BL_PURPOSE_OVERVIEW";
    public static final String BL_FIRST_PURPOSE_LINE = "BL_FIRST_PURPOSE_LINE";
    public static final String BL_CHGS = "BL_CHGS";
    public static final String BL_CHGS_CURRENCY = "BL_CHGS_CURRENCY";
    public static final String BL_OCMT = "BL_OCMT";
    public static final String BL_OCMT_CURRENCY = "BL_OCMT_CURRENCY";
    private static final Set<String> KEYWORDS = new HashSet<String>();
    private static final Set<String> UNHANDLED_KEYWORDS = new HashSet<String>();
    private static final Set<String> KEYWORDS_SPACE_NOT_ALLOWED = new HashSet<String>();

    public static Map<String, String> evaluateStructuredPurpose(String[] pArray) {
        HashMap<String, String> identifierMap = new HashMap<String, String>();
        if (pArray != null && pArray.length >= 1 && pArray[0] != null) {
            String firstLine = pArray[0].trim();
            identifierMap.put(BL_FIRST_PURPOSE_LINE, firstLine);
            Field86HandlerSG.evaluateFirstLine(identifierMap, firstLine);
            int countLines = pArray.length;
            if (countLines >= 2 && pArray[1] != null) {
                StringBuilder sb = new StringBuilder();
                Field86HandlerSG.evaluateSecondLine(identifierMap, pArray[1].trim(), sb);
                if (identifierMap.containsKey(BL_COUNTER_PARTY)) {
                    if (countLines > 2) {
                        ArrayList<String> lines = new ArrayList<String>();
                        for (int i = 2; i < countLines; ++i) {
                            sb.append(pArray[i]);
                            lines.add(pArray[i]);
                        }
                        String concatenatedLines = sb.toString();
                        String remainingInfo1 = Field86HandlerSG.evaluateRemainingLines(identifierMap, concatenatedLines);
                        String remainingInfo2 = null;
                        if (concatenatedLines.contains(COLON)) {
                            remainingInfo2 = Field86HandlerSG.evaluateRemainingLines(identifierMap, lines);
                        }
                        Field86HandlerSG.setTotalPurpose(identifierMap, firstLine, remainingInfo1, remainingInfo2);
                    }
                } else {
                    ArrayList<String> furtherLines = new ArrayList<String>(Arrays.asList(pArray).subList(1, countLines));
                    Field86HandlerSG.evaluateBookingWithoutCounterParty(identifierMap, firstLine, furtherLines);
                }
            } else {
                Field86HandlerSG.evaluateBookingWithoutCounterParty(identifierMap, firstLine, null);
            }
        }
        if (identifierMap.size() > 0) {
            Field86HandlerSG.setPurposeOverview(identifierMap);
            return identifierMap;
        }
        return null;
    }

    private static void setTotalPurpose(Map<String, String> identifierMap, String firstLine, String remainingInfo1, String remainingInfo2) {
        if (identifierMap.containsKey(REMI)) {
            Object totalPurpose = identifierMap.get(REMI);
            if (remainingInfo1.length() > 0) {
                totalPurpose = (String)totalPurpose + NEWLINE + remainingInfo1;
            }
            identifierMap.put(BL_TOTAL_PURPOSE, (String)totalPurpose);
        } else if (identifierMap.containsKey(INFO)) {
            Object totalPurpose = identifierMap.get(INFO);
            if (remainingInfo2 != null && remainingInfo2.length() > 0) {
                totalPurpose = (String)totalPurpose + NEWLINE + remainingInfo2;
            }
            identifierMap.put(BL_TOTAL_PURPOSE, (String)totalPurpose);
        } else if (remainingInfo2 != null) {
            identifierMap.put(BL_TOTAL_PURPOSE, Field86HandlerSG.getTotalPurpose(firstLine, remainingInfo2));
        } else {
            identifierMap.put(BL_TOTAL_PURPOSE, Field86HandlerSG.getTotalPurpose(firstLine, remainingInfo1));
        }
    }

    private static String getTotalPurpose(String firstLine, String remainingInfo) {
        if (remainingInfo.length() > 0) {
            return firstLine + NEWLINE + remainingInfo;
        }
        return firstLine;
    }

    private static void setPurposeOverview(Map<String, String> identifierMap) {
        String purpose = identifierMap.get(REMI);
        if (purpose != null && purpose.length() > 0) {
            identifierMap.put(BL_PURPOSE_OVERVIEW, purpose);
            return;
        }
        purpose = identifierMap.get(INFO);
        if (purpose != null && purpose.length() > 0) {
            identifierMap.put(BL_PURPOSE_OVERVIEW, purpose);
            return;
        }
        purpose = identifierMap.get(BL_FIRST_PURPOSE_LINE);
        if (purpose != null && purpose.length() > 0) {
            identifierMap.put(BL_PURPOSE_OVERVIEW, purpose);
        }
    }

    private static void evaluateBookingWithoutCounterParty(Map<String, String> identifierMap, String firstLine, List<String> furtherLines) {
        if (identifierMap.size() > 0) {
            if (furtherLines != null) {
                String concatenatedLines = Field86HandlerSG.appendLines(furtherLines);
                String remainingInfo1 = Field86HandlerSG.evaluateRemainingLines(identifierMap, concatenatedLines);
                String remainingInfo2 = null;
                if (concatenatedLines.contains(COLON)) {
                    remainingInfo2 = Field86HandlerSG.evaluateRemainingLines(identifierMap, furtherLines);
                }
                Field86HandlerSG.setTotalPurpose(identifierMap, firstLine, remainingInfo1, remainingInfo2);
            } else if (firstLine != null && !firstLine.isEmpty()) {
                Field86HandlerSG.setTotalPurpose(identifierMap, firstLine, "", null);
            }
        }
    }

    private static String appendLines(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
        }
        return sb.toString();
    }

    private static void evaluateFirstLine(Map<String, String> identifierMap, String line1) {
        int posSlash = line1.indexOf(SLASH);
        if (posSlash > 0) {
            identifierMap.put(BL_BOOKING_TEXT, line1.substring(0, posSlash));
            String secondPart = line1.substring(posSlash + 1);
            if (secondPart.startsWith("ROC/")) {
                identifierMap.put(ROC, secondPart.substring(4));
            } else {
                identifierMap.put(BL_END_TO_END_ID, secondPart);
            }
        } else {
            identifierMap.put(BL_BOOKING_TEXT, line1);
        }
    }

    private static void evaluateSecondLine(Map<String, String> identifierMap, String line2, StringBuilder remaingInfo) {
        if (line2.startsWith(FROM)) {
            Field86HandlerSG.evaluateCounterParty(identifierMap, FROM, line2, remaingInfo);
        } else if (line2.startsWith(BEN)) {
            Field86HandlerSG.evaluateCounterParty(identifierMap, BEN, line2, remaingInfo);
        }
    }

    private static void evaluateCounterParty(Map<String, String> identifierMap, String counterPartyKeyword, String line2, StringBuilder remainingInfo) {
        int posBnk = line2.indexOf(BNK);
        int posAct = line2.indexOf(ACT);
        if (posBnk >= 0) {
            identifierMap.put(BL_COUNTER_PARTY, line2.substring(counterPartyKeyword.length(), posBnk).trim());
            if (posAct > posBnk + BNK.length()) {
                identifierMap.put(BNK, line2.substring(posBnk + BNK.length(), posAct).trim());
                String accountNumber = line2.substring(posAct + ACT.length()).trim();
                identifierMap.put(ACT, Field86HandlerSG.removeAdditionalInfo(accountNumber, remainingInfo));
            } else {
                String bankCode = line2.substring(posBnk + BNK.length()).trim();
                identifierMap.put(BNK, Field86HandlerSG.removeAdditionalInfo(bankCode, remainingInfo));
            }
        } else if (posAct > 0) {
            identifierMap.put(BL_COUNTER_PARTY, line2.substring(counterPartyKeyword.length(), posAct).trim());
            String accountNumber = line2.substring(posAct + ACT.length()).trim();
            identifierMap.put(ACT, Field86HandlerSG.removeAdditionalInfo(accountNumber, remainingInfo));
        } else {
            String counterParty = line2.substring(counterPartyKeyword.length()).trim();
            identifierMap.put(BL_COUNTER_PARTY, Field86HandlerSG.removeAdditionalInfo(counterParty, remainingInfo));
        }
    }

    private static String removeAdditionalInfo(String s, StringBuilder remainingInfo) {
        int posSlash = s.indexOf(SLASH);
        if (posSlash > 0) {
            remainingInfo.append(s.substring(posSlash));
            s = s.substring(0, posSlash);
        }
        return s;
    }

    static String evaluateRemainingLines(Map<String, String> identifierMap, String line) {
        line = Field86HandlerSG.insertTempTokens(line);
        StringTokenizer st = new StringTokenizer(line, SLASH);
        StringBuilder remainingInfo = new StringBuilder();
        String keyWord = null;
        String unhandledKeyWord = null;
        StringBuilder value = null;
        int tokenPosition = 0;
        while (st.hasMoreTokens()) {
            ++tokenPosition;
            String token = st.nextToken();
            if (KEYWORDS.contains(token)) {
                if (value != null) {
                    if (keyWord != null) {
                        Field86HandlerSG.store(identifierMap, keyWord, value.toString(), remainingInfo);
                    } else if (unhandledKeyWord != null) {
                        remainingInfo.append(SLASH).append(unhandledKeyWord).append(SLASH).append((CharSequence)value);
                    } else {
                        Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, value.toString());
                    }
                } else if (keyWord != null) {
                    Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, keyWord);
                } else if (unhandledKeyWord != null) {
                    Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, unhandledKeyWord);
                }
                keyWord = token;
                unhandledKeyWord = null;
                value = null;
                continue;
            }
            if (UNHANDLED_KEYWORDS.contains(token)) {
                if (value != null) {
                    if (keyWord != null) {
                        Field86HandlerSG.store(identifierMap, keyWord, value.toString(), remainingInfo);
                    } else if (unhandledKeyWord != null) {
                        remainingInfo.append(SLASH).append(unhandledKeyWord).append(SLASH).append((CharSequence)value);
                    } else {
                        Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, value.toString());
                    }
                } else if (keyWord != null) {
                    Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, keyWord);
                } else if (unhandledKeyWord != null) {
                    Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, unhandledKeyWord);
                }
                keyWord = null;
                unhandledKeyWord = token;
                value = null;
                continue;
            }
            if (value == null) {
                value = new StringBuilder();
            } else {
                value.append(SLASH);
            }
            if (token.equals(TEMP_TOKEN)) continue;
            value.append(token);
        }
        if (value != null) {
            if (keyWord != null) {
                Field86HandlerSG.store(identifierMap, keyWord, value.toString(), remainingInfo);
            } else if (unhandledKeyWord != null) {
                remainingInfo.append(SLASH).append(unhandledKeyWord).append(SLASH).append((CharSequence)value);
            } else {
                Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, value.toString());
            }
        } else if (keyWord != null) {
            Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, keyWord);
        } else if (unhandledKeyWord != null) {
            Field86HandlerSG.appendUnexpectedToken(remainingInfo, tokenPosition, unhandledKeyWord);
        }
        return remainingInfo.toString();
    }

    private static String insertTempTokens(String s) {
        StringBuilder sb = new StringBuilder();
        int previousChar = 32;
        int countChars = s.length();
        for (int i = 0; i < countChars; ++i) {
            char currentChar = s.charAt(i);
            if (currentChar == '/' && previousChar == 47) {
                sb.append(TEMP_TOKEN);
            }
            sb.append(currentChar);
            previousChar = currentChar;
        }
        return sb.toString();
    }

    private static void store(Map<String, String> identifierMap, String key, String value, StringBuilder remainingInfo) {
        int firstSpace = value.indexOf(" ");
        if (firstSpace > 0 && !Field86HandlerSG.isSpaceAllowed(key)) {
            identifierMap.put(key, Field86HandlerSG.removeFinalSlash(value.substring(0, firstSpace)));
            remainingInfo.append(value.substring(firstSpace));
        } else {
            identifierMap.put(key, Field86HandlerSG.removeFinalSlash(value));
        }
    }

    private static boolean isSpaceAllowed(String key) {
        return !KEYWORDS_SPACE_NOT_ALLOWED.contains(key);
    }

    private static String removeFinalSlash(String s) {
        if (s.endsWith(SLASH)) {
            return s.substring(0, s.lastIndexOf(SLASH));
        }
        return s;
    }

    private static void appendUnexpectedToken(StringBuilder remainingInfo, int tokenPosition, String token) {
        if (tokenPosition > 2) {
            remainingInfo.append(SLASH);
        }
        remainingInfo.append(token);
    }

    private static String evaluateRemainingLines(Map<String, String> identifierMap, List<String> lines) {
        StringBuilder remainingInfo = new StringBuilder();
        for (String line : lines) {
            Field86HandlerSG.evaluateLine(line, identifierMap, remainingInfo);
        }
        return remainingInfo.toString();
    }

    private static void evaluateLine(String line, Map<String, String> identifierMap, StringBuilder remainingInfo) {
        StringTokenizer st = new StringTokenizer(line, COLON);
        if (st.countTokens() > 2) {
            Field86HandlerSG.evaluateLineWithMultipleColons(st, identifierMap, remainingInfo);
        } else {
            int posColon = line.indexOf(COLON);
            if (posColon > 0) {
                String token = line.substring(0, posColon).trim();
                if (KEYWORDS.contains(token)) {
                    String remainingLine = line.substring(posColon + 1).trim();
                    if (OCMT.equals(token)) {
                        if (!Field86HandlerSG.evaluateOriginalAmount(identifierMap, remainingLine)) {
                            remainingInfo.append(line);
                        }
                    } else if (CHGS.equals(token)) {
                        if (!Field86HandlerSG.evaluateCharges(identifierMap, remainingLine)) {
                            remainingInfo.append(line);
                        }
                    } else {
                        identifierMap.put(token, remainingLine);
                    }
                } else {
                    if (remainingInfo.length() > 0) {
                        remainingInfo.append(NEWLINE);
                    }
                    remainingInfo.append(line);
                }
            } else {
                if (remainingInfo.length() > 0) {
                    remainingInfo.append(NEWLINE);
                }
                remainingInfo.append(line);
            }
        }
    }

    private static void evaluateLineWithMultipleColons(StringTokenizer st, Map<String, String> identifierMap, StringBuilder remainingInfo) {
        String keyWord = null;
        String nextKeyWord = null;
        String value = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (KEYWORDS.contains(token)) {
                keyWord = token;
            } else {
                int lastPosSpace = token.lastIndexOf(32);
                if (lastPosSpace > 0 && st.hasMoreTokens()) {
                    String keyWordCandidate = token.substring(lastPosSpace + 1);
                    if (KEYWORDS.contains(keyWordCandidate)) {
                        nextKeyWord = keyWordCandidate;
                        value = token.substring(0, lastPosSpace);
                    } else {
                        value = token;
                    }
                } else {
                    value = token;
                }
            }
            if (keyWord == null || value == null) continue;
            identifierMap.put(keyWord, value);
            keyWord = nextKeyWord;
            nextKeyWord = null;
            value = null;
        }
        if (keyWord != null) {
            remainingInfo.append(keyWord);
        }
        if (value != null) {
            remainingInfo.append(value);
        }
        if (nextKeyWord != null) {
            remainingInfo.append(nextKeyWord);
        }
    }

    private static boolean evaluateOriginalAmount(Map<String, String> identifierMap, String remainingLine) {
        int posExch = remainingLine.indexOf(EXCH);
        if (posExch >= 4) {
            String ocmt = remainingLine.substring(0, posExch - 3);
            String ocmtCurrency = remainingLine.substring(posExch - 3, posExch);
            String exch = remainingLine.substring(posExch + EXCH.length());
            if (exch.endsWith(SLASH)) {
                exch = exch.substring(0, exch.length() - 1);
            }
            if (Field86HandlerSG.checkAmount(ocmt) && Field86HandlerSG.checkCurrency(ocmtCurrency) && Field86HandlerSG.checkAmount(exch)) {
                identifierMap.put(BL_OCMT, ocmt);
                identifierMap.put(BL_OCMT_CURRENCY, ocmtCurrency);
                identifierMap.put(EXCH, exch);
                return true;
            }
        } else {
            int length = remainingLine.length();
            String ocmt = remainingLine.substring(0, length - 3);
            String ocmtCurrency = remainingLine.substring(length - 3);
            if (Field86HandlerSG.checkAmount(ocmt) && Field86HandlerSG.checkCurrency(ocmtCurrency)) {
                identifierMap.put(BL_OCMT, ocmt);
                identifierMap.put(BL_OCMT_CURRENCY, ocmtCurrency);
                return true;
            }
        }
        return false;
    }

    private static boolean evaluateCharges(Map<String, String> identifierMap, String remainingLine) {
        int length = remainingLine.length();
        if (length >= 4) {
            String chgs = remainingLine.substring(0, length - 3);
            String chgsCurrency = remainingLine.substring(length - 3);
            if (Field86HandlerSG.checkAmount(chgs) && Field86HandlerSG.checkCurrency(chgsCurrency)) {
                identifierMap.put(BL_CHGS, chgs);
                identifierMap.put(BL_CHGS_CURRENCY, chgsCurrency);
                return true;
            }
        }
        return false;
    }

    private static boolean checkAmount(String val) {
        try {
            new BigDecimal(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkCurrency(String val) {
        try {
            Currency.getInstance(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        KEYWORDS.add(PURP);
        KEYWORDS.add(RTRN);
        KEYWORDS.add(REMI);
        KEYWORDS.add(INFO);
        KEYWORDS.add(CHGS);
        KEYWORDS.add(OCMT);
        KEYWORDS.add(IREF);
        KEYWORDS.add(MARF);
        KEYWORDS.add(CSID);
        UNHANDLED_KEYWORDS.add(CPRP);
        UNHANDLED_KEYWORDS.add(ORDP);
        UNHANDLED_KEYWORDS.add(ULTB);
        UNHANDLED_KEYWORDS.add(ULTD);
        UNHANDLED_KEYWORDS.add(SVCL);
        KEYWORDS_SPACE_NOT_ALLOWED.add(RTRN);
        KEYWORDS_SPACE_NOT_ALLOWED.add(CHGS);
        KEYWORDS_SPACE_NOT_ALLOWED.add(OCMT);
        KEYWORDS_SPACE_NOT_ALLOWED.add(CSID);
    }
}

