/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt940;

import de.businesslogics.format.sepa.SEPAReturnReasonCode;
import de.businesslogics.format.swift.mt940.BookingKey;
import de.businesslogics.format.swift.mt940.GVC;
import de.businesslogics.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CMUtil {
    private static final String[] REVERSAL_GVCs = new String[]{"108", "109", "110", "111", "159", "160", "183"};
    private static final String[] COLLECTIVE_GVCs = new String[]{"079", "098", "185", "188", "189", "190", "191", "192", "194", "195", "196", "197", "198"};
    private static final String[] DIRECT_DEBIT_GVCs = new String[]{"104", "105", "107", "108", "109", "171", "174", "181", "184", "192", "193", "195", "196", "197", "213"};
    private static final String[] SINGLE_POSITIVE_DIRECT_DEBIT_GVCs = new String[]{"171", "174"};
    private static final Map<String, String> TKA_SEPA_CODE_MAP = new HashMap<String, String>();

    public static final boolean isReversal(String gvc) {
        return StringUtils.isContainedInArray(gvc, REVERSAL_GVCs);
    }

    public static final boolean isCollectiveBooking(String gvc) {
        return StringUtils.isContainedInArray(gvc, COLLECTIVE_GVCs);
    }

    public static final boolean isDirectDebit(String gvc) {
        return StringUtils.isContainedInArray(gvc, DIRECT_DEBIT_GVCs);
    }

    public static final boolean isSinglePositiveDirectDebit(String gvc) {
        return StringUtils.isContainedInArray(gvc, SINGLE_POSITIVE_DIRECT_DEBIT_GVCs);
    }

    public static final boolean isSinglePositiveCreditTransfer(String gvc) {
        try {
            int i = Integer.parseInt(gvc);
            if (i >= 153 && i <= 157 || i >= 161 && i <= 169) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final boolean isDirectDebit(String gvc, String creditorId, String mandateReference) {
        if (StringUtils.isContainedInArray(gvc, DIRECT_DEBIT_GVCs)) {
            return true;
        }
        if (creditorId != null && creditorId.trim().length() > 0) {
            return true;
        }
        return mandateReference != null && mandateReference.trim().length() > 0;
    }

    public static final String getGvcWithDescription(String gvc, Locale l) {
        String desc;
        if (gvc != null && (desc = GVC.getText(gvc, l)) != null) {
            return gvc + " - " + desc;
        }
        return gvc;
    }

    public static final String getIsoBTC(String domain, String family, String subFamily, String gvc, Locale l) {
        if (domain != null) {
            return domain + "-" + family + "-" + subFamily;
        }
        return null;
    }

    public static final String getBookingKeyWithDescription(String bookingKey, Locale l) {
        String desc;
        if (bookingKey != null && (desc = BookingKey.getText(bookingKey, l)) != null) {
            return bookingKey + " - " + desc;
        }
        return bookingKey;
    }

    public static final String getTextKeyAppendixWithDescription(String textKeyAppendix, Locale l) {
        String sepaCode;
        if (textKeyAppendix != null && (sepaCode = TKA_SEPA_CODE_MAP.get(textKeyAppendix)) != null) {
            String description = SEPAReturnReasonCode.getDescription(sepaCode, l);
            if (description != null && description.length() > 4) {
                return textKeyAppendix + description.substring(4);
            }
            System.out.println("no SEPACode for " + sepaCode);
        }
        return textKeyAppendix;
    }

    public static final String getRejectionWithDescription(String rejectionCode, Locale l) {
        String description;
        if (rejectionCode != null && (description = SEPAReturnReasonCode.getDescription(rejectionCode, l)) != null) {
            return description;
        }
        return rejectionCode;
    }

    public static void main(String[] args) {
        for (String s : TKA_SEPA_CODE_MAP.keySet()) {
            System.out.println(s + " " + CMUtil.getTextKeyAppendixWithDescription(s, Locale.getDefault()));
        }
    }

    static {
        TKA_SEPA_CODE_MAP.put("901", "AC01");
        TKA_SEPA_CODE_MAP.put("902", "AC04");
        TKA_SEPA_CODE_MAP.put("903", "AC06");
        TKA_SEPA_CODE_MAP.put("904", "AG01");
        TKA_SEPA_CODE_MAP.put("905", "AG02");
        TKA_SEPA_CODE_MAP.put("906", "AM04");
        TKA_SEPA_CODE_MAP.put("907", "AM05");
        TKA_SEPA_CODE_MAP.put("908", "BE04");
        TKA_SEPA_CODE_MAP.put("909", "MD01");
        TKA_SEPA_CODE_MAP.put("910", "MD02");
        TKA_SEPA_CODE_MAP.put("911", "FF01");
        TKA_SEPA_CODE_MAP.put("912", "MD06");
        TKA_SEPA_CODE_MAP.put("913", "MD07");
        TKA_SEPA_CODE_MAP.put("914", "MS03");
        TKA_SEPA_CODE_MAP.put("915", "RC01");
        TKA_SEPA_CODE_MAP.put("916", "TM01");
        TKA_SEPA_CODE_MAP.put("917", "RR04");
        TKA_SEPA_CODE_MAP.put("918", "SL01");
        TKA_SEPA_CODE_MAP.put("919", "FOCR");
        TKA_SEPA_CODE_MAP.put("920", "DUPL");
        TKA_SEPA_CODE_MAP.put("921", "TECH");
        TKA_SEPA_CODE_MAP.put("922", "FRAD");
        TKA_SEPA_CODE_MAP.put("923", "AGNT");
        TKA_SEPA_CODE_MAP.put("924", "CURR");
        TKA_SEPA_CODE_MAP.put("925", "CUST");
        TKA_SEPA_CODE_MAP.put("926", "CUTA");
        TKA_SEPA_CODE_MAP.put("927", "UPAY");
        TKA_SEPA_CODE_MAP.put("928", "BE05");
        TKA_SEPA_CODE_MAP.put("929", "BE06");
        TKA_SEPA_CODE_MAP.put("930", "AC13");
        TKA_SEPA_CODE_MAP.put("932", "DNOR");
        TKA_SEPA_CODE_MAP.put("933", "CNOR");
        TKA_SEPA_CODE_MAP.put("934", "SVNR");
        TKA_SEPA_CODE_MAP.put("935", "AM09");
        TKA_SEPA_CODE_MAP.put("936", "EMVL");
        TKA_SEPA_CODE_MAP.put("937", "PINL");
        TKA_SEPA_CODE_MAP.put("938", "ED05");
        TKA_SEPA_CODE_MAP.put("991", "FRST");
        TKA_SEPA_CODE_MAP.put("992", "RCUR");
        TKA_SEPA_CODE_MAP.put("993", "OOFF");
        TKA_SEPA_CODE_MAP.put("994", "FNAL");
        TKA_SEPA_CODE_MAP.put("011", "CDQC");
        TKA_SEPA_CODE_MAP.put("030", "CDCB");
        TKA_SEPA_CODE_MAP.put("003", "CDCD");
        TKA_SEPA_CODE_MAP.put("023", "CDCS");
        TKA_SEPA_CODE_MAP.put("073", "MTUP");
        TKA_SEPA_CODE_MAP.put("240", "ETUP");
        TKA_SEPA_CODE_MAP.put("201", "CBLK");
        TKA_SEPA_CODE_MAP.put("210", "FCOL");
    }
}

