/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt202;

import de.businesslogics.format.swift.AccountServicingInstitution;
import de.businesslogics.format.swift.AccountWithInstitution;
import de.businesslogics.format.swift.BeneficiaryInstitution;
import de.businesslogics.format.swift.Field13C;
import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field21;
import de.businesslogics.format.swift.Field32A;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.swift.Field36;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.Field52D;
import de.businesslogics.format.swift.Field54A;
import de.businesslogics.format.swift.Field54D;
import de.businesslogics.format.swift.Field56A;
import de.businesslogics.format.swift.Field56D;
import de.businesslogics.format.swift.Field58A;
import de.businesslogics.format.swift.Field58D;
import de.businesslogics.format.swift.Field70;
import de.businesslogics.format.swift.Field71A;
import de.businesslogics.format.swift.Field71F;
import de.businesslogics.format.swift.Field71G;
import de.businesslogics.format.swift.Intermediary;
import de.businesslogics.format.swift.PartyIdentifier;
import de.businesslogics.format.swift.ReceiversCorrespondent;
import de.businesslogics.format.swift.SendersCorrespondent;
import de.businesslogics.format.swift.SwiftTransferMessage;
import java.io.IOException;
import java.io.Writer;

public class MT202Message
extends SwiftTransferMessage {
    private static final long serialVersionUID = 1L;
    private static final Field13C[] EMPTY_TIME_INDICATORS = new Field13C[0];
    private Field21 bankReference;
    private Field13C[] timeIndicators = EMPTY_TIME_INDICATORS;
    private AccountServicingInstitution accountServicingInstitution;
    private SendersCorrespondent sendersCorrespondent;
    private ReceiversCorrespondent receiversCorrespondent;
    private Intermediary intermediaryInstitution;
    private AccountWithInstitution accountWithInstitution;
    private BeneficiaryInstitution beneficiaryInstitution;

    public MT202Message(Field20 sendersReference, Field21 bankReference, Field32A settlementAmount, BeneficiaryInstitution beneficiaryInstitution) {
        super(sendersReference, settlementAmount);
        this.bankReference = bankReference;
        this.beneficiaryInstitution = beneficiaryInstitution;
    }

    public Field21 getBankReference() {
        return this.bankReference;
    }

    public void setBankReference(Field21 bankReference) {
        this.bankReference = bankReference;
    }

    public Field13C[] getTimeIndicators() {
        return this.timeIndicators;
    }

    public void setTimeIndicators(Field13C[] timeIndicators) {
        this.timeIndicators = timeIndicators;
    }

    public AccountServicingInstitution getAccountServicingInstitution() {
        return this.accountServicingInstitution;
    }

    @Override
    public void setAccountServicingInstitution(AccountServicingInstitution accountServicingInstitution) {
        this.accountServicingInstitution = accountServicingInstitution;
    }

    public SendersCorrespondent getSendersCorrespondent() {
        return this.sendersCorrespondent;
    }

    public void setSendersCorrespondent(SendersCorrespondent sendersCorrespondent) {
        this.sendersCorrespondent = sendersCorrespondent;
    }

    public ReceiversCorrespondent getReceiversCorrespondent() {
        return this.receiversCorrespondent;
    }

    @Override
    public void setReceiversCorrespondent(ReceiversCorrespondent receiversCorrespondent) {
        this.receiversCorrespondent = receiversCorrespondent;
    }

    public Intermediary getIntermediary() {
        return this.intermediaryInstitution;
    }

    @Override
    public void setIntermediary(Intermediary intermediaryInstitution) {
        this.intermediaryInstitution = intermediaryInstitution;
    }

    public AccountWithInstitution getAccountWithInstitution() {
        return this.accountWithInstitution;
    }

    @Override
    public void setAccountWithInstitution(AccountWithInstitution accountWithInstitution) {
        this.accountWithInstitution = accountWithInstitution;
    }

    public BeneficiaryInstitution getBeneficiaryInstitution() {
        return this.beneficiaryInstitution;
    }

    public void setBeneficiaryInstitution(BeneficiaryInstitution beneficiaryInstitution) {
        this.beneficiaryInstitution = beneficiaryInstitution;
    }

    @Override
    public String[] getLocalParty() {
        if (this.accountServicingInstitution != null && this.accountServicingInstitution instanceof Field52D) {
            return ((Field52D)this.accountServicingInstitution).getAddress();
        }
        return null;
    }

    @Override
    public String getLocalPartyBankCode() {
        if (this.accountServicingInstitution != null && this.accountServicingInstitution instanceof Field52A) {
            return ((Field52A)this.accountServicingInstitution).getBIC();
        }
        return null;
    }

    @Override
    public String getLocalPartyAccountNumber() {
        if (this.accountServicingInstitution != null) {
            PartyIdentifier partyIdentifier = null;
            if (this.accountServicingInstitution instanceof Field52A) {
                partyIdentifier = ((Field52A)this.accountServicingInstitution).getPartyIdentifier();
            } else if (this.accountServicingInstitution instanceof Field52D) {
                partyIdentifier = ((Field52D)this.accountServicingInstitution).getPartyIdentifier();
            }
            return partyIdentifier != null ? partyIdentifier.getAccountNumber() : null;
        }
        return null;
    }

    @Override
    public String[] getCounterPartyCorrespondentAddress() {
        if (this.receiversCorrespondent != null && this.receiversCorrespondent instanceof Field54D) {
            return ((Field54D)this.receiversCorrespondent).getAddress();
        }
        return null;
    }

    @Override
    public String getCounterPartyCorrespondentBIC() {
        if (this.receiversCorrespondent != null && this.receiversCorrespondent instanceof Field54A) {
            return ((Field54A)this.receiversCorrespondent).getBIC();
        }
        return null;
    }

    @Override
    public String[] getIntermediaryInstitutionAddress() {
        if (this.intermediaryInstitution != null && this.intermediaryInstitution instanceof Field56D) {
            return ((Field56D)this.intermediaryInstitution).getAddress();
        }
        return null;
    }

    @Override
    public String getIntermediaryInstitutionBIC() {
        if (this.intermediaryInstitution != null && this.intermediaryInstitution instanceof Field56A) {
            return ((Field56A)this.intermediaryInstitution).getBIC();
        }
        return null;
    }

    @Override
    public String[] getCounterParty() {
        if (this.beneficiaryInstitution != null && this.beneficiaryInstitution instanceof Field58D) {
            return ((Field58D)this.beneficiaryInstitution).getAddress();
        }
        return null;
    }

    @Override
    public String getCounterPartyBIC() {
        if (this.beneficiaryInstitution != null && this.beneficiaryInstitution instanceof Field58A) {
            return ((Field58A)this.beneficiaryInstitution).getBIC();
        }
        return null;
    }

    @Override
    public String getCounterPartyAccountNumber() {
        if (this.beneficiaryInstitution != null) {
            PartyIdentifier partyIdentifier = null;
            if (this.beneficiaryInstitution instanceof Field58A) {
                partyIdentifier = ((Field58A)this.beneficiaryInstitution).getPartyIdentifier();
            } else if (this.beneficiaryInstitution instanceof Field58D) {
                partyIdentifier = ((Field58D)this.beneficiaryInstitution).getPartyIdentifier();
            }
            return partyIdentifier != null ? partyIdentifier.getAccountNumber() : null;
        }
        return null;
    }

    @Override
    public String[] getPurpose() {
        if (this.getSenderToReceiverInformation() != null) {
            return this.getSenderToReceiverInformation().getInformation();
        }
        return null;
    }

    @Override
    public String[] getCounterPartyBankAddress() {
        return null;
    }

    @Override
    public String getCounterPartyBEI() {
        return null;
    }

    @Override
    public Field71A getDetailsOfCharges() {
        return null;
    }

    @Override
    public Field36 getExchangeRate() {
        return null;
    }

    @Override
    public Field33B getOriginalAmount() {
        return null;
    }

    @Override
    public void setExchangeRate(Field36 exchangeRate) {
    }

    @Override
    public void setOriginalAmount(Field33B originalAmount) {
    }

    @Override
    public void setReceiversCharges(Field71G receiversCharges) {
    }

    @Override
    public void setRemittanceInformation(Field70 remittanceInformation) {
    }

    @Override
    public void setSendersCharges(Field71F[] sendersCharges) {
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        this.writeTo(w, false);
    }

    public void writeTo(Writer w, boolean withSwiftHeader) throws IOException {
        if (withSwiftHeader) {
            w.write("{4:");
            w.write("\r\n");
        }
        this.getSendersReference().writeTo(w);
        this.bankReference.writeTo(w);
        for (int i = 0; i < this.timeIndicators.length; ++i) {
            this.timeIndicators[i].writeTo(w);
        }
        this.getSettlementAmount().writeTo(w);
        if (this.accountServicingInstitution != null) {
            this.accountServicingInstitution.writeTo(w);
        }
        if (this.sendersCorrespondent != null) {
            this.sendersCorrespondent.writeTo(w);
        }
        if (this.receiversCorrespondent != null) {
            this.receiversCorrespondent.writeTo(w);
        }
        if (this.intermediaryInstitution != null) {
            this.intermediaryInstitution.writeTo(w);
        }
        if (this.accountWithInstitution != null) {
            this.accountWithInstitution.writeTo(w);
        }
        this.beneficiaryInstitution.writeTo(w);
        if (this.getSenderToReceiverInformation() != null) {
            this.getSenderToReceiverInformation().writeTo(w);
        }
        w.write("-");
        if (withSwiftHeader) {
            w.write("}");
        } else {
            w.write("\r\n");
        }
    }
}

