/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt101.csv;

import de.businesslogics.format.csv.BaseCSVFormatParser;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.format.swift.mt101.csv.Format;
import de.businesslogics.util.DateUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class MT101CSVFormatParser
extends BaseCSVFormatParser {
    public MT101CSVFormatParser(Format format) {
        super(format);
    }

    @Override
    protected String validateRow(String[] row) {
        String error = this.checkString(row, this.format.getColumn(Format.Fields.ORIGINATOR_BIC), RegularExpressions.BIC);
        if (error != null) {
            return error;
        }
        error = this.checkString(row, this.format.getColumn(Format.Fields.SENDER_BIC), RegularExpressions.BIC);
        if (error != null) {
            return error;
        }
        error = this.checkString(row, this.format.getColumn(Format.Fields.RECEIVER_BIC), RegularExpressions.BIC);
        if (error != null) {
            return error;
        }
        error = this.checkAmount(row, this.format.getColumn(Format.Fields.AMOUNT));
        if (error != null) {
            return error;
        }
        error = this.checkDate(row, this.format.getColumn(Format.Fields.DATE));
        if (error != null) {
            return error;
        }
        return null;
    }

    @Override
    protected String getValidString(String s, int maxFieldLength) {
        if (s == null) {
            return null;
        }
        if (s.length() <= maxFieldLength) {
            return s;
        }
        return s.substring(0, maxFieldLength);
    }

    public MT101PaymentData getPaymentData(String[] row, int line) throws CSVConverterException {
        MT101PaymentData payment = new MT101PaymentData();
        String[] originatorArray = new String[]{this.getString(row, line, this.format.getColumn(Format.Fields.ORIGINATOR1), true), this.getString(row, line, this.format.getColumn(Format.Fields.ORIGINATOR2), false), this.getString(row, line, this.format.getColumn(Format.Fields.ORIGINATOR3), false), this.getString(row, line, this.format.getColumn(Format.Fields.ORIGINATOR4), false)};
        originatorArray = StringUtils.formatSwiftArray(originatorArray, 4, 35);
        payment.setOriginatorAddress(originatorArray);
        payment.setOriginatorAccount(this.getString(row, line, this.format.getColumn(Format.Fields.ORIGINATOR_ACCOUNT_NUMBER), true));
        payment.setOriginatorBic(this.getString(row, line, this.format.getColumn(Format.Fields.ORIGINATOR_BIC), true));
        payment.setSenderBic(this.getString(row, line, this.format.getColumn(Format.Fields.SENDER_BIC), true));
        payment.setReceiverBic(this.getString(row, line, this.format.getColumn(Format.Fields.RECEIVER_BIC), true));
        String[] recipientArray = new String[]{this.getString(row, line, this.format.getColumn(Format.Fields.RECIPIENT1), true), this.getString(row, line, this.format.getColumn(Format.Fields.RECIPIENT2), false), this.getString(row, line, this.format.getColumn(Format.Fields.RECIPIENT3), false), this.getString(row, line, this.format.getColumn(Format.Fields.RECIPIENT4), false)};
        recipientArray = StringUtils.formatSwiftArray(recipientArray, 4, 35);
        payment.setRecipientAddress(recipientArray);
        payment.setRecipientAccount(this.getString(row, line, this.format.getColumn(Format.Fields.RECIPIENT_ACCOUNT_NUMBER), true));
        payment.setRecipientBankCode(this.getString(row, line, this.format.getColumn(Format.Fields.RECIPIENT_BANK_CODE), true));
        payment.setIntermediaryBankCode(this.getString(row, line, this.format.getColumn(Format.Fields.INTERMEDIARY_BANK_CODE), false));
        BigDecimal amount = this.getAmount(row, line, this.format.getColumn(Format.Fields.AMOUNT));
        payment.setAmount(amount);
        payment.setCurrency(this.getCurrency(row, line, this.format.getColumn(Format.Fields.CURRENCY), true));
        Date executionDate = this.getDate(row, line, this.format.getColumn(Format.Fields.DATE), false);
        if (executionDate == null) {
            executionDate = DateUtils.getNextWorkingDay(Calendar.getInstance()).getTime();
        }
        payment.setExecutionDate(executionDate);
        String[] purposeArray = new String[]{this.getString(row, line, this.format.getColumn(Format.Fields.PURPOSE1), false), this.getString(row, line, this.format.getColumn(Format.Fields.PURPOSE2), false), this.getString(row, line, this.format.getColumn(Format.Fields.PURPOSE3), false), this.getString(row, line, this.format.getColumn(Format.Fields.PURPOSE4), false)};
        purposeArray = StringUtils.formatSwiftArray(purposeArray, 4, 35);
        payment.setPurposeArray(purposeArray);
        payment.setTransactionReference(this.getString(row, line, this.format.getColumn(Format.Fields.TRANSACTON_REFERENCE), false));
        payment.setFeeType(this.checkValue(row, line, this.format.getColumn(Format.Fields.FEE_TYPE), true, MT101PaymentData.FEE_TYPES));
        return payment;
    }
}

