/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt101.csv;

import de.businesslogics.format.csv.AbstractFormat;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.sepa.csv.FieldI;
import de.businesslogics.validation.RegularExpressions;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.util.CellReference;

public class Format
extends AbstractFormat {
    public static char MT101_SEPARATOR = (char)124;
    public static Format DEFAULT_FORMAT = new Format(Fields.ORIGINATOR1, Fields.ORIGINATOR2, Fields.ORIGINATOR3, Fields.ORIGINATOR4, Fields.ORIGINATOR_ACCOUNT_NUMBER, Fields.ORIGINATOR_BIC, Fields.SENDER_BIC, Fields.RECEIVER_BIC, Fields.RECIPIENT1, Fields.RECIPIENT2, Fields.RECIPIENT3, Fields.RECIPIENT4, Fields.RECIPIENT_ACCOUNT_NUMBER, Fields.RECIPIENT_BANK_CODE, Fields.INTERMEDIARY_BANK_CODE, Fields.AMOUNT, Fields.CURRENCY, Fields.COUNTER_VALUE_CURRENCY, Fields.DATE, Fields.PURPOSE1, Fields.PURPOSE2, Fields.PURPOSE3, Fields.PURPOSE4, Fields.TRANSACTON_REFERENCE, Fields.FEE_TYPE);
    private final Map<Fields, Column> mapping = new HashMap<Fields, Column>();
    private int minimum = -1;

    public Format(String definition, String language) {
        String[] columns;
        if (language != null) {
            this.numberFormat = NumberFormat.getInstance(new Locale(language));
        }
        if ((columns = definition.split("\\" + this.getSeparator())) == null || columns.length <= 1) {
            columns = definition.split(",");
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].length() <= 0) continue;
            Fields f = Fields.values()[i];
            if (columns[i].startsWith("=")) {
                this.mapping.put(f, new Column(columns[i].substring(1), f.name(), f.maxLength, f.pattern));
                continue;
            }
            try {
                this.mapping.put(f, new Column(Integer.parseInt(columns[i]), f.name(), f.maxLength, f.pattern));
                continue;
            }
            catch (NumberFormatException nf) {
                this.mapping.put(f, new Column(CellReference.convertColStringToIndex((String)columns[i]), f.name(), f.maxLength, f.pattern));
            }
        }
    }

    private Format(Fields ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            Fields field = fields[i];
            this.mapping.put(field, new Column(i, field.name(), field.maxLength, field.pattern));
        }
    }

    @Override
    public FieldI[] getFields() {
        return Fields.values();
    }

    @Override
    public char getSeparator() {
        return MT101_SEPARATOR;
    }

    @Override
    public Column getColumn(FieldI field) {
        return this.mapping.get(field);
    }

    @Override
    public int minimumColumns() {
        if (this.minimum < 0) {
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.ORIGINATOR1).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.ORIGINATOR_ACCOUNT_NUMBER).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.ORIGINATOR_BIC).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.SENDER_BIC).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.RECEIVER_BIC).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.RECIPIENT1).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.RECIPIENT_ACCOUNT_NUMBER).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.RECIPIENT_BANK_CODE).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.AMOUNT).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.CURRENCY).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.FEE_TYPE).getColumnIndex());
        }
        return this.minimum;
    }

    public static enum Fields implements FieldI,
    Serializable
    {
        ORIGINATOR1(35),
        ORIGINATOR2(35),
        ORIGINATOR3(35),
        ORIGINATOR4(35),
        ORIGINATOR_ACCOUNT_NUMBER(34),
        ORIGINATOR_BIC(RegularExpressions.BIC),
        SENDER_BIC(RegularExpressions.BIC),
        RECEIVER_BIC(RegularExpressions.BIC),
        RECIPIENT1(35),
        RECIPIENT2(35),
        RECIPIENT3(35),
        RECIPIENT4(35),
        RECIPIENT_ACCOUNT_NUMBER(34),
        RECIPIENT_BANK_CODE(34),
        INTERMEDIARY_BANK_CODE(34),
        AMOUNT(-1),
        CURRENCY(3),
        COUNTER_VALUE_CURRENCY(3),
        DATE(-1),
        PURPOSE1(35),
        PURPOSE2(35),
        PURPOSE3(35),
        PURPOSE4(35),
        TRANSACTON_REFERENCE(16),
        FEE_TYPE(3);

        private int maxLength = -1;
        private RegularExpressions pattern;

        private Fields(int maxLength) {
            this.maxLength = maxLength;
        }

        private Fields(RegularExpressions pattern) {
            this.pattern = pattern;
        }
    }
}

