/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt101.csv;

import de.businesslogics.format.csv.CSVConverterUtil;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.format.swift.mt101.MT101SeqNumberGenerator;
import de.businesslogics.format.swift.mt101.csv.Format;
import de.businesslogics.format.swift.mt101.csv.MT101CSVFormatParser;
import de.businesslogics.format.swift.mt101.csv.MT101XLSFormatParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.xml.sax.SAXException;

public class Converter {
    private static Charset getCharset(String encoding) {
        if (encoding != null) {
            try {
                return Charset.forName(encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCSVFile(File in, Format format, boolean hasHeader) {
        MT101CSVFormatParser p = new MT101CSVFormatParser(format);
        try (FileReader fr = new FileReader(in);
             BufferedReader r = new BufferedReader(fr);){
            String line = r.readLine();
            boolean hasReadHeader = !hasHeader;
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] row = CSVConverterUtil.splitLineAndTrim(line);
                    if (p.checkRow(row) == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (hasReadHeader) {
                        boolean bl = false;
                        return bl;
                    }
                    hasReadHeader = true;
                }
                line = r.readLine();
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List<File> convertCSVFile(File csvFile, Format format, boolean hasHeader, MT101SeqNumberGenerator seqNumberGenerator, boolean oneLogicalFilePerOrder, boolean withSwiftHeader, String encoding) throws IOException, SAXException {
        boolean hasReadHeader = !hasHeader;
        Charset charset = Converter.getCharset(encoding);
        BufferedReader r = charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), charset)) : new BufferedReader(new FileReader(csvFile));
        ArrayList<MT101PaymentData> payments = new ArrayList<MT101PaymentData>();
        String line = r.readLine();
        int lineCounter = 0;
        MT101CSVFormatParser parser = new MT101CSVFormatParser(format);
        while (line != null) {
            ++lineCounter;
            if (line.trim().length() > 0) {
                String[] row = CSVConverterUtil.splitLineAndTrim(line);
                if (!hasReadHeader) {
                    hasReadHeader = true;
                    if (parser.checkRow(row) != null) {
                        line = r.readLine();
                        continue;
                    }
                }
                payments.add(parser.getPaymentData(row, lineCounter - 1));
            }
            line = r.readLine();
        }
        r.close();
        return Converter.writeFiles(payments, csvFile, seqNumberGenerator, oneLogicalFilePerOrder, withSwiftHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkXLS(File f, Format format, boolean hasHeader) {
        Workbook workbook = null;
        MT101XLSFormatParser p = new MT101XLSFormatParser(format);
        try {
            workbook = XLSUtil.createWorkbook(f);
        }
        catch (Exception format1) {
            int n = -1;
            return n;
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        block11: for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            boolean hasReadHeader;
            Sheet sheet = workbook.getSheetAt(i);
            boolean bl = hasReadHeader = !hasHeader;
            for (int row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                Row r = sheet.getRow(row);
                if (r == null) continue;
                if (p.checkRow(r) == null) {
                    return i;
                }
                if (hasReadHeader) continue block11;
                hasReadHeader = true;
            }
        }
        return -1;
    }

    public static List<File> convertXLS(File xlsFile, int sheetIndex, Format format, boolean hasHeader, MT101SeqNumberGenerator seqNumberGenerator, boolean oneLogicalFilePerOrder, boolean withSwiftHeader) throws IOException, SAXException {
        try (Workbook workbook = XLSUtil.createWorkbook(xlsFile);){
            int startRow;
            MT101XLSFormatParser parser = new MT101XLSFormatParser(format);
            if (sheetIndex < 0 || sheetIndex >= workbook.getNumberOfSheets()) {
                throw new IOException("No sheet with index = " + sheetIndex);
            }
            Sheet sheet = workbook.getSheetAt(sheetIndex);
            ArrayList<MT101PaymentData> payments = new ArrayList<MT101PaymentData>();
            boolean hasReadHeader = !hasHeader;
            for (int i = startRow = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                if (!hasReadHeader) {
                    hasReadHeader = true;
                    if (parser.checkRow(row) != null) continue;
                }
                if (XLSUtil.isEmpty(row)) continue;
                payments.add(parser.getPaymentData(row));
            }
            List<File> list = Converter.writeFiles(payments, xlsFile, seqNumberGenerator, oneLogicalFilePerOrder, withSwiftHeader);
            return list;
        }
    }

    private static List<File> writeFiles(List<MT101PaymentData> payments, File originalFile, MT101SeqNumberGenerator seqNumberGenerator, boolean oneLogicalFilePerOrder, boolean withSwiftHeader) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        HashMap logicalFilesMap = new HashMap();
        for (MT101PaymentData payment : payments) {
            String logicalFileKey = payment.getLogicalFileKey();
            if (logicalFilesMap.containsKey(logicalFileKey)) {
                ((List)logicalFilesMap.get(logicalFileKey)).add(payment);
                continue;
            }
            ArrayList<MT101PaymentData> list = new ArrayList<MT101PaymentData>();
            list.add(payment);
            logicalFilesMap.put(logicalFileKey, list);
        }
        if (oneLogicalFilePerOrder) {
            for (List mergedPayments : logicalFilesMap.values()) {
                files.add(Converter.createFile(mergedPayments, originalFile, seqNumberGenerator, withSwiftHeader));
            }
        } else {
            files.add(Converter.createFile(logicalFilesMap.values(), originalFile, seqNumberGenerator, withSwiftHeader));
        }
        return files;
    }

    private static File createFile(List<MT101PaymentData> mergedPayments, File originalFile, MT101SeqNumberGenerator seqNumberGenerator, boolean withSwiftHeader) throws IOException {
        File mt101File = File.createTempFile(originalFile.getName() + ".", ".MT101", originalFile.getParentFile());
        try (FileOutputStream out = new FileOutputStream(mt101File);){
            MT101PaymentData firstPayment = mergedPayments.get(0);
            int senderReference = seqNumberGenerator != null ? seqNumberGenerator.getSenderReference() : 0;
            firstPayment.setSenderReference(String.valueOf(senderReference));
            String transactionReference = firstPayment.getTransactionReference();
            if (transactionReference == null || transactionReference.trim().length() == 0) {
                firstPayment.setTransactionReference(senderReference + "-1");
            }
            MT101LogicalFile logicalFile = new MT101LogicalFile(firstPayment);
            for (int i = 1; i < mergedPayments.size(); ++i) {
                MT101PaymentData furtherPayment = mergedPayments.get(i);
                transactionReference = furtherPayment.getTransactionReference();
                if (transactionReference == null || transactionReference.trim().length() == 0) {
                    furtherPayment.setTransactionReference(senderReference + "-" + (i + 1));
                }
                logicalFile.getPayments().add(furtherPayment);
            }
            logicalFile.save(out, withSwiftHeader, false, senderReference, senderReference);
        }
        return mt101File;
    }

    private static File createFile(Collection<List<MT101PaymentData>> logicalFiles, File originalFile, MT101SeqNumberGenerator seqNumberGenerator, boolean withSwiftHeader) throws IOException {
        File mt101File = File.createTempFile(originalFile.getName() + ".", ".MT101", originalFile.getParentFile());
        try (FileOutputStream out = new FileOutputStream(mt101File);){
            for (List<MT101PaymentData> payments : logicalFiles) {
                MT101PaymentData firstPayment = payments.get(0);
                int senderReference = seqNumberGenerator != null ? seqNumberGenerator.getSenderReference() : 0;
                firstPayment.setSenderReference(String.valueOf(senderReference));
                String transactionReference = firstPayment.getTransactionReference();
                if (transactionReference == null || transactionReference.trim().length() == 0) {
                    firstPayment.setTransactionReference(senderReference + "-1");
                }
                MT101LogicalFile logicalFile = new MT101LogicalFile(firstPayment);
                for (int i = 1; i < payments.size(); ++i) {
                    MT101PaymentData furtherPayment = payments.get(i);
                    transactionReference = furtherPayment.getTransactionReference();
                    if (transactionReference == null || transactionReference.trim().length() == 0) {
                        furtherPayment.setTransactionReference(senderReference + "-" + (i + 1));
                    }
                    logicalFile.getPayments().add(furtherPayment);
                }
                logicalFile.save(out, withSwiftHeader, false, senderReference, senderReference);
            }
        }
        return mt101File;
    }
}

