/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt101;

import de.businesslogics.format.swift.AccountServicingInstitution;
import de.businesslogics.format.swift.AccountWithInstitution;
import de.businesslogics.format.swift.Beneficiary;
import de.businesslogics.format.swift.Field21;
import de.businesslogics.format.swift.Field23E;
import de.businesslogics.format.swift.Field25A;
import de.businesslogics.format.swift.Field32B;
import de.businesslogics.format.swift.Field33B;
import de.businesslogics.format.swift.Field36;
import de.businesslogics.format.swift.Field50F;
import de.businesslogics.format.swift.Field50G;
import de.businesslogics.format.swift.Field50H;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.Field56A;
import de.businesslogics.format.swift.Field56C;
import de.businesslogics.format.swift.Field57A;
import de.businesslogics.format.swift.Field57C;
import de.businesslogics.format.swift.Field59;
import de.businesslogics.format.swift.Field59A;
import de.businesslogics.format.swift.Field70;
import de.businesslogics.format.swift.Field71A;
import de.businesslogics.format.swift.InstructionCode;
import de.businesslogics.format.swift.Intermediary;
import de.businesslogics.format.swift.OrderingCustomer;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101SequenceA;
import de.businesslogics.format.swift.mt101.MT101SequenceB;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class MT101PaymentData {
    public static final String[] FEE_TYPES = new String[]{Field71A.OUR.toString(), Field71A.BEN.toString(), Field71A.SHA.toString()};
    private static final SimpleDateFormat yyMMdd = new SimpleDateFormat("yyMMdd");
    private static final String SEPARATOR = "|";
    public static final Pattern SWIFT = RegularExpressions.SWIFT.getPattern();
    static final String BANKCODE_PREFIX = "//";
    public static final int MAX_LENGTH_SENDER_REFERENCE = 16;
    public static final int MAX_LENGTH_ADDITIONAL_INSTRUCTION_INFO = 30;
    public static final int MAX_LENGTH_ORIGINATOR_ACCOUNT_NUMER = 34;
    public static final int MAX_LENGTH_ORIGINATOR = 35;
    public static final int MAX_LENGTH_RECIPIENT_ACCOUNT_NUMER = 34;
    public static final int MAX_LENGTH_RECIPIENT = 35;
    public static final BigDecimal MAX_AMOUNT = new BigDecimal("999999999999.99");
    public static final int MAX_LENGTH_PURPOSE = 35;
    private String senderBic;
    private String receiverBic;
    private String originatorBic;
    private String originatorAccount;
    private String[] originatorAddress;
    private String recipientAccount;
    private String recipientBankCode;
    private String[] recipientAddress;
    private String intermediaryBankCode;
    private String senderReference;
    private String executionDate;
    private String transactionReference;
    private Field23E[] instructionCodes;
    private BigDecimal amount;
    private Currency currency;
    private BigDecimal amountInCounterValueCurrency;
    private Currency counterValueCurrency;
    private BigDecimal exchangeRate;
    private String[] purposeArray;
    private String feeType;
    private String feeAccount;

    public MT101PaymentData() {
    }

    public MT101PaymentData(String senderBic, String receiverBic, MT101SequenceA sequenceA, MT101SequenceB sequenceB) {
        AccountWithInstitution recipientBank;
        Beneficiary beneficiary;
        AccountServicingInstitution accountServicingInstitution;
        this.senderBic = senderBic;
        this.receiverBic = receiverBic;
        this.originatorBic = receiverBic;
        OrderingCustomer orderingCustomer = this.getOrderingCustomer(sequenceA, sequenceB);
        if (orderingCustomer != null) {
            this.originatorAccount = orderingCustomer.getAccount();
            if (orderingCustomer instanceof Field50F) {
                Field50F f50F = (Field50F)orderingCustomer;
                this.originatorAddress = f50F.getAddress();
                this.originatorAccount = f50F.getAccount();
            } else if (orderingCustomer instanceof Field50G) {
                Field50G f50G = (Field50G)orderingCustomer;
                this.originatorAccount = f50G.getAccount();
            } else if (orderingCustomer instanceof Field50H) {
                Field50H f50H = (Field50H)orderingCustomer;
                this.originatorAddress = f50H.getAddress();
                this.originatorAccount = f50H.getAccount();
            }
        }
        if ((accountServicingInstitution = this.getAccountServicingInstitution(sequenceA, sequenceB)) != null && accountServicingInstitution instanceof Field52A) {
            this.originatorBic = ((Field52A)accountServicingInstitution).getBIC();
        }
        if ((beneficiary = sequenceB.getBeneficiary()) instanceof Field59) {
            Field59 f59 = (Field59)beneficiary;
            this.recipientAccount = f59.getAccount();
            this.recipientAddress = f59.getAddress();
        } else if (beneficiary instanceof Field59A) {
            Field59A f59A = (Field59A)beneficiary;
            this.recipientAccount = f59A.getAccount();
            this.recipientBankCode = f59A.getBic();
        }
        Intermediary intermediary = sequenceB.getIntermediary();
        if (intermediary instanceof Field56A) {
            this.intermediaryBankCode = ((Field56A)intermediary).getBIC();
        } else if (intermediary instanceof Field56C) {
            this.intermediaryBankCode = ((Field56C)intermediary).getBankcode();
        }
        if (this.intermediaryBankCode != null && this.intermediaryBankCode.startsWith(BANKCODE_PREFIX)) {
            this.intermediaryBankCode = this.intermediaryBankCode.substring(BANKCODE_PREFIX.length());
        }
        if ((recipientBank = sequenceB.getAccountWithInstitution()) instanceof Field57A) {
            this.recipientBankCode = ((Field57A)recipientBank).getBIC();
        } else if (recipientBank instanceof Field57C) {
            this.recipientBankCode = ((Field57C)recipientBank).getBankcode();
        }
        if (this.recipientBankCode != null && this.recipientBankCode.startsWith(BANKCODE_PREFIX)) {
            this.recipientBankCode = this.recipientBankCode.substring(BANKCODE_PREFIX.length());
        }
        this.senderReference = sequenceA.getSendersReference().getReference();
        this.executionDate = sequenceA.getRequestedExecutionDate().getDate();
        this.transactionReference = sequenceB.getTransactionReference().getReference();
        Field32B f32B = sequenceB.getTransactionAmount();
        BigDecimal amountFrom32B = f32B.getAmount();
        Currency currencyFrom32B = f32B.getCurrency();
        Field33B f33B = sequenceB.getOriginalOrderedAmount();
        if (f33B != null) {
            this.amount = f33B.getAmount();
            this.currency = f33B.getCurrency();
            this.amountInCounterValueCurrency = amountFrom32B;
            this.counterValueCurrency = currencyFrom32B;
            Field36 f36 = sequenceB.getExchangeRate();
            if (f36 != null) {
                this.exchangeRate = f36.getRate();
            }
        } else {
            this.amount = amountFrom32B;
            this.currency = currencyFrom32B;
        }
        Field70 f70 = sequenceB.getRemittanceInformation();
        if (f70 != null) {
            this.purposeArray = f70.getInformation();
        }
        this.feeType = sequenceB.getDetailsOfCharges().toString();
        Field25A f25A = sequenceB.getChargesAccount();
        if (f25A != null) {
            this.feeAccount = f25A.getAccount();
        }
        this.instructionCodes = sequenceB.getInstructionCodes();
    }

    private OrderingCustomer getOrderingCustomer(MT101SequenceA sequenceA, MT101SequenceB sequenceB) {
        if (sequenceA.getOrderingCustomer() != null) {
            return sequenceA.getOrderingCustomer();
        }
        return sequenceB.getOrderingCustomer();
    }

    private AccountServicingInstitution getAccountServicingInstitution(MT101SequenceA sequenceA, MT101SequenceB sequenceB) {
        if (sequenceA.getAccountServicingInstitution() != null) {
            return sequenceA.getAccountServicingInstitution();
        }
        return sequenceB.getAccountServicingInstitution();
    }

    public void writeTo(Writer w, boolean saveAccountCurrency) throws IOException {
        MT101SequenceB sequenceB = this.createSequenceB(saveAccountCurrency);
        sequenceB.writeTo(w);
    }

    private MT101SequenceB createSequenceB(boolean saveAccountCurrency) {
        Field21 f21 = new Field21(this.transactionReference);
        boolean allocateField33B = this.counterValueCurrency != null;
        Field32B f32B = allocateField33B ? new Field32B(this.counterValueCurrency, this.amountInCounterValueCurrency) : new Field32B(this.currency, this.amount);
        Beneficiary beneficiary = null;
        if (this.recipientAddress != null && this.recipientAddress.length > 0) {
            Field59 f59 = new Field59(this.recipientAddress);
            f59.setAccount(this.recipientAccount);
            beneficiary = f59;
        } else {
            Field59A f59A = new Field59A(this.recipientBankCode);
            f59A.setAccount(this.recipientAccount);
            beneficiary = f59A;
        }
        Field71A f71A = Field71A.getInstance(this.feeType);
        MT101SequenceB sequenceB = new MT101SequenceB(f21, f32B, beneficiary, f71A);
        if (this.instructionCodes != null) {
            sequenceB.setInstructionCodes(this.instructionCodes);
        }
        if (this.recipientBankCode != null && this.recipientBankCode.trim().length() > 0) {
            if (PaymentUtils.isBIC(this.recipientBankCode.trim())) {
                sequenceB.setAccountWithInstitution(new Field57A(this.recipientBankCode.trim()));
            } else {
                sequenceB.setAccountWithInstitution(new Field57C(BANKCODE_PREFIX + this.recipientBankCode.trim()));
            }
        }
        if (this.intermediaryBankCode != null && this.intermediaryBankCode.trim().length() > 0) {
            if (PaymentUtils.isBIC(this.intermediaryBankCode.trim())) {
                sequenceB.setIntermediary(new Field56A(this.intermediaryBankCode.trim()));
            } else {
                sequenceB.setIntermediary(new Field56C(BANKCODE_PREFIX + this.intermediaryBankCode.trim()));
            }
        }
        if (this.purposeArray != null && this.purposeArray.length > 0) {
            sequenceB.setRemittanceInformation(new Field70(this.purposeArray));
        }
        if (allocateField33B) {
            sequenceB.setOriginalOrderedAmount(new Field33B(this.currency, this.amount));
        }
        if (this.feeAccount != null && this.feeAccount.trim().length() > 0) {
            sequenceB.setChargesAccount(new Field25A(this.feeAccount.trim()));
        }
        return sequenceB;
    }

    public String getSenderBic() {
        return this.senderBic;
    }

    public void setSenderBic(String senderBic) {
        this.senderBic = senderBic;
    }

    public String getReceiverBic() {
        return this.receiverBic;
    }

    public void setReceiverBic(String receiverBic) {
        this.receiverBic = receiverBic;
    }

    public String getSenderReference() {
        return this.senderReference;
    }

    public void setSenderReference(String senderReference) {
        this.senderReference = senderReference;
    }

    public String getOriginatorBic() {
        return this.originatorBic;
    }

    public void setOriginatorBic(String originatorBic) {
        this.originatorBic = originatorBic;
    }

    public String getOriginatorAccount() {
        return this.originatorAccount;
    }

    public void setOriginatorAccount(String originatorAccount) {
        this.originatorAccount = originatorAccount;
    }

    public String[] getOriginatorAddress() {
        return this.originatorAddress;
    }

    public void setOriginatorAddress(String[] originatorAddress) {
        this.originatorAddress = originatorAddress;
    }

    public String getOriginatorName() {
        return StringUtils.getElement(this.originatorAddress, 0);
    }

    public String getOriginatorName2() {
        return StringUtils.getElement(this.originatorAddress, 1);
    }

    public String getOriginatorStreet() {
        return StringUtils.getElement(this.originatorAddress, 2);
    }

    public String getOriginatorTown() {
        return StringUtils.getElement(this.originatorAddress, 3);
    }

    public String[] getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String[] recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public String getRecipientName() {
        return StringUtils.getElement(this.recipientAddress, 0);
    }

    public String getRecipientName2() {
        return StringUtils.getElement(this.recipientAddress, 1);
    }

    public String getRecipientStreet() {
        return StringUtils.getElement(this.recipientAddress, 2);
    }

    public String getRecipientTown() {
        return StringUtils.getElement(this.recipientAddress, 3);
    }

    public String getRecipientAccount() {
        return this.recipientAccount;
    }

    public void setRecipientAccount(String recipientAccount) {
        this.recipientAccount = recipientAccount;
    }

    public String getRecipientBankCode() {
        return this.recipientBankCode;
    }

    public void setRecipientBankCode(String recipientBankCode) {
        this.recipientBankCode = recipientBankCode;
    }

    public String getIntermediaryBankCode() {
        return this.intermediaryBankCode;
    }

    public void setIntermediaryBankCode(String intermediaryBankCode) {
        this.intermediaryBankCode = intermediaryBankCode;
    }

    public String[] getPurposeArray() {
        return this.purposeArray;
    }

    public void setPurposeArray(String[] purposeArray) {
        this.purposeArray = purposeArray;
    }

    public String getPurpose() {
        return StringUtils.getElement(this.purposeArray, 0);
    }

    public String getPurpose2() {
        return StringUtils.getElement(this.purposeArray, 1);
    }

    public String getPurpose3() {
        return StringUtils.getElement(this.purposeArray, 2);
    }

    public String getPurpose4() {
        return StringUtils.getElement(this.purposeArray, 3);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public boolean isCounterValuePayment() {
        if (this.instructionCodes != null) {
            for (Field23E field23E : this.instructionCodes) {
                if (!InstructionCode.EQUI.equals(field23E.getInstructionCode())) continue;
                return true;
            }
        }
        return false;
    }

    public Currency getCounterValueCurrency() {
        return this.counterValueCurrency;
    }

    public void setCounterValueCurrency(Currency counterValueCurrency) {
        this.counterValueCurrency = counterValueCurrency;
    }

    public BigDecimal getAmountInCounterValueCurrency() {
        return this.amountInCounterValueCurrency;
    }

    public void setAmountInCounterValueCurrency(BigDecimal amountInCounterValueCurrency) {
        this.amountInCounterValueCurrency = amountInCounterValueCurrency;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getTransactionReference() {
        return this.transactionReference;
    }

    public void setTransactionReference(String reference) {
        this.transactionReference = reference;
    }

    public String getExecutionDate() {
        return this.executionDate;
    }

    @Deprecated
    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public Date getExecutionDateAsDate() throws ParseException {
        return yyMMdd.parse(this.executionDate);
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = yyMMdd.format(executionDate);
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getFeeAccount() {
        return this.feeAccount;
    }

    public void setFeeAccount(String feeAccount) {
        this.feeAccount = feeAccount;
    }

    public Field23E[] getInstructionCodes() {
        return this.instructionCodes;
    }

    public void setInstructionCodes(Field23E[] instructionCodes) {
        this.instructionCodes = instructionCodes;
    }

    public String[] getInstructionCodeArray() {
        if (this.instructionCodes != null && this.instructionCodes.length > 0) {
            String[] instructionCodeArray = new String[this.instructionCodes.length];
            for (int i = 0; i < this.instructionCodes.length; ++i) {
                StringBuilder sb = new StringBuilder(this.instructionCodes[i].getInstructionCode().toString());
                String additionalInfo = this.instructionCodes[i].getAdditionalInformation();
                if (additionalInfo != null && additionalInfo.length() > 0) {
                    sb.append('/');
                    sb.append(additionalInfo);
                }
                instructionCodeArray[i] = sb.toString();
            }
            return instructionCodeArray;
        }
        return null;
    }

    public void save(OutputStream out, boolean structuredHeader, boolean saveAccountCurrency, int sessionNumber, int sequenceNumber) throws IOException {
        new MT101LogicalFile(this).save(out, structuredHeader, saveAccountCurrency, sessionNumber, sequenceNumber);
    }

    public String getLogicalFileKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.checkForNull(this.senderBic));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(this.receiverBic));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(this.originatorBic));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(this.originatorAccount));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(StringUtils.getElement(this.originatorAddress, 0)));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(StringUtils.getElement(this.originatorAddress, 1)));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(StringUtils.getElement(this.originatorAddress, 2)));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(StringUtils.getElement(this.originatorAddress, 3)));
        sb.append(SEPARATOR);
        sb.append(this.checkForNull(this.executionDate));
        return sb.toString();
    }

    private String checkForNull(String s) {
        return s != null ? s : "";
    }
}

